/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCommandRequest extends IotRequest implements
        ToCopyableBuilder<CreateCommandRequest.Builder, CreateCommandRequest> {
    private static final SdkField<String> COMMAND_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("commandId").getter(getter(CreateCommandRequest::commandId)).setter(setter(Builder::commandId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("commandId").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(CreateCommandRequest::namespaceAsString)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(CreateCommandRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateCommandRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<CommandPayload> PAYLOAD_FIELD = SdkField.<CommandPayload> builder(MarshallingType.SDK_POJO)
            .memberName("payload").getter(getter(CreateCommandRequest::payload)).setter(setter(Builder::payload))
            .constructor(CommandPayload::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build()).build();

    private static final SdkField<List<CommandParameter>> MANDATORY_PARAMETERS_FIELD = SdkField
            .<List<CommandParameter>> builder(MarshallingType.LIST)
            .memberName("mandatoryParameters")
            .getter(getter(CreateCommandRequest::mandatoryParameters))
            .setter(setter(Builder::mandatoryParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mandatoryParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CommandParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CommandParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CreateCommandRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateCommandRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMAND_ID_FIELD,
            NAMESPACE_FIELD, DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, PAYLOAD_FIELD, MANDATORY_PARAMETERS_FIELD, ROLE_ARN_FIELD,
            TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String commandId;

    private final String namespace;

    private final String displayName;

    private final String description;

    private final CommandPayload payload;

    private final List<CommandParameter> mandatoryParameters;

    private final String roleArn;

    private final List<Tag> tags;

    private CreateCommandRequest(BuilderImpl builder) {
        super(builder);
        this.commandId = builder.commandId;
        this.namespace = builder.namespace;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.payload = builder.payload;
        this.mandatoryParameters = builder.mandatoryParameters;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A unique identifier for the command. We recommend using UUID. Alpha-numeric characters, hyphens, and underscores
     * are valid for use here.
     * </p>
     * 
     * @return A unique identifier for the command. We recommend using UUID. Alpha-numeric characters, hyphens, and
     *         underscores are valid for use here.
     */
    public final String commandId() {
        return commandId;
    }

    /**
     * <p>
     * The namespace of the command. The MQTT reserved topics and validations will be used for command executions
     * according to the namespace setting.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #namespace} will
     * return {@link CommandNamespace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #namespaceAsString}.
     * </p>
     * 
     * @return The namespace of the command. The MQTT reserved topics and validations will be used for command
     *         executions according to the namespace setting.
     * @see CommandNamespace
     */
    public final CommandNamespace namespace() {
        return CommandNamespace.fromValue(namespace);
    }

    /**
     * <p>
     * The namespace of the command. The MQTT reserved topics and validations will be used for command executions
     * according to the namespace setting.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #namespace} will
     * return {@link CommandNamespace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #namespaceAsString}.
     * </p>
     * 
     * @return The namespace of the command. The MQTT reserved topics and validations will be used for command
     *         executions according to the namespace setting.
     * @see CommandNamespace
     */
    public final String namespaceAsString() {
        return namespace;
    }

    /**
     * <p>
     * The user-friendly name in the console for the command. This name doesn't have to be unique. You can update the
     * user-friendly name after you define it.
     * </p>
     * 
     * @return The user-friendly name in the console for the command. This name doesn't have to be unique. You can
     *         update the user-friendly name after you define it.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * A short text decription of the command.
     * </p>
     * 
     * @return A short text decription of the command.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The payload object for the command. You must specify this information when using the <code>AWS-IoT</code>
     * namespace.
     * </p>
     * <p>
     * You can upload a static payload file from your local storage that contains the instructions for the device to
     * process. The payload file can use any format. To make sure that the device correctly interprets the payload, we
     * recommend you to specify the payload content type.
     * </p>
     * 
     * @return The payload object for the command. You must specify this information when using the <code>AWS-IoT</code>
     *         namespace.</p>
     *         <p>
     *         You can upload a static payload file from your local storage that contains the instructions for the
     *         device to process. The payload file can use any format. To make sure that the device correctly interprets
     *         the payload, we recommend you to specify the payload content type.
     */
    public final CommandPayload payload() {
        return payload;
    }

    /**
     * For responses, this returns true if the service returned a value for the MandatoryParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMandatoryParameters() {
        return mandatoryParameters != null && !(mandatoryParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of parameters that are required by the <code>StartCommandExecution</code> API. These parameters need to be
     * specified only when using the <code>AWS-IoT-FleetWise</code> namespace. You can either specify them here or when
     * running the command using the <code>StartCommandExecution</code> API.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMandatoryParameters} method.
     * </p>
     * 
     * @return A list of parameters that are required by the <code>StartCommandExecution</code> API. These parameters
     *         need to be specified only when using the <code>AWS-IoT-FleetWise</code> namespace. You can either specify
     *         them here or when running the command using the <code>StartCommandExecution</code> API.
     */
    public final List<CommandParameter> mandatoryParameters() {
        return mandatoryParameters;
    }

    /**
     * <p>
     * The IAM role that you must provide when using the <code>AWS-IoT-FleetWise</code> namespace. The role grants IoT
     * Device Management the permission to access IoT FleetWise resources for generating the payload for the command.
     * This field is not required when you use the <code>AWS-IoT</code> namespace.
     * </p>
     * 
     * @return The IAM role that you must provide when using the <code>AWS-IoT-FleetWise</code> namespace. The role
     *         grants IoT Device Management the permission to access IoT FleetWise resources for generating the payload
     *         for the command. This field is not required when you use the <code>AWS-IoT</code> namespace.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Name-value pairs that are used as metadata to manage a command.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Name-value pairs that are used as metadata to manage a command.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(commandId());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(payload());
        hashCode = 31 * hashCode + Objects.hashCode(hasMandatoryParameters() ? mandatoryParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCommandRequest)) {
            return false;
        }
        CreateCommandRequest other = (CreateCommandRequest) obj;
        return Objects.equals(commandId(), other.commandId()) && Objects.equals(namespaceAsString(), other.namespaceAsString())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(description(), other.description())
                && Objects.equals(payload(), other.payload()) && hasMandatoryParameters() == other.hasMandatoryParameters()
                && Objects.equals(mandatoryParameters(), other.mandatoryParameters())
                && Objects.equals(roleArn(), other.roleArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCommandRequest").add("CommandId", commandId()).add("Namespace", namespaceAsString())
                .add("DisplayName", displayName()).add("Description", description()).add("Payload", payload())
                .add("MandatoryParameters", hasMandatoryParameters() ? mandatoryParameters() : null).add("RoleArn", roleArn())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "commandId":
            return Optional.ofNullable(clazz.cast(commandId()));
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespaceAsString()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "payload":
            return Optional.ofNullable(clazz.cast(payload()));
        case "mandatoryParameters":
            return Optional.ofNullable(clazz.cast(mandatoryParameters()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("commandId", COMMAND_ID_FIELD);
        map.put("namespace", NAMESPACE_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("payload", PAYLOAD_FIELD);
        map.put("mandatoryParameters", MANDATORY_PARAMETERS_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCommandRequest, T> g) {
        return obj -> g.apply((CreateCommandRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateCommandRequest> {
        /**
         * <p>
         * A unique identifier for the command. We recommend using UUID. Alpha-numeric characters, hyphens, and
         * underscores are valid for use here.
         * </p>
         * 
         * @param commandId
         *        A unique identifier for the command. We recommend using UUID. Alpha-numeric characters, hyphens, and
         *        underscores are valid for use here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandId(String commandId);

        /**
         * <p>
         * The namespace of the command. The MQTT reserved topics and validations will be used for command executions
         * according to the namespace setting.
         * </p>
         * 
         * @param namespace
         *        The namespace of the command. The MQTT reserved topics and validations will be used for command
         *        executions according to the namespace setting.
         * @see CommandNamespace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommandNamespace
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The namespace of the command. The MQTT reserved topics and validations will be used for command executions
         * according to the namespace setting.
         * </p>
         * 
         * @param namespace
         *        The namespace of the command. The MQTT reserved topics and validations will be used for command
         *        executions according to the namespace setting.
         * @see CommandNamespace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommandNamespace
         */
        Builder namespace(CommandNamespace namespace);

        /**
         * <p>
         * The user-friendly name in the console for the command. This name doesn't have to be unique. You can update
         * the user-friendly name after you define it.
         * </p>
         * 
         * @param displayName
         *        The user-friendly name in the console for the command. This name doesn't have to be unique. You can
         *        update the user-friendly name after you define it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * A short text decription of the command.
         * </p>
         * 
         * @param description
         *        A short text decription of the command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The payload object for the command. You must specify this information when using the <code>AWS-IoT</code>
         * namespace.
         * </p>
         * <p>
         * You can upload a static payload file from your local storage that contains the instructions for the device to
         * process. The payload file can use any format. To make sure that the device correctly interprets the payload,
         * we recommend you to specify the payload content type.
         * </p>
         * 
         * @param payload
         *        The payload object for the command. You must specify this information when using the
         *        <code>AWS-IoT</code> namespace.</p>
         *        <p>
         *        You can upload a static payload file from your local storage that contains the instructions for the
         *        device to process. The payload file can use any format. To make sure that the device correctly
         *        interprets the payload, we recommend you to specify the payload content type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(CommandPayload payload);

        /**
         * <p>
         * The payload object for the command. You must specify this information when using the <code>AWS-IoT</code>
         * namespace.
         * </p>
         * <p>
         * You can upload a static payload file from your local storage that contains the instructions for the device to
         * process. The payload file can use any format. To make sure that the device correctly interprets the payload,
         * we recommend you to specify the payload content type.
         * </p>
         * This is a convenience method that creates an instance of the {@link CommandPayload.Builder} avoiding the need
         * to create one manually via {@link CommandPayload#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CommandPayload.Builder#build()} is called immediately and its
         * result is passed to {@link #payload(CommandPayload)}.
         * 
         * @param payload
         *        a consumer that will call methods on {@link CommandPayload.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #payload(CommandPayload)
         */
        default Builder payload(Consumer<CommandPayload.Builder> payload) {
            return payload(CommandPayload.builder().applyMutation(payload).build());
        }

        /**
         * <p>
         * A list of parameters that are required by the <code>StartCommandExecution</code> API. These parameters need
         * to be specified only when using the <code>AWS-IoT-FleetWise</code> namespace. You can either specify them
         * here or when running the command using the <code>StartCommandExecution</code> API.
         * </p>
         * 
         * @param mandatoryParameters
         *        A list of parameters that are required by the <code>StartCommandExecution</code> API. These parameters
         *        need to be specified only when using the <code>AWS-IoT-FleetWise</code> namespace. You can either
         *        specify them here or when running the command using the <code>StartCommandExecution</code> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mandatoryParameters(Collection<CommandParameter> mandatoryParameters);

        /**
         * <p>
         * A list of parameters that are required by the <code>StartCommandExecution</code> API. These parameters need
         * to be specified only when using the <code>AWS-IoT-FleetWise</code> namespace. You can either specify them
         * here or when running the command using the <code>StartCommandExecution</code> API.
         * </p>
         * 
         * @param mandatoryParameters
         *        A list of parameters that are required by the <code>StartCommandExecution</code> API. These parameters
         *        need to be specified only when using the <code>AWS-IoT-FleetWise</code> namespace. You can either
         *        specify them here or when running the command using the <code>StartCommandExecution</code> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mandatoryParameters(CommandParameter... mandatoryParameters);

        /**
         * <p>
         * A list of parameters that are required by the <code>StartCommandExecution</code> API. These parameters need
         * to be specified only when using the <code>AWS-IoT-FleetWise</code> namespace. You can either specify them
         * here or when running the command using the <code>StartCommandExecution</code> API.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iot.model.CommandParameter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iot.model.CommandParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iot.model.CommandParameter.Builder#build()} is called immediately and
         * its result is passed to {@link #mandatoryParameters(List<CommandParameter>)}.
         * 
         * @param mandatoryParameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iot.model.CommandParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mandatoryParameters(java.util.Collection<CommandParameter>)
         */
        Builder mandatoryParameters(Consumer<CommandParameter.Builder>... mandatoryParameters);

        /**
         * <p>
         * The IAM role that you must provide when using the <code>AWS-IoT-FleetWise</code> namespace. The role grants
         * IoT Device Management the permission to access IoT FleetWise resources for generating the payload for the
         * command. This field is not required when you use the <code>AWS-IoT</code> namespace.
         * </p>
         * 
         * @param roleArn
         *        The IAM role that you must provide when using the <code>AWS-IoT-FleetWise</code> namespace. The role
         *        grants IoT Device Management the permission to access IoT FleetWise resources for generating the
         *        payload for the command. This field is not required when you use the <code>AWS-IoT</code> namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Name-value pairs that are used as metadata to manage a command.
         * </p>
         * 
         * @param tags
         *        Name-value pairs that are used as metadata to manage a command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Name-value pairs that are used as metadata to manage a command.
         * </p>
         * 
         * @param tags
         *        Name-value pairs that are used as metadata to manage a command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Name-value pairs that are used as metadata to manage a command.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iot.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.iot.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.iot.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.iot.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String commandId;

        private String namespace;

        private String displayName;

        private String description;

        private CommandPayload payload;

        private List<CommandParameter> mandatoryParameters = DefaultSdkAutoConstructList.getInstance();

        private String roleArn;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCommandRequest model) {
            super(model);
            commandId(model.commandId);
            namespace(model.namespace);
            displayName(model.displayName);
            description(model.description);
            payload(model.payload);
            mandatoryParameters(model.mandatoryParameters);
            roleArn(model.roleArn);
            tags(model.tags);
        }

        public final String getCommandId() {
            return commandId;
        }

        public final void setCommandId(String commandId) {
            this.commandId = commandId;
        }

        @Override
        public final Builder commandId(String commandId) {
            this.commandId = commandId;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public final Builder namespace(CommandNamespace namespace) {
            this.namespace(namespace == null ? null : namespace.toString());
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final CommandPayload.Builder getPayload() {
            return payload != null ? payload.toBuilder() : null;
        }

        public final void setPayload(CommandPayload.BuilderImpl payload) {
            this.payload = payload != null ? payload.build() : null;
        }

        @Override
        public final Builder payload(CommandPayload payload) {
            this.payload = payload;
            return this;
        }

        public final List<CommandParameter.Builder> getMandatoryParameters() {
            List<CommandParameter.Builder> result = CommandParameterListCopier.copyToBuilder(this.mandatoryParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMandatoryParameters(Collection<CommandParameter.BuilderImpl> mandatoryParameters) {
            this.mandatoryParameters = CommandParameterListCopier.copyFromBuilder(mandatoryParameters);
        }

        @Override
        public final Builder mandatoryParameters(Collection<CommandParameter> mandatoryParameters) {
            this.mandatoryParameters = CommandParameterListCopier.copy(mandatoryParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mandatoryParameters(CommandParameter... mandatoryParameters) {
            mandatoryParameters(Arrays.asList(mandatoryParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mandatoryParameters(Consumer<CommandParameter.Builder>... mandatoryParameters) {
            mandatoryParameters(Stream.of(mandatoryParameters).map(c -> CommandParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCommandRequest build() {
            return new CreateCommandRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
