/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The authorization method used to send messages.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HttpAuthorization implements SdkPojo, Serializable,
        ToCopyableBuilder<HttpAuthorization.Builder, HttpAuthorization> {
    private static final SdkField<SigV4Authorization> SIGV4_FIELD = SdkField
            .<SigV4Authorization> builder(MarshallingType.SDK_POJO).memberName("sigv4").getter(getter(HttpAuthorization::sigv4))
            .setter(setter(Builder::sigv4)).constructor(SigV4Authorization::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sigv4").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIGV4_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SigV4Authorization sigv4;

    private HttpAuthorization(BuilderImpl builder) {
        this.sigv4 = builder.sigv4;
    }

    /**
     * <p>
     * Use Sig V4 authorization. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing
     * Process</a>.
     * </p>
     * 
     * @return Use Sig V4 authorization. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing
     *         Process</a>.
     */
    public final SigV4Authorization sigv4() {
        return sigv4;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sigv4());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpAuthorization)) {
            return false;
        }
        HttpAuthorization other = (HttpAuthorization) obj;
        return Objects.equals(sigv4(), other.sigv4());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HttpAuthorization").add("Sigv4", sigv4()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sigv4":
            return Optional.ofNullable(clazz.cast(sigv4()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sigv4", SIGV4_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HttpAuthorization, T> g) {
        return obj -> g.apply((HttpAuthorization) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HttpAuthorization> {
        /**
         * <p>
         * Use Sig V4 authorization. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing
         * Process</a>.
         * </p>
         * 
         * @param sigv4
         *        Use Sig V4 authorization. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4
         *        Signing Process</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sigv4(SigV4Authorization sigv4);

        /**
         * <p>
         * Use Sig V4 authorization. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing
         * Process</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link SigV4Authorization.Builder} avoiding the
         * need to create one manually via {@link SigV4Authorization#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SigV4Authorization.Builder#build()} is called immediately and its
         * result is passed to {@link #sigv4(SigV4Authorization)}.
         * 
         * @param sigv4
         *        a consumer that will call methods on {@link SigV4Authorization.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sigv4(SigV4Authorization)
         */
        default Builder sigv4(Consumer<SigV4Authorization.Builder> sigv4) {
            return sigv4(SigV4Authorization.builder().applyMutation(sigv4).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SigV4Authorization sigv4;

        private BuilderImpl() {
        }

        private BuilderImpl(HttpAuthorization model) {
            sigv4(model.sigv4);
        }

        public final SigV4Authorization.Builder getSigv4() {
            return sigv4 != null ? sigv4.toBuilder() : null;
        }

        public final void setSigv4(SigV4Authorization.BuilderImpl sigv4) {
            this.sigv4 = sigv4 != null ? sigv4.build() : null;
        }

        @Override
        public final Builder sigv4(SigV4Authorization sigv4) {
            this.sigv4 = sigv4;
            return this;
        }

        @Override
        public HttpAuthorization build() {
            return new HttpAuthorization(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
