/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the principal and the type of relation it has with the thing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThingPrincipalObject implements SdkPojo, Serializable,
        ToCopyableBuilder<ThingPrincipalObject.Builder, ThingPrincipalObject> {
    private static final SdkField<String> PRINCIPAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("principal").getter(getter(ThingPrincipalObject::principal)).setter(setter(Builder::principal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build()).build();

    private static final SdkField<String> THING_PRINCIPAL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingPrincipalType").getter(getter(ThingPrincipalObject::thingPrincipalTypeAsString))
            .setter(setter(Builder::thingPrincipalType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingPrincipalType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRINCIPAL_FIELD,
            THING_PRINCIPAL_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String principal;

    private final String thingPrincipalType;

    private ThingPrincipalObject(BuilderImpl builder) {
        this.principal = builder.principal;
        this.thingPrincipalType = builder.thingPrincipalType;
    }

    /**
     * <p>
     * The principal of the thing principal object.
     * </p>
     * 
     * @return The principal of the thing principal object.
     */
    public final String principal() {
        return principal;
    }

    /**
     * <p>
     * The type of the relation you want to specify when you attach a principal to a thing. The value defaults to
     * <code>NON_EXCLUSIVE_THING</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>EXCLUSIVE_THING</code> - Attaches the specified principal to the specified thing, exclusively. The thing
     * will be the only thing that’s attached to the principal.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>NON_EXCLUSIVE_THING</code> - Attaches the specified principal to the specified thing. Multiple things can
     * be attached to the principal.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #thingPrincipalType} will return {@link ThingPrincipalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #thingPrincipalTypeAsString}.
     * </p>
     * 
     * @return The type of the relation you want to specify when you attach a principal to a thing. The value defaults
     *         to <code>NON_EXCLUSIVE_THING</code>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>EXCLUSIVE_THING</code> - Attaches the specified principal to the specified thing, exclusively. The
     *         thing will be the only thing that’s attached to the principal.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NON_EXCLUSIVE_THING</code> - Attaches the specified principal to the specified thing. Multiple
     *         things can be attached to the principal.
     *         </p>
     *         </li>
     * @see ThingPrincipalType
     */
    public final ThingPrincipalType thingPrincipalType() {
        return ThingPrincipalType.fromValue(thingPrincipalType);
    }

    /**
     * <p>
     * The type of the relation you want to specify when you attach a principal to a thing. The value defaults to
     * <code>NON_EXCLUSIVE_THING</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>EXCLUSIVE_THING</code> - Attaches the specified principal to the specified thing, exclusively. The thing
     * will be the only thing that’s attached to the principal.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>NON_EXCLUSIVE_THING</code> - Attaches the specified principal to the specified thing. Multiple things can
     * be attached to the principal.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #thingPrincipalType} will return {@link ThingPrincipalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #thingPrincipalTypeAsString}.
     * </p>
     * 
     * @return The type of the relation you want to specify when you attach a principal to a thing. The value defaults
     *         to <code>NON_EXCLUSIVE_THING</code>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>EXCLUSIVE_THING</code> - Attaches the specified principal to the specified thing, exclusively. The
     *         thing will be the only thing that’s attached to the principal.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NON_EXCLUSIVE_THING</code> - Attaches the specified principal to the specified thing. Multiple
     *         things can be attached to the principal.
     *         </p>
     *         </li>
     * @see ThingPrincipalType
     */
    public final String thingPrincipalTypeAsString() {
        return thingPrincipalType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(principal());
        hashCode = 31 * hashCode + Objects.hashCode(thingPrincipalTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingPrincipalObject)) {
            return false;
        }
        ThingPrincipalObject other = (ThingPrincipalObject) obj;
        return Objects.equals(principal(), other.principal())
                && Objects.equals(thingPrincipalTypeAsString(), other.thingPrincipalTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ThingPrincipalObject").add("Principal", principal())
                .add("ThingPrincipalType", thingPrincipalTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "principal":
            return Optional.ofNullable(clazz.cast(principal()));
        case "thingPrincipalType":
            return Optional.ofNullable(clazz.cast(thingPrincipalTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("principal", PRINCIPAL_FIELD);
        map.put("thingPrincipalType", THING_PRINCIPAL_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ThingPrincipalObject, T> g) {
        return obj -> g.apply((ThingPrincipalObject) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThingPrincipalObject> {
        /**
         * <p>
         * The principal of the thing principal object.
         * </p>
         * 
         * @param principal
         *        The principal of the thing principal object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(String principal);

        /**
         * <p>
         * The type of the relation you want to specify when you attach a principal to a thing. The value defaults to
         * <code>NON_EXCLUSIVE_THING</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>EXCLUSIVE_THING</code> - Attaches the specified principal to the specified thing, exclusively. The
         * thing will be the only thing that’s attached to the principal.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * <code>NON_EXCLUSIVE_THING</code> - Attaches the specified principal to the specified thing. Multiple things
         * can be attached to the principal.
         * </p>
         * </li>
         * </ul>
         * 
         * @param thingPrincipalType
         *        The type of the relation you want to specify when you attach a principal to a thing. The value
         *        defaults to <code>NON_EXCLUSIVE_THING</code>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>EXCLUSIVE_THING</code> - Attaches the specified principal to the specified thing, exclusively.
         *        The thing will be the only thing that’s attached to the principal.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NON_EXCLUSIVE_THING</code> - Attaches the specified principal to the specified thing. Multiple
         *        things can be attached to the principal.
         *        </p>
         *        </li>
         * @see ThingPrincipalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThingPrincipalType
         */
        Builder thingPrincipalType(String thingPrincipalType);

        /**
         * <p>
         * The type of the relation you want to specify when you attach a principal to a thing. The value defaults to
         * <code>NON_EXCLUSIVE_THING</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>EXCLUSIVE_THING</code> - Attaches the specified principal to the specified thing, exclusively. The
         * thing will be the only thing that’s attached to the principal.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * <code>NON_EXCLUSIVE_THING</code> - Attaches the specified principal to the specified thing. Multiple things
         * can be attached to the principal.
         * </p>
         * </li>
         * </ul>
         * 
         * @param thingPrincipalType
         *        The type of the relation you want to specify when you attach a principal to a thing. The value
         *        defaults to <code>NON_EXCLUSIVE_THING</code>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>EXCLUSIVE_THING</code> - Attaches the specified principal to the specified thing, exclusively.
         *        The thing will be the only thing that’s attached to the principal.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NON_EXCLUSIVE_THING</code> - Attaches the specified principal to the specified thing. Multiple
         *        things can be attached to the principal.
         *        </p>
         *        </li>
         * @see ThingPrincipalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThingPrincipalType
         */
        Builder thingPrincipalType(ThingPrincipalType thingPrincipalType);
    }

    static final class BuilderImpl implements Builder {
        private String principal;

        private String thingPrincipalType;

        private BuilderImpl() {
        }

        private BuilderImpl(ThingPrincipalObject model) {
            principal(model.principal);
            thingPrincipalType(model.thingPrincipalType);
        }

        public final String getPrincipal() {
            return principal;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        @Override
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        public final String getThingPrincipalType() {
            return thingPrincipalType;
        }

        public final void setThingPrincipalType(String thingPrincipalType) {
            this.thingPrincipalType = thingPrincipalType;
        }

        @Override
        public final Builder thingPrincipalType(String thingPrincipalType) {
            this.thingPrincipalType = thingPrincipalType;
            return this;
        }

        @Override
        public final Builder thingPrincipalType(ThingPrincipalType thingPrincipalType) {
            this.thingPrincipalType(thingPrincipalType == null ? null : thingPrincipalType.toString());
            return this;
        }

        @Override
        public ThingPrincipalObject build() {
            return new ThingPrincipalObject(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
