/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetThingConnectivityDataResponse extends IotResponse implements
        ToCopyableBuilder<GetThingConnectivityDataResponse.Builder, GetThingConnectivityDataResponse> {
    private static final SdkField<String> THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingName").getter(getter(GetThingConnectivityDataResponse::thingName))
            .setter(setter(Builder::thingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingName").build()).build();

    private static final SdkField<Boolean> CONNECTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("connected").getter(getter(GetThingConnectivityDataResponse::connected))
            .setter(setter(Builder::connected))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connected").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("timestamp").getter(getter(GetThingConnectivityDataResponse::timestamp))
            .setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()).build();

    private static final SdkField<String> DISCONNECT_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("disconnectReason").getter(getter(GetThingConnectivityDataResponse::disconnectReasonAsString))
            .setter(setter(Builder::disconnectReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disconnectReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_NAME_FIELD,
            CONNECTED_FIELD, TIMESTAMP_FIELD, DISCONNECT_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String thingName;

    private final Boolean connected;

    private final Instant timestamp;

    private final String disconnectReason;

    private GetThingConnectivityDataResponse(BuilderImpl builder) {
        super(builder);
        this.thingName = builder.thingName;
        this.connected = builder.connected;
        this.timestamp = builder.timestamp;
        this.disconnectReason = builder.disconnectReason;
    }

    /**
     * <p>
     * The name of your IoT thing.
     * </p>
     * 
     * @return The name of your IoT thing.
     */
    public final String thingName() {
        return thingName;
    }

    /**
     * <p>
     * A Boolean that indicates the connectivity status.
     * </p>
     * 
     * @return A Boolean that indicates the connectivity status.
     */
    public final Boolean connected() {
        return connected;
    }

    /**
     * <p>
     * The timestamp of when the event occurred.
     * </p>
     * 
     * @return The timestamp of when the event occurred.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The reason why the client is disconnecting.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #disconnectReason}
     * will return {@link DisconnectReasonValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #disconnectReasonAsString}.
     * </p>
     * 
     * @return The reason why the client is disconnecting.
     * @see DisconnectReasonValue
     */
    public final DisconnectReasonValue disconnectReason() {
        return DisconnectReasonValue.fromValue(disconnectReason);
    }

    /**
     * <p>
     * The reason why the client is disconnecting.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #disconnectReason}
     * will return {@link DisconnectReasonValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #disconnectReasonAsString}.
     * </p>
     * 
     * @return The reason why the client is disconnecting.
     * @see DisconnectReasonValue
     */
    public final String disconnectReasonAsString() {
        return disconnectReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(connected());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(disconnectReasonAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetThingConnectivityDataResponse)) {
            return false;
        }
        GetThingConnectivityDataResponse other = (GetThingConnectivityDataResponse) obj;
        return Objects.equals(thingName(), other.thingName()) && Objects.equals(connected(), other.connected())
                && Objects.equals(timestamp(), other.timestamp())
                && Objects.equals(disconnectReasonAsString(), other.disconnectReasonAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetThingConnectivityDataResponse")
                .add("ThingName", thingName() == null ? null : "*** Sensitive Data Redacted ***").add("Connected", connected())
                .add("Timestamp", timestamp()).add("DisconnectReason", disconnectReasonAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingName":
            return Optional.ofNullable(clazz.cast(thingName()));
        case "connected":
            return Optional.ofNullable(clazz.cast(connected()));
        case "timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "disconnectReason":
            return Optional.ofNullable(clazz.cast(disconnectReasonAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("thingName", THING_NAME_FIELD);
        map.put("connected", CONNECTED_FIELD);
        map.put("timestamp", TIMESTAMP_FIELD);
        map.put("disconnectReason", DISCONNECT_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetThingConnectivityDataResponse, T> g) {
        return obj -> g.apply((GetThingConnectivityDataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetThingConnectivityDataResponse> {
        /**
         * <p>
         * The name of your IoT thing.
         * </p>
         * 
         * @param thingName
         *        The name of your IoT thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * A Boolean that indicates the connectivity status.
         * </p>
         * 
         * @param connected
         *        A Boolean that indicates the connectivity status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connected(Boolean connected);

        /**
         * <p>
         * The timestamp of when the event occurred.
         * </p>
         * 
         * @param timestamp
         *        The timestamp of when the event occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * The reason why the client is disconnecting.
         * </p>
         * 
         * @param disconnectReason
         *        The reason why the client is disconnecting.
         * @see DisconnectReasonValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DisconnectReasonValue
         */
        Builder disconnectReason(String disconnectReason);

        /**
         * <p>
         * The reason why the client is disconnecting.
         * </p>
         * 
         * @param disconnectReason
         *        The reason why the client is disconnecting.
         * @see DisconnectReasonValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DisconnectReasonValue
         */
        Builder disconnectReason(DisconnectReasonValue disconnectReason);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String thingName;

        private Boolean connected;

        private Instant timestamp;

        private String disconnectReason;

        private BuilderImpl() {
        }

        private BuilderImpl(GetThingConnectivityDataResponse model) {
            super(model);
            thingName(model.thingName);
            connected(model.connected);
            timestamp(model.timestamp);
            disconnectReason(model.disconnectReason);
        }

        public final String getThingName() {
            return thingName;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final Boolean getConnected() {
            return connected;
        }

        public final void setConnected(Boolean connected) {
            this.connected = connected;
        }

        @Override
        public final Builder connected(Boolean connected) {
            this.connected = connected;
            return this;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getDisconnectReason() {
            return disconnectReason;
        }

        public final void setDisconnectReason(String disconnectReason) {
            this.disconnectReason = disconnectReason;
        }

        @Override
        public final Builder disconnectReason(String disconnectReason) {
            this.disconnectReason = disconnectReason;
            return this;
        }

        @Override
        public final Builder disconnectReason(DisconnectReasonValue disconnectReason) {
            this.disconnectReason(disconnectReason == null ? null : disconnectReason.toString());
            return this;
        }

        @Override
        public GetThingConnectivityDataResponse build() {
            return new GetThingConnectivityDataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
