/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEncryptionConfigurationRequest extends IotRequest implements
        ToCopyableBuilder<UpdateEncryptionConfigurationRequest.Builder, UpdateEncryptionConfigurationRequest> {
    private static final SdkField<String> ENCRYPTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("encryptionType").getter(getter(UpdateEncryptionConfigurationRequest::encryptionTypeAsString))
            .setter(setter(Builder::encryptionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionType").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyArn").getter(getter(UpdateEncryptionConfigurationRequest::kmsKeyArn))
            .setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()).build();

    private static final SdkField<String> KMS_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsAccessRoleArn").getter(getter(UpdateEncryptionConfigurationRequest::kmsAccessRoleArn))
            .setter(setter(Builder::kmsAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsAccessRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_TYPE_FIELD,
            KMS_KEY_ARN_FIELD, KMS_ACCESS_ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String encryptionType;

    private final String kmsKeyArn;

    private final String kmsAccessRoleArn;

    private UpdateEncryptionConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.encryptionType = builder.encryptionType;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.kmsAccessRoleArn = builder.kmsAccessRoleArn;
    }

    /**
     * <p>
     * The type of the Amazon Web Services Key Management Service (KMS) key.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionType}
     * will return {@link EncryptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionTypeAsString}.
     * </p>
     * 
     * @return The type of the Amazon Web Services Key Management Service (KMS) key.
     * @see EncryptionType
     */
    public final EncryptionType encryptionType() {
        return EncryptionType.fromValue(encryptionType);
    }

    /**
     * <p>
     * The type of the Amazon Web Services Key Management Service (KMS) key.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionType}
     * will return {@link EncryptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionTypeAsString}.
     * </p>
     * 
     * @return The type of the Amazon Web Services Key Management Service (KMS) key.
     * @see EncryptionType
     */
    public final String encryptionTypeAsString() {
        return encryptionType;
    }

    /**
     * <p>
     * The ARN of the customer-managed KMS key.
     * </p>
     * 
     * @return The ARN of the customer-managed KMS key.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role assumed by Amazon Web Services IoT Core to call KMS on behalf of
     * the customer.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role assumed by Amazon Web Services IoT Core to call KMS on
     *         behalf of the customer.
     */
    public final String kmsAccessRoleArn() {
        return kmsAccessRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(encryptionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(kmsAccessRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEncryptionConfigurationRequest)) {
            return false;
        }
        UpdateEncryptionConfigurationRequest other = (UpdateEncryptionConfigurationRequest) obj;
        return Objects.equals(encryptionTypeAsString(), other.encryptionTypeAsString())
                && Objects.equals(kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(kmsAccessRoleArn(), other.kmsAccessRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateEncryptionConfigurationRequest").add("EncryptionType", encryptionTypeAsString())
                .add("KmsKeyArn", kmsKeyArn()).add("KmsAccessRoleArn", kmsAccessRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "encryptionType":
            return Optional.ofNullable(clazz.cast(encryptionTypeAsString()));
        case "kmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "kmsAccessRoleArn":
            return Optional.ofNullable(clazz.cast(kmsAccessRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("encryptionType", ENCRYPTION_TYPE_FIELD);
        map.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("kmsAccessRoleArn", KMS_ACCESS_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateEncryptionConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateEncryptionConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateEncryptionConfigurationRequest> {
        /**
         * <p>
         * The type of the Amazon Web Services Key Management Service (KMS) key.
         * </p>
         * 
         * @param encryptionType
         *        The type of the Amazon Web Services Key Management Service (KMS) key.
         * @see EncryptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionType
         */
        Builder encryptionType(String encryptionType);

        /**
         * <p>
         * The type of the Amazon Web Services Key Management Service (KMS) key.
         * </p>
         * 
         * @param encryptionType
         *        The type of the Amazon Web Services Key Management Service (KMS) key.
         * @see EncryptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionType
         */
        Builder encryptionType(EncryptionType encryptionType);

        /**
         * <p>
         * The ARN of the customer-managed KMS key.
         * </p>
         * 
         * @param kmsKeyArn
         *        The ARN of the customer-managed KMS key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role assumed by Amazon Web Services IoT Core to call KMS on behalf
         * of the customer.
         * </p>
         * 
         * @param kmsAccessRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role assumed by Amazon Web Services IoT Core to call KMS on
         *        behalf of the customer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsAccessRoleArn(String kmsAccessRoleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String encryptionType;

        private String kmsKeyArn;

        private String kmsAccessRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEncryptionConfigurationRequest model) {
            super(model);
            encryptionType(model.encryptionType);
            kmsKeyArn(model.kmsKeyArn);
            kmsAccessRoleArn(model.kmsAccessRoleArn);
        }

        public final String getEncryptionType() {
            return encryptionType;
        }

        public final void setEncryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
        }

        @Override
        public final Builder encryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        @Override
        public final Builder encryptionType(EncryptionType encryptionType) {
            this.encryptionType(encryptionType == null ? null : encryptionType.toString());
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final String getKmsAccessRoleArn() {
            return kmsAccessRoleArn;
        }

        public final void setKmsAccessRoleArn(String kmsAccessRoleArn) {
            this.kmsAccessRoleArn = kmsAccessRoleArn;
        }

        @Override
        public final Builder kmsAccessRoleArn(String kmsAccessRoleArn) {
            this.kmsAccessRoleArn = kmsAccessRoleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEncryptionConfigurationRequest build() {
            return new UpdateEncryptionConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
