/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListThingPrincipalsV2Request extends IotRequest implements
        ToCopyableBuilder<ListThingPrincipalsV2Request.Builder, ListThingPrincipalsV2Request> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListThingPrincipalsV2Request::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListThingPrincipalsV2Request::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingName").getter(getter(ListThingPrincipalsV2Request::thingName)).setter(setter(Builder::thingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("thingName").build()).build();

    private static final SdkField<String> THING_PRINCIPAL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingPrincipalType").getter(getter(ListThingPrincipalsV2Request::thingPrincipalTypeAsString))
            .setter(setter(Builder::thingPrincipalType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("thingPrincipalType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, THING_NAME_FIELD, THING_PRINCIPAL_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final Integer maxResults;

    private final String thingName;

    private final String thingPrincipalType;

    private ListThingPrincipalsV2Request(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.thingName = builder.thingName;
        this.thingPrincipalType = builder.thingPrincipalType;
    }

    /**
     * <p>
     * To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise
     * <b>null</b> to receive the first set of results.
     * </p>
     * 
     * @return To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise
     *         <b>null</b> to receive the first set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return in this operation.
     * </p>
     * 
     * @return The maximum number of results to return in this operation.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The name of the thing.
     * </p>
     * 
     * @return The name of the thing.
     */
    public final String thingName() {
        return thingName;
    }

    /**
     * <p>
     * The type of the relation you want to filter in the response. If no value is provided in this field, the response
     * will list all principals, including both the <code>EXCLUSIVE_THING</code> and <code>NON_EXCLUSIVE_THING</code>
     * attachment types.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>EXCLUSIVE_THING</code> - Attaches the specified principal to the specified thing, exclusively. The thing
     * will be the only thing that’s attached to the principal.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>NON_EXCLUSIVE_THING</code> - Attaches the specified principal to the specified thing. Multiple things can
     * be attached to the principal.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #thingPrincipalType} will return {@link ThingPrincipalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #thingPrincipalTypeAsString}.
     * </p>
     * 
     * @return The type of the relation you want to filter in the response. If no value is provided in this field, the
     *         response will list all principals, including both the <code>EXCLUSIVE_THING</code> and
     *         <code>NON_EXCLUSIVE_THING</code> attachment types.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>EXCLUSIVE_THING</code> - Attaches the specified principal to the specified thing, exclusively. The
     *         thing will be the only thing that’s attached to the principal.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NON_EXCLUSIVE_THING</code> - Attaches the specified principal to the specified thing. Multiple
     *         things can be attached to the principal.
     *         </p>
     *         </li>
     * @see ThingPrincipalType
     */
    public final ThingPrincipalType thingPrincipalType() {
        return ThingPrincipalType.fromValue(thingPrincipalType);
    }

    /**
     * <p>
     * The type of the relation you want to filter in the response. If no value is provided in this field, the response
     * will list all principals, including both the <code>EXCLUSIVE_THING</code> and <code>NON_EXCLUSIVE_THING</code>
     * attachment types.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>EXCLUSIVE_THING</code> - Attaches the specified principal to the specified thing, exclusively. The thing
     * will be the only thing that’s attached to the principal.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>NON_EXCLUSIVE_THING</code> - Attaches the specified principal to the specified thing. Multiple things can
     * be attached to the principal.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #thingPrincipalType} will return {@link ThingPrincipalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #thingPrincipalTypeAsString}.
     * </p>
     * 
     * @return The type of the relation you want to filter in the response. If no value is provided in this field, the
     *         response will list all principals, including both the <code>EXCLUSIVE_THING</code> and
     *         <code>NON_EXCLUSIVE_THING</code> attachment types.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>EXCLUSIVE_THING</code> - Attaches the specified principal to the specified thing, exclusively. The
     *         thing will be the only thing that’s attached to the principal.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NON_EXCLUSIVE_THING</code> - Attaches the specified principal to the specified thing. Multiple
     *         things can be attached to the principal.
     *         </p>
     *         </li>
     * @see ThingPrincipalType
     */
    public final String thingPrincipalTypeAsString() {
        return thingPrincipalType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(thingPrincipalTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListThingPrincipalsV2Request)) {
            return false;
        }
        ListThingPrincipalsV2Request other = (ListThingPrincipalsV2Request) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(thingName(), other.thingName())
                && Objects.equals(thingPrincipalTypeAsString(), other.thingPrincipalTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListThingPrincipalsV2Request").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("ThingName", thingName()).add("ThingPrincipalType", thingPrincipalTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "thingName":
            return Optional.ofNullable(clazz.cast(thingName()));
        case "thingPrincipalType":
            return Optional.ofNullable(clazz.cast(thingPrincipalTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("thingName", THING_NAME_FIELD);
        map.put("thingPrincipalType", THING_PRINCIPAL_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListThingPrincipalsV2Request, T> g) {
        return obj -> g.apply((ListThingPrincipalsV2Request) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListThingPrincipalsV2Request> {
        /**
         * <p>
         * To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise
         * <b>null</b> to receive the first set of results.
         * </p>
         * 
         * @param nextToken
         *        To retrieve the next set of results, the <code>nextToken</code> value from a previous response;
         *        otherwise <b>null</b> to receive the first set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return in this operation.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The name of the thing.
         * </p>
         * 
         * @param thingName
         *        The name of the thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * The type of the relation you want to filter in the response. If no value is provided in this field, the
         * response will list all principals, including both the <code>EXCLUSIVE_THING</code> and
         * <code>NON_EXCLUSIVE_THING</code> attachment types.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>EXCLUSIVE_THING</code> - Attaches the specified principal to the specified thing, exclusively. The
         * thing will be the only thing that’s attached to the principal.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * <code>NON_EXCLUSIVE_THING</code> - Attaches the specified principal to the specified thing. Multiple things
         * can be attached to the principal.
         * </p>
         * </li>
         * </ul>
         * 
         * @param thingPrincipalType
         *        The type of the relation you want to filter in the response. If no value is provided in this field,
         *        the response will list all principals, including both the <code>EXCLUSIVE_THING</code> and
         *        <code>NON_EXCLUSIVE_THING</code> attachment types.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>EXCLUSIVE_THING</code> - Attaches the specified principal to the specified thing, exclusively.
         *        The thing will be the only thing that’s attached to the principal.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NON_EXCLUSIVE_THING</code> - Attaches the specified principal to the specified thing. Multiple
         *        things can be attached to the principal.
         *        </p>
         *        </li>
         * @see ThingPrincipalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThingPrincipalType
         */
        Builder thingPrincipalType(String thingPrincipalType);

        /**
         * <p>
         * The type of the relation you want to filter in the response. If no value is provided in this field, the
         * response will list all principals, including both the <code>EXCLUSIVE_THING</code> and
         * <code>NON_EXCLUSIVE_THING</code> attachment types.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>EXCLUSIVE_THING</code> - Attaches the specified principal to the specified thing, exclusively. The
         * thing will be the only thing that’s attached to the principal.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * <code>NON_EXCLUSIVE_THING</code> - Attaches the specified principal to the specified thing. Multiple things
         * can be attached to the principal.
         * </p>
         * </li>
         * </ul>
         * 
         * @param thingPrincipalType
         *        The type of the relation you want to filter in the response. If no value is provided in this field,
         *        the response will list all principals, including both the <code>EXCLUSIVE_THING</code> and
         *        <code>NON_EXCLUSIVE_THING</code> attachment types.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>EXCLUSIVE_THING</code> - Attaches the specified principal to the specified thing, exclusively.
         *        The thing will be the only thing that’s attached to the principal.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NON_EXCLUSIVE_THING</code> - Attaches the specified principal to the specified thing. Multiple
         *        things can be attached to the principal.
         *        </p>
         *        </li>
         * @see ThingPrincipalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThingPrincipalType
         */
        Builder thingPrincipalType(ThingPrincipalType thingPrincipalType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private String thingName;

        private String thingPrincipalType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListThingPrincipalsV2Request model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            thingName(model.thingName);
            thingPrincipalType(model.thingPrincipalType);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getThingName() {
            return thingName;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final String getThingPrincipalType() {
            return thingPrincipalType;
        }

        public final void setThingPrincipalType(String thingPrincipalType) {
            this.thingPrincipalType = thingPrincipalType;
        }

        @Override
        public final Builder thingPrincipalType(String thingPrincipalType) {
            this.thingPrincipalType = thingPrincipalType;
            return this;
        }

        @Override
        public final Builder thingPrincipalType(ThingPrincipalType thingPrincipalType) {
            this.thingPrincipalType(thingPrincipalType == null ? null : thingPrincipalType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListThingPrincipalsV2Request build() {
            return new ListThingPrincipalsV2Request(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
