/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration to add user-defined properties to enrich MQTT 5 messages.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Mqtt5Configuration implements SdkPojo, Serializable,
        ToCopyableBuilder<Mqtt5Configuration.Builder, Mqtt5Configuration> {
    private static final SdkField<List<PropagatingAttribute>> PROPAGATING_ATTRIBUTES_FIELD = SdkField
            .<List<PropagatingAttribute>> builder(MarshallingType.LIST)
            .memberName("propagatingAttributes")
            .getter(getter(Mqtt5Configuration::propagatingAttributes))
            .setter(setter(Builder::propagatingAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propagatingAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PropagatingAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(PropagatingAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPAGATING_ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<PropagatingAttribute> propagatingAttributes;

    private Mqtt5Configuration(BuilderImpl builder) {
        this.propagatingAttributes = builder.propagatingAttributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the PropagatingAttributes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPropagatingAttributes() {
        return propagatingAttributes != null && !(propagatingAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object that represents the propagating thing attributes and the connection attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPropagatingAttributes} method.
     * </p>
     * 
     * @return An object that represents the propagating thing attributes and the connection attributes.
     */
    public final List<PropagatingAttribute> propagatingAttributes() {
        return propagatingAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPropagatingAttributes() ? propagatingAttributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Mqtt5Configuration)) {
            return false;
        }
        Mqtt5Configuration other = (Mqtt5Configuration) obj;
        return hasPropagatingAttributes() == other.hasPropagatingAttributes()
                && Objects.equals(propagatingAttributes(), other.propagatingAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Mqtt5Configuration")
                .add("PropagatingAttributes", hasPropagatingAttributes() ? propagatingAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "propagatingAttributes":
            return Optional.ofNullable(clazz.cast(propagatingAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("propagatingAttributes", PROPAGATING_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Mqtt5Configuration, T> g) {
        return obj -> g.apply((Mqtt5Configuration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Mqtt5Configuration> {
        /**
         * <p>
         * An object that represents the propagating thing attributes and the connection attributes.
         * </p>
         * 
         * @param propagatingAttributes
         *        An object that represents the propagating thing attributes and the connection attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propagatingAttributes(Collection<PropagatingAttribute> propagatingAttributes);

        /**
         * <p>
         * An object that represents the propagating thing attributes and the connection attributes.
         * </p>
         * 
         * @param propagatingAttributes
         *        An object that represents the propagating thing attributes and the connection attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propagatingAttributes(PropagatingAttribute... propagatingAttributes);

        /**
         * <p>
         * An object that represents the propagating thing attributes and the connection attributes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iot.model.PropagatingAttribute.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.iot.model.PropagatingAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iot.model.PropagatingAttribute.Builder#build()} is called immediately
         * and its result is passed to {@link #propagatingAttributes(List<PropagatingAttribute>)}.
         * 
         * @param propagatingAttributes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iot.model.PropagatingAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #propagatingAttributes(java.util.Collection<PropagatingAttribute>)
         */
        Builder propagatingAttributes(Consumer<PropagatingAttribute.Builder>... propagatingAttributes);
    }

    static final class BuilderImpl implements Builder {
        private List<PropagatingAttribute> propagatingAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Mqtt5Configuration model) {
            propagatingAttributes(model.propagatingAttributes);
        }

        public final List<PropagatingAttribute.Builder> getPropagatingAttributes() {
            List<PropagatingAttribute.Builder> result = PropagatingAttributeListCopier.copyToBuilder(this.propagatingAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPropagatingAttributes(Collection<PropagatingAttribute.BuilderImpl> propagatingAttributes) {
            this.propagatingAttributes = PropagatingAttributeListCopier.copyFromBuilder(propagatingAttributes);
        }

        @Override
        public final Builder propagatingAttributes(Collection<PropagatingAttribute> propagatingAttributes) {
            this.propagatingAttributes = PropagatingAttributeListCopier.copy(propagatingAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propagatingAttributes(PropagatingAttribute... propagatingAttributes) {
            propagatingAttributes(Arrays.asList(propagatingAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propagatingAttributes(Consumer<PropagatingAttribute.Builder>... propagatingAttributes) {
            propagatingAttributes(Stream.of(propagatingAttributes)
                    .map(c -> PropagatingAttribute.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Mqtt5Configuration build() {
            return new Mqtt5Configuration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
