/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CommandNamespace {
    AWS_IOT("AWS-IoT"),
    AWS_IOT_FLEET_WISE("AWS-IoT-FleetWise"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CommandNamespace> VALUE_MAP;
    private final String value;

    private CommandNamespace(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CommandNamespace fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CommandNamespace> knownValues() {
        EnumSet<CommandNamespace> knownValues = EnumSet.allOf(CommandNamespace.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CommandNamespace.class, CommandNamespace::toString);
    }
}

