/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The value to be compared with the <code>metric</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricValue implements SdkPojo, Serializable, ToCopyableBuilder<MetricValue.Builder, MetricValue> {
    private static final SdkField<Long> COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("count")
            .getter(getter(MetricValue::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()).build();

    private static final SdkField<List<String>> CIDRS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("cidrs")
            .getter(getter(MetricValue::cidrs))
            .setter(setter(Builder::cidrs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cidrs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Integer>> PORTS_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("ports")
            .getter(getter(MetricValue::ports))
            .setter(setter(Builder::ports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ports").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Double> NUMBER_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("number")
            .getter(getter(MetricValue::number)).setter(setter(Builder::number))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("number").build()).build();

    private static final SdkField<List<Double>> NUMBERS_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("numbers")
            .getter(getter(MetricValue::numbers))
            .setter(setter(Builder::numbers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numbers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> STRINGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("strings")
            .getter(getter(MetricValue::strings))
            .setter(setter(Builder::strings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("strings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_FIELD, CIDRS_FIELD,
            PORTS_FIELD, NUMBER_FIELD, NUMBERS_FIELD, STRINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long count;

    private final List<String> cidrs;

    private final List<Integer> ports;

    private final Double number;

    private final List<Double> numbers;

    private final List<String> strings;

    private MetricValue(BuilderImpl builder) {
        this.count = builder.count;
        this.cidrs = builder.cidrs;
        this.ports = builder.ports;
        this.number = builder.number;
        this.numbers = builder.numbers;
        this.strings = builder.strings;
    }

    /**
     * <p>
     * If the <code>comparisonOperator</code> calls for a numeric value, use this to specify that numeric value to be
     * compared with the <code>metric</code>.
     * </p>
     * 
     * @return If the <code>comparisonOperator</code> calls for a numeric value, use this to specify that numeric value
     *         to be compared with the <code>metric</code>.
     */
    public final Long count() {
        return count;
    }

    /**
     * For responses, this returns true if the service returned a value for the Cidrs property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasCidrs() {
        return cidrs != null && !(cidrs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If the <code>comparisonOperator</code> calls for a set of CIDRs, use this to specify that set to be compared with
     * the <code>metric</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCidrs} method.
     * </p>
     * 
     * @return If the <code>comparisonOperator</code> calls for a set of CIDRs, use this to specify that set to be
     *         compared with the <code>metric</code>.
     */
    public final List<String> cidrs() {
        return cidrs;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ports property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasPorts() {
        return ports != null && !(ports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If the <code>comparisonOperator</code> calls for a set of ports, use this to specify that set to be compared with
     * the <code>metric</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPorts} method.
     * </p>
     * 
     * @return If the <code>comparisonOperator</code> calls for a set of ports, use this to specify that set to be
     *         compared with the <code>metric</code>.
     */
    public final List<Integer> ports() {
        return ports;
    }

    /**
     * <p>
     * The numeral value of a metric.
     * </p>
     * 
     * @return The numeral value of a metric.
     */
    public final Double number() {
        return number;
    }

    /**
     * For responses, this returns true if the service returned a value for the Numbers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNumbers() {
        return numbers != null && !(numbers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The numeral values of a metric.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNumbers} method.
     * </p>
     * 
     * @return The numeral values of a metric.
     */
    public final List<Double> numbers() {
        return numbers;
    }

    /**
     * For responses, this returns true if the service returned a value for the Strings property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStrings() {
        return strings != null && !(strings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The string values of a metric.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStrings} method.
     * </p>
     * 
     * @return The string values of a metric.
     */
    public final List<String> strings() {
        return strings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(hasCidrs() ? cidrs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPorts() ? ports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(number());
        hashCode = 31 * hashCode + Objects.hashCode(hasNumbers() ? numbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStrings() ? strings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricValue)) {
            return false;
        }
        MetricValue other = (MetricValue) obj;
        return Objects.equals(count(), other.count()) && hasCidrs() == other.hasCidrs() && Objects.equals(cidrs(), other.cidrs())
                && hasPorts() == other.hasPorts() && Objects.equals(ports(), other.ports())
                && Objects.equals(number(), other.number()) && hasNumbers() == other.hasNumbers()
                && Objects.equals(numbers(), other.numbers()) && hasStrings() == other.hasStrings()
                && Objects.equals(strings(), other.strings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricValue").add("Count", count()).add("Cidrs", hasCidrs() ? cidrs() : null)
                .add("Ports", hasPorts() ? ports() : null).add("Number", number())
                .add("Numbers", hasNumbers() ? numbers() : null).add("Strings", hasStrings() ? strings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "count":
            return Optional.ofNullable(clazz.cast(count()));
        case "cidrs":
            return Optional.ofNullable(clazz.cast(cidrs()));
        case "ports":
            return Optional.ofNullable(clazz.cast(ports()));
        case "number":
            return Optional.ofNullable(clazz.cast(number()));
        case "numbers":
            return Optional.ofNullable(clazz.cast(numbers()));
        case "strings":
            return Optional.ofNullable(clazz.cast(strings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("count", COUNT_FIELD);
        map.put("cidrs", CIDRS_FIELD);
        map.put("ports", PORTS_FIELD);
        map.put("number", NUMBER_FIELD);
        map.put("numbers", NUMBERS_FIELD);
        map.put("strings", STRINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricValue, T> g) {
        return obj -> g.apply((MetricValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricValue> {
        /**
         * <p>
         * If the <code>comparisonOperator</code> calls for a numeric value, use this to specify that numeric value to
         * be compared with the <code>metric</code>.
         * </p>
         * 
         * @param count
         *        If the <code>comparisonOperator</code> calls for a numeric value, use this to specify that numeric
         *        value to be compared with the <code>metric</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Long count);

        /**
         * <p>
         * If the <code>comparisonOperator</code> calls for a set of CIDRs, use this to specify that set to be compared
         * with the <code>metric</code>.
         * </p>
         * 
         * @param cidrs
         *        If the <code>comparisonOperator</code> calls for a set of CIDRs, use this to specify that set to be
         *        compared with the <code>metric</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrs(Collection<String> cidrs);

        /**
         * <p>
         * If the <code>comparisonOperator</code> calls for a set of CIDRs, use this to specify that set to be compared
         * with the <code>metric</code>.
         * </p>
         * 
         * @param cidrs
         *        If the <code>comparisonOperator</code> calls for a set of CIDRs, use this to specify that set to be
         *        compared with the <code>metric</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrs(String... cidrs);

        /**
         * <p>
         * If the <code>comparisonOperator</code> calls for a set of ports, use this to specify that set to be compared
         * with the <code>metric</code>.
         * </p>
         * 
         * @param ports
         *        If the <code>comparisonOperator</code> calls for a set of ports, use this to specify that set to be
         *        compared with the <code>metric</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ports(Collection<Integer> ports);

        /**
         * <p>
         * If the <code>comparisonOperator</code> calls for a set of ports, use this to specify that set to be compared
         * with the <code>metric</code>.
         * </p>
         * 
         * @param ports
         *        If the <code>comparisonOperator</code> calls for a set of ports, use this to specify that set to be
         *        compared with the <code>metric</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ports(Integer... ports);

        /**
         * <p>
         * The numeral value of a metric.
         * </p>
         * 
         * @param number
         *        The numeral value of a metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder number(Double number);

        /**
         * <p>
         * The numeral values of a metric.
         * </p>
         * 
         * @param numbers
         *        The numeral values of a metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numbers(Collection<Double> numbers);

        /**
         * <p>
         * The numeral values of a metric.
         * </p>
         * 
         * @param numbers
         *        The numeral values of a metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numbers(Double... numbers);

        /**
         * <p>
         * The string values of a metric.
         * </p>
         * 
         * @param strings
         *        The string values of a metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder strings(Collection<String> strings);

        /**
         * <p>
         * The string values of a metric.
         * </p>
         * 
         * @param strings
         *        The string values of a metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder strings(String... strings);
    }

    static final class BuilderImpl implements Builder {
        private Long count;

        private List<String> cidrs = DefaultSdkAutoConstructList.getInstance();

        private List<Integer> ports = DefaultSdkAutoConstructList.getInstance();

        private Double number;

        private List<Double> numbers = DefaultSdkAutoConstructList.getInstance();

        private List<String> strings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MetricValue model) {
            count(model.count);
            cidrs(model.cidrs);
            ports(model.ports);
            number(model.number);
            numbers(model.numbers);
            strings(model.strings);
        }

        public final Long getCount() {
            return count;
        }

        public final void setCount(Long count) {
            this.count = count;
        }

        @Override
        public final Builder count(Long count) {
            this.count = count;
            return this;
        }

        public final Collection<String> getCidrs() {
            if (cidrs instanceof SdkAutoConstructList) {
                return null;
            }
            return cidrs;
        }

        public final void setCidrs(Collection<String> cidrs) {
            this.cidrs = CidrsCopier.copy(cidrs);
        }

        @Override
        public final Builder cidrs(Collection<String> cidrs) {
            this.cidrs = CidrsCopier.copy(cidrs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrs(String... cidrs) {
            cidrs(Arrays.asList(cidrs));
            return this;
        }

        public final Collection<Integer> getPorts() {
            if (ports instanceof SdkAutoConstructList) {
                return null;
            }
            return ports;
        }

        public final void setPorts(Collection<Integer> ports) {
            this.ports = PortsCopier.copy(ports);
        }

        @Override
        public final Builder ports(Collection<Integer> ports) {
            this.ports = PortsCopier.copy(ports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ports(Integer... ports) {
            ports(Arrays.asList(ports));
            return this;
        }

        public final Double getNumber() {
            return number;
        }

        public final void setNumber(Double number) {
            this.number = number;
        }

        @Override
        public final Builder number(Double number) {
            this.number = number;
            return this;
        }

        public final Collection<Double> getNumbers() {
            if (numbers instanceof SdkAutoConstructList) {
                return null;
            }
            return numbers;
        }

        public final void setNumbers(Collection<Double> numbers) {
            this.numbers = NumberListCopier.copy(numbers);
        }

        @Override
        public final Builder numbers(Collection<Double> numbers) {
            this.numbers = NumberListCopier.copy(numbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder numbers(Double... numbers) {
            numbers(Arrays.asList(numbers));
            return this;
        }

        public final Collection<String> getStrings() {
            if (strings instanceof SdkAutoConstructList) {
                return null;
            }
            return strings;
        }

        public final void setStrings(Collection<String> strings) {
            this.strings = StringListCopier.copy(strings);
        }

        @Override
        public final Builder strings(Collection<String> strings) {
            this.strings = StringListCopier.copy(strings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder strings(String... strings) {
            strings(Arrays.asList(strings));
            return this;
        }

        @Override
        public MetricValue build() {
            return new MetricValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
