/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration that determines how many retries are allowed for each failure type for a job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobExecutionsRetryConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<JobExecutionsRetryConfig.Builder, JobExecutionsRetryConfig> {
    private static final SdkField<List<RetryCriteria>> CRITERIA_LIST_FIELD = SdkField
            .<List<RetryCriteria>> builder(MarshallingType.LIST)
            .memberName("criteriaList")
            .getter(getter(JobExecutionsRetryConfig::criteriaList))
            .setter(setter(Builder::criteriaList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("criteriaList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RetryCriteria> builder(MarshallingType.SDK_POJO)
                                            .constructor(RetryCriteria::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRITERIA_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<RetryCriteria> criteriaList;

    private JobExecutionsRetryConfig(BuilderImpl builder) {
        this.criteriaList = builder.criteriaList;
    }

    /**
     * For responses, this returns true if the service returned a value for the CriteriaList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCriteriaList() {
        return criteriaList != null && !(criteriaList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of criteria that determines how many retries are allowed for each failure type for a job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCriteriaList} method.
     * </p>
     * 
     * @return The list of criteria that determines how many retries are allowed for each failure type for a job.
     */
    public final List<RetryCriteria> criteriaList() {
        return criteriaList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCriteriaList() ? criteriaList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobExecutionsRetryConfig)) {
            return false;
        }
        JobExecutionsRetryConfig other = (JobExecutionsRetryConfig) obj;
        return hasCriteriaList() == other.hasCriteriaList() && Objects.equals(criteriaList(), other.criteriaList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobExecutionsRetryConfig").add("CriteriaList", hasCriteriaList() ? criteriaList() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "criteriaList":
            return Optional.ofNullable(clazz.cast(criteriaList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("criteriaList", CRITERIA_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobExecutionsRetryConfig, T> g) {
        return obj -> g.apply((JobExecutionsRetryConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobExecutionsRetryConfig> {
        /**
         * <p>
         * The list of criteria that determines how many retries are allowed for each failure type for a job.
         * </p>
         * 
         * @param criteriaList
         *        The list of criteria that determines how many retries are allowed for each failure type for a job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder criteriaList(Collection<RetryCriteria> criteriaList);

        /**
         * <p>
         * The list of criteria that determines how many retries are allowed for each failure type for a job.
         * </p>
         * 
         * @param criteriaList
         *        The list of criteria that determines how many retries are allowed for each failure type for a job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder criteriaList(RetryCriteria... criteriaList);

        /**
         * <p>
         * The list of criteria that determines how many retries are allowed for each failure type for a job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iot.model.RetryCriteria.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iot.model.RetryCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iot.model.RetryCriteria.Builder#build()} is called immediately and its
         * result is passed to {@link #criteriaList(List<RetryCriteria>)}.
         * 
         * @param criteriaList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iot.model.RetryCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #criteriaList(java.util.Collection<RetryCriteria>)
         */
        Builder criteriaList(Consumer<RetryCriteria.Builder>... criteriaList);
    }

    static final class BuilderImpl implements Builder {
        private List<RetryCriteria> criteriaList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JobExecutionsRetryConfig model) {
            criteriaList(model.criteriaList);
        }

        public final List<RetryCriteria.Builder> getCriteriaList() {
            List<RetryCriteria.Builder> result = RetryCriteriaListCopier.copyToBuilder(this.criteriaList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCriteriaList(Collection<RetryCriteria.BuilderImpl> criteriaList) {
            this.criteriaList = RetryCriteriaListCopier.copyFromBuilder(criteriaList);
        }

        @Override
        public final Builder criteriaList(Collection<RetryCriteria> criteriaList) {
            this.criteriaList = RetryCriteriaListCopier.copy(criteriaList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder criteriaList(RetryCriteria... criteriaList) {
            criteriaList(Arrays.asList(criteriaList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder criteriaList(Consumer<RetryCriteria.Builder>... criteriaList) {
            criteriaList(Stream.of(criteriaList).map(c -> RetryCriteria.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public JobExecutionsRetryConfig build() {
            return new JobExecutionsRetryConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
