/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateProvisioningClaimResponse extends IotResponse implements
        ToCopyableBuilder<CreateProvisioningClaimResponse.Builder, CreateProvisioningClaimResponse> {
    private static final SdkField<String> CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificateId").getter(getter(CreateProvisioningClaimResponse::certificateId))
            .setter(setter(Builder::certificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateId").build()).build();

    private static final SdkField<String> CERTIFICATE_PEM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificatePem").getter(getter(CreateProvisioningClaimResponse::certificatePem))
            .setter(setter(Builder::certificatePem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificatePem").build()).build();

    private static final SdkField<KeyPair> KEY_PAIR_FIELD = SdkField.<KeyPair> builder(MarshallingType.SDK_POJO)
            .memberName("keyPair").getter(getter(CreateProvisioningClaimResponse::keyPair)).setter(setter(Builder::keyPair))
            .constructor(KeyPair::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyPair").build()).build();

    private static final SdkField<Instant> EXPIRATION_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("expiration").getter(getter(CreateProvisioningClaimResponse::expiration))
            .setter(setter(Builder::expiration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ID_FIELD,
            CERTIFICATE_PEM_FIELD, KEY_PAIR_FIELD, EXPIRATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String certificateId;

    private final String certificatePem;

    private final KeyPair keyPair;

    private final Instant expiration;

    private CreateProvisioningClaimResponse(BuilderImpl builder) {
        super(builder);
        this.certificateId = builder.certificateId;
        this.certificatePem = builder.certificatePem;
        this.keyPair = builder.keyPair;
        this.expiration = builder.expiration;
    }

    /**
     * <p>
     * The ID of the certificate.
     * </p>
     * 
     * @return The ID of the certificate.
     */
    public final String certificateId() {
        return certificateId;
    }

    /**
     * <p>
     * The provisioning claim certificate.
     * </p>
     * 
     * @return The provisioning claim certificate.
     */
    public final String certificatePem() {
        return certificatePem;
    }

    /**
     * <p>
     * The provisioning claim key pair.
     * </p>
     * 
     * @return The provisioning claim key pair.
     */
    public final KeyPair keyPair() {
        return keyPair;
    }

    /**
     * <p>
     * The provisioning claim expiration time.
     * </p>
     * 
     * @return The provisioning claim expiration time.
     */
    public final Instant expiration() {
        return expiration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(certificatePem());
        hashCode = 31 * hashCode + Objects.hashCode(keyPair());
        hashCode = 31 * hashCode + Objects.hashCode(expiration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProvisioningClaimResponse)) {
            return false;
        }
        CreateProvisioningClaimResponse other = (CreateProvisioningClaimResponse) obj;
        return Objects.equals(certificateId(), other.certificateId()) && Objects.equals(certificatePem(), other.certificatePem())
                && Objects.equals(keyPair(), other.keyPair()) && Objects.equals(expiration(), other.expiration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateProvisioningClaimResponse").add("CertificateId", certificateId())
                .add("CertificatePem", certificatePem()).add("KeyPair", keyPair()).add("Expiration", expiration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateId":
            return Optional.ofNullable(clazz.cast(certificateId()));
        case "certificatePem":
            return Optional.ofNullable(clazz.cast(certificatePem()));
        case "keyPair":
            return Optional.ofNullable(clazz.cast(keyPair()));
        case "expiration":
            return Optional.ofNullable(clazz.cast(expiration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("certificateId", CERTIFICATE_ID_FIELD);
        map.put("certificatePem", CERTIFICATE_PEM_FIELD);
        map.put("keyPair", KEY_PAIR_FIELD);
        map.put("expiration", EXPIRATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateProvisioningClaimResponse, T> g) {
        return obj -> g.apply((CreateProvisioningClaimResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateProvisioningClaimResponse> {
        /**
         * <p>
         * The ID of the certificate.
         * </p>
         * 
         * @param certificateId
         *        The ID of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateId(String certificateId);

        /**
         * <p>
         * The provisioning claim certificate.
         * </p>
         * 
         * @param certificatePem
         *        The provisioning claim certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificatePem(String certificatePem);

        /**
         * <p>
         * The provisioning claim key pair.
         * </p>
         * 
         * @param keyPair
         *        The provisioning claim key pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPair(KeyPair keyPair);

        /**
         * <p>
         * The provisioning claim key pair.
         * </p>
         * This is a convenience method that creates an instance of the {@link KeyPair.Builder} avoiding the need to
         * create one manually via {@link KeyPair#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KeyPair.Builder#build()} is called immediately and its result is
         * passed to {@link #keyPair(KeyPair)}.
         * 
         * @param keyPair
         *        a consumer that will call methods on {@link KeyPair.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyPair(KeyPair)
         */
        default Builder keyPair(Consumer<KeyPair.Builder> keyPair) {
            return keyPair(KeyPair.builder().applyMutation(keyPair).build());
        }

        /**
         * <p>
         * The provisioning claim expiration time.
         * </p>
         * 
         * @param expiration
         *        The provisioning claim expiration time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiration(Instant expiration);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String certificateId;

        private String certificatePem;

        private KeyPair keyPair;

        private Instant expiration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProvisioningClaimResponse model) {
            super(model);
            certificateId(model.certificateId);
            certificatePem(model.certificatePem);
            keyPair(model.keyPair);
            expiration(model.expiration);
        }

        public final String getCertificateId() {
            return certificateId;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final String getCertificatePem() {
            return certificatePem;
        }

        public final void setCertificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
        }

        @Override
        public final Builder certificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
            return this;
        }

        public final KeyPair.Builder getKeyPair() {
            return keyPair != null ? keyPair.toBuilder() : null;
        }

        public final void setKeyPair(KeyPair.BuilderImpl keyPair) {
            this.keyPair = keyPair != null ? keyPair.build() : null;
        }

        @Override
        public final Builder keyPair(KeyPair keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        public final Instant getExpiration() {
            return expiration;
        }

        public final void setExpiration(Instant expiration) {
            this.expiration = expiration;
        }

        @Override
        public final Builder expiration(Instant expiration) {
            this.expiration = expiration;
            return this;
        }

        @Override
        public CreateProvisioningClaimResponse build() {
            return new CreateProvisioningClaimResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
