/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateProvisioningTemplateRequest extends IotRequest implements
        ToCopyableBuilder<CreateProvisioningTemplateRequest.Builder, CreateProvisioningTemplateRequest> {
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateName").getter(getter(CreateProvisioningTemplateRequest::templateName))
            .setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateProvisioningTemplateRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> TEMPLATE_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateBody").getter(getter(CreateProvisioningTemplateRequest::templateBody))
            .setter(setter(Builder::templateBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateBody").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(CreateProvisioningTemplateRequest::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<String> PROVISIONING_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("provisioningRoleArn").getter(getter(CreateProvisioningTemplateRequest::provisioningRoleArn))
            .setter(setter(Builder::provisioningRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisioningRoleArn").build())
            .build();

    private static final SdkField<ProvisioningHook> PRE_PROVISIONING_HOOK_FIELD = SdkField
            .<ProvisioningHook> builder(MarshallingType.SDK_POJO).memberName("preProvisioningHook")
            .getter(getter(CreateProvisioningTemplateRequest::preProvisioningHook)).setter(setter(Builder::preProvisioningHook))
            .constructor(ProvisioningHook::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preProvisioningHook").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateProvisioningTemplateRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(CreateProvisioningTemplateRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_NAME_FIELD,
            DESCRIPTION_FIELD, TEMPLATE_BODY_FIELD, ENABLED_FIELD, PROVISIONING_ROLE_ARN_FIELD, PRE_PROVISIONING_HOOK_FIELD,
            TAGS_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String templateName;

    private final String description;

    private final String templateBody;

    private final Boolean enabled;

    private final String provisioningRoleArn;

    private final ProvisioningHook preProvisioningHook;

    private final List<Tag> tags;

    private final String type;

    private CreateProvisioningTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.templateName = builder.templateName;
        this.description = builder.description;
        this.templateBody = builder.templateBody;
        this.enabled = builder.enabled;
        this.provisioningRoleArn = builder.provisioningRoleArn;
        this.preProvisioningHook = builder.preProvisioningHook;
        this.tags = builder.tags;
        this.type = builder.type;
    }

    /**
     * <p>
     * The name of the provisioning template.
     * </p>
     * 
     * @return The name of the provisioning template.
     */
    public final String templateName() {
        return templateName;
    }

    /**
     * <p>
     * The description of the provisioning template.
     * </p>
     * 
     * @return The description of the provisioning template.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The JSON formatted contents of the provisioning template.
     * </p>
     * 
     * @return The JSON formatted contents of the provisioning template.
     */
    public final String templateBody() {
        return templateBody;
    }

    /**
     * <p>
     * True to enable the provisioning template, otherwise false.
     * </p>
     * 
     * @return True to enable the provisioning template, otherwise false.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The role ARN for the role associated with the provisioning template. This IoT role grants permission to provision
     * a device.
     * </p>
     * 
     * @return The role ARN for the role associated with the provisioning template. This IoT role grants permission to
     *         provision a device.
     */
    public final String provisioningRoleArn() {
        return provisioningRoleArn;
    }

    /**
     * <p>
     * Creates a pre-provisioning hook template. Only supports template of type <code>FLEET_PROVISIONING</code>. For
     * more information about provisioning template types, see <a href=
     * "https://docs.aws.amazon.com/iot/latest/apireference/API_CreateProvisioningTemplate.html#iot-CreateProvisioningTemplate-request-type"
     * >type</a>.
     * </p>
     * 
     * @return Creates a pre-provisioning hook template. Only supports template of type <code>FLEET_PROVISIONING</code>.
     *         For more information about provisioning template types, see <a href=
     *         "https://docs.aws.amazon.com/iot/latest/apireference/API_CreateProvisioningTemplate.html#iot-CreateProvisioningTemplate-request-type"
     *         >type</a>.
     */
    public final ProvisioningHook preProvisioningHook() {
        return preProvisioningHook;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Metadata which can be used to manage the provisioning template.
     * </p>
     * <note>
     * <p>
     * For URI Request parameters use format: ...key1=value1&amp;key2=value2...
     * </p>
     * <p>
     * For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
     * </p>
     * <p>
     * For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Metadata which can be used to manage the provisioning template.</p> <note>
     *         <p>
     *         For URI Request parameters use format: ...key1=value1&amp;key2=value2...
     *         </p>
     *         <p>
     *         For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
     *         </p>
     *         <p>
     *         For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
     *         </p>
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The type you define in a provisioning template. You can create a template with only one type. You can't change
     * the template type after its creation. The default value is <code>FLEET_PROVISIONING</code>. For more information
     * about provisioning template, see: <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-template.html">Provisioning template</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TemplateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type you define in a provisioning template. You can create a template with only one type. You can't
     *         change the template type after its creation. The default value is <code>FLEET_PROVISIONING</code>. For
     *         more information about provisioning template, see: <a
     *         href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-template.html">Provisioning
     *         template</a>.
     * @see TemplateType
     */
    public final TemplateType type() {
        return TemplateType.fromValue(type);
    }

    /**
     * <p>
     * The type you define in a provisioning template. You can create a template with only one type. You can't change
     * the template type after its creation. The default value is <code>FLEET_PROVISIONING</code>. For more information
     * about provisioning template, see: <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-template.html">Provisioning template</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TemplateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type you define in a provisioning template. You can create a template with only one type. You can't
     *         change the template type after its creation. The default value is <code>FLEET_PROVISIONING</code>. For
     *         more information about provisioning template, see: <a
     *         href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-template.html">Provisioning
     *         template</a>.
     * @see TemplateType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(preProvisioningHook());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProvisioningTemplateRequest)) {
            return false;
        }
        CreateProvisioningTemplateRequest other = (CreateProvisioningTemplateRequest) obj;
        return Objects.equals(templateName(), other.templateName()) && Objects.equals(description(), other.description())
                && Objects.equals(templateBody(), other.templateBody()) && Objects.equals(enabled(), other.enabled())
                && Objects.equals(provisioningRoleArn(), other.provisioningRoleArn())
                && Objects.equals(preProvisioningHook(), other.preProvisioningHook()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateProvisioningTemplateRequest").add("TemplateName", templateName())
                .add("Description", description()).add("TemplateBody", templateBody()).add("Enabled", enabled())
                .add("ProvisioningRoleArn", provisioningRoleArn()).add("PreProvisioningHook", preProvisioningHook())
                .add("Tags", hasTags() ? tags() : null).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "templateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "templateBody":
            return Optional.ofNullable(clazz.cast(templateBody()));
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "provisioningRoleArn":
            return Optional.ofNullable(clazz.cast(provisioningRoleArn()));
        case "preProvisioningHook":
            return Optional.ofNullable(clazz.cast(preProvisioningHook()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("templateName", TEMPLATE_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("templateBody", TEMPLATE_BODY_FIELD);
        map.put("enabled", ENABLED_FIELD);
        map.put("provisioningRoleArn", PROVISIONING_ROLE_ARN_FIELD);
        map.put("preProvisioningHook", PRE_PROVISIONING_HOOK_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateProvisioningTemplateRequest, T> g) {
        return obj -> g.apply((CreateProvisioningTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateProvisioningTemplateRequest> {
        /**
         * <p>
         * The name of the provisioning template.
         * </p>
         * 
         * @param templateName
         *        The name of the provisioning template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * The description of the provisioning template.
         * </p>
         * 
         * @param description
         *        The description of the provisioning template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The JSON formatted contents of the provisioning template.
         * </p>
         * 
         * @param templateBody
         *        The JSON formatted contents of the provisioning template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateBody(String templateBody);

        /**
         * <p>
         * True to enable the provisioning template, otherwise false.
         * </p>
         * 
         * @param enabled
         *        True to enable the provisioning template, otherwise false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The role ARN for the role associated with the provisioning template. This IoT role grants permission to
         * provision a device.
         * </p>
         * 
         * @param provisioningRoleArn
         *        The role ARN for the role associated with the provisioning template. This IoT role grants permission
         *        to provision a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningRoleArn(String provisioningRoleArn);

        /**
         * <p>
         * Creates a pre-provisioning hook template. Only supports template of type <code>FLEET_PROVISIONING</code>. For
         * more information about provisioning template types, see <a href=
         * "https://docs.aws.amazon.com/iot/latest/apireference/API_CreateProvisioningTemplate.html#iot-CreateProvisioningTemplate-request-type"
         * >type</a>.
         * </p>
         * 
         * @param preProvisioningHook
         *        Creates a pre-provisioning hook template. Only supports template of type
         *        <code>FLEET_PROVISIONING</code>. For more information about provisioning template types, see <a href=
         *        "https://docs.aws.amazon.com/iot/latest/apireference/API_CreateProvisioningTemplate.html#iot-CreateProvisioningTemplate-request-type"
         *        >type</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preProvisioningHook(ProvisioningHook preProvisioningHook);

        /**
         * <p>
         * Creates a pre-provisioning hook template. Only supports template of type <code>FLEET_PROVISIONING</code>. For
         * more information about provisioning template types, see <a href=
         * "https://docs.aws.amazon.com/iot/latest/apireference/API_CreateProvisioningTemplate.html#iot-CreateProvisioningTemplate-request-type"
         * >type</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProvisioningHook.Builder} avoiding the
         * need to create one manually via {@link ProvisioningHook#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProvisioningHook.Builder#build()} is called immediately and its
         * result is passed to {@link #preProvisioningHook(ProvisioningHook)}.
         * 
         * @param preProvisioningHook
         *        a consumer that will call methods on {@link ProvisioningHook.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #preProvisioningHook(ProvisioningHook)
         */
        default Builder preProvisioningHook(Consumer<ProvisioningHook.Builder> preProvisioningHook) {
            return preProvisioningHook(ProvisioningHook.builder().applyMutation(preProvisioningHook).build());
        }

        /**
         * <p>
         * Metadata which can be used to manage the provisioning template.
         * </p>
         * <note>
         * <p>
         * For URI Request parameters use format: ...key1=value1&amp;key2=value2...
         * </p>
         * <p>
         * For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
         * </p>
         * <p>
         * For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
         * </p>
         * </note>
         * 
         * @param tags
         *        Metadata which can be used to manage the provisioning template.</p> <note>
         *        <p>
         *        For URI Request parameters use format: ...key1=value1&amp;key2=value2...
         *        </p>
         *        <p>
         *        For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
         *        </p>
         *        <p>
         *        For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Metadata which can be used to manage the provisioning template.
         * </p>
         * <note>
         * <p>
         * For URI Request parameters use format: ...key1=value1&amp;key2=value2...
         * </p>
         * <p>
         * For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
         * </p>
         * <p>
         * For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
         * </p>
         * </note>
         * 
         * @param tags
         *        Metadata which can be used to manage the provisioning template.</p> <note>
         *        <p>
         *        For URI Request parameters use format: ...key1=value1&amp;key2=value2...
         *        </p>
         *        <p>
         *        For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
         *        </p>
         *        <p>
         *        For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Metadata which can be used to manage the provisioning template.
         * </p>
         * <note>
         * <p>
         * For URI Request parameters use format: ...key1=value1&amp;key2=value2...
         * </p>
         * <p>
         * For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
         * </p>
         * <p>
         * For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iot.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.iot.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.iot.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.iot.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The type you define in a provisioning template. You can create a template with only one type. You can't
         * change the template type after its creation. The default value is <code>FLEET_PROVISIONING</code>. For more
         * information about provisioning template, see: <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-template.html">Provisioning
         * template</a>.
         * </p>
         * 
         * @param type
         *        The type you define in a provisioning template. You can create a template with only one type. You
         *        can't change the template type after its creation. The default value is
         *        <code>FLEET_PROVISIONING</code>. For more information about provisioning template, see: <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-template.html">Provisioning
         *        template</a>.
         * @see TemplateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemplateType
         */
        Builder type(String type);

        /**
         * <p>
         * The type you define in a provisioning template. You can create a template with only one type. You can't
         * change the template type after its creation. The default value is <code>FLEET_PROVISIONING</code>. For more
         * information about provisioning template, see: <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-template.html">Provisioning
         * template</a>.
         * </p>
         * 
         * @param type
         *        The type you define in a provisioning template. You can create a template with only one type. You
         *        can't change the template type after its creation. The default value is
         *        <code>FLEET_PROVISIONING</code>. For more information about provisioning template, see: <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-template.html">Provisioning
         *        template</a>.
         * @see TemplateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemplateType
         */
        Builder type(TemplateType type);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String templateName;

        private String description;

        private String templateBody;

        private Boolean enabled;

        private String provisioningRoleArn;

        private ProvisioningHook preProvisioningHook;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProvisioningTemplateRequest model) {
            super(model);
            templateName(model.templateName);
            description(model.description);
            templateBody(model.templateBody);
            enabled(model.enabled);
            provisioningRoleArn(model.provisioningRoleArn);
            preProvisioningHook(model.preProvisioningHook);
            tags(model.tags);
            type(model.type);
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getTemplateBody() {
            return templateBody;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getProvisioningRoleArn() {
            return provisioningRoleArn;
        }

        public final void setProvisioningRoleArn(String provisioningRoleArn) {
            this.provisioningRoleArn = provisioningRoleArn;
        }

        @Override
        public final Builder provisioningRoleArn(String provisioningRoleArn) {
            this.provisioningRoleArn = provisioningRoleArn;
            return this;
        }

        public final ProvisioningHook.Builder getPreProvisioningHook() {
            return preProvisioningHook != null ? preProvisioningHook.toBuilder() : null;
        }

        public final void setPreProvisioningHook(ProvisioningHook.BuilderImpl preProvisioningHook) {
            this.preProvisioningHook = preProvisioningHook != null ? preProvisioningHook.build() : null;
        }

        @Override
        public final Builder preProvisioningHook(ProvisioningHook preProvisioningHook) {
            this.preProvisioningHook = preProvisioningHook;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TemplateType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProvisioningTemplateRequest build() {
            return new CreateProvisioningTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
