/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPackageConfigurationResponse extends IotResponse implements
        ToCopyableBuilder<GetPackageConfigurationResponse.Builder, GetPackageConfigurationResponse> {
    private static final SdkField<VersionUpdateByJobsConfig> VERSION_UPDATE_BY_JOBS_CONFIG_FIELD = SdkField
            .<VersionUpdateByJobsConfig> builder(MarshallingType.SDK_POJO).memberName("versionUpdateByJobsConfig")
            .getter(getter(GetPackageConfigurationResponse::versionUpdateByJobsConfig))
            .setter(setter(Builder::versionUpdateByJobsConfig)).constructor(VersionUpdateByJobsConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionUpdateByJobsConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(VERSION_UPDATE_BY_JOBS_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final VersionUpdateByJobsConfig versionUpdateByJobsConfig;

    private GetPackageConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.versionUpdateByJobsConfig = builder.versionUpdateByJobsConfig;
    }

    /**
     * <p>
     * The version that is associated to a specific job.
     * </p>
     * 
     * @return The version that is associated to a specific job.
     */
    public final VersionUpdateByJobsConfig versionUpdateByJobsConfig() {
        return versionUpdateByJobsConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(versionUpdateByJobsConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPackageConfigurationResponse)) {
            return false;
        }
        GetPackageConfigurationResponse other = (GetPackageConfigurationResponse) obj;
        return Objects.equals(versionUpdateByJobsConfig(), other.versionUpdateByJobsConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPackageConfigurationResponse").add("VersionUpdateByJobsConfig", versionUpdateByJobsConfig())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "versionUpdateByJobsConfig":
            return Optional.ofNullable(clazz.cast(versionUpdateByJobsConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("versionUpdateByJobsConfig", VERSION_UPDATE_BY_JOBS_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPackageConfigurationResponse, T> g) {
        return obj -> g.apply((GetPackageConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetPackageConfigurationResponse> {
        /**
         * <p>
         * The version that is associated to a specific job.
         * </p>
         * 
         * @param versionUpdateByJobsConfig
         *        The version that is associated to a specific job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionUpdateByJobsConfig(VersionUpdateByJobsConfig versionUpdateByJobsConfig);

        /**
         * <p>
         * The version that is associated to a specific job.
         * </p>
         * This is a convenience method that creates an instance of the {@link VersionUpdateByJobsConfig.Builder}
         * avoiding the need to create one manually via {@link VersionUpdateByJobsConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VersionUpdateByJobsConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #versionUpdateByJobsConfig(VersionUpdateByJobsConfig)}.
         * 
         * @param versionUpdateByJobsConfig
         *        a consumer that will call methods on {@link VersionUpdateByJobsConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #versionUpdateByJobsConfig(VersionUpdateByJobsConfig)
         */
        default Builder versionUpdateByJobsConfig(Consumer<VersionUpdateByJobsConfig.Builder> versionUpdateByJobsConfig) {
            return versionUpdateByJobsConfig(VersionUpdateByJobsConfig.builder().applyMutation(versionUpdateByJobsConfig).build());
        }
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private VersionUpdateByJobsConfig versionUpdateByJobsConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPackageConfigurationResponse model) {
            super(model);
            versionUpdateByJobsConfig(model.versionUpdateByJobsConfig);
        }

        public final VersionUpdateByJobsConfig.Builder getVersionUpdateByJobsConfig() {
            return versionUpdateByJobsConfig != null ? versionUpdateByJobsConfig.toBuilder() : null;
        }

        public final void setVersionUpdateByJobsConfig(VersionUpdateByJobsConfig.BuilderImpl versionUpdateByJobsConfig) {
            this.versionUpdateByJobsConfig = versionUpdateByJobsConfig != null ? versionUpdateByJobsConfig.build() : null;
        }

        @Override
        public final Builder versionUpdateByJobsConfig(VersionUpdateByJobsConfig versionUpdateByJobsConfig) {
            this.versionUpdateByJobsConfig = versionUpdateByJobsConfig;
            return this;
        }

        @Override
        public GetPackageConfigurationResponse build() {
            return new GetPackageConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
