/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the scheduled audit.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduledAuditMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<ScheduledAuditMetadata.Builder, ScheduledAuditMetadata> {
    private static final SdkField<String> SCHEDULED_AUDIT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scheduledAuditName").getter(getter(ScheduledAuditMetadata::scheduledAuditName))
            .setter(setter(Builder::scheduledAuditName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledAuditName").build())
            .build();

    private static final SdkField<String> SCHEDULED_AUDIT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scheduledAuditArn").getter(getter(ScheduledAuditMetadata::scheduledAuditArn))
            .setter(setter(Builder::scheduledAuditArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledAuditArn").build()).build();

    private static final SdkField<String> FREQUENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("frequency").getter(getter(ScheduledAuditMetadata::frequencyAsString)).setter(setter(Builder::frequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frequency").build()).build();

    private static final SdkField<String> DAY_OF_MONTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dayOfMonth").getter(getter(ScheduledAuditMetadata::dayOfMonth)).setter(setter(Builder::dayOfMonth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dayOfMonth").build()).build();

    private static final SdkField<String> DAY_OF_WEEK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dayOfWeek").getter(getter(ScheduledAuditMetadata::dayOfWeekAsString)).setter(setter(Builder::dayOfWeek))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dayOfWeek").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULED_AUDIT_NAME_FIELD,
            SCHEDULED_AUDIT_ARN_FIELD, FREQUENCY_FIELD, DAY_OF_MONTH_FIELD, DAY_OF_WEEK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String scheduledAuditName;

    private final String scheduledAuditArn;

    private final String frequency;

    private final String dayOfMonth;

    private final String dayOfWeek;

    private ScheduledAuditMetadata(BuilderImpl builder) {
        this.scheduledAuditName = builder.scheduledAuditName;
        this.scheduledAuditArn = builder.scheduledAuditArn;
        this.frequency = builder.frequency;
        this.dayOfMonth = builder.dayOfMonth;
        this.dayOfWeek = builder.dayOfWeek;
    }

    /**
     * <p>
     * The name of the scheduled audit.
     * </p>
     * 
     * @return The name of the scheduled audit.
     */
    public final String scheduledAuditName() {
        return scheduledAuditName;
    }

    /**
     * <p>
     * The ARN of the scheduled audit.
     * </p>
     * 
     * @return The ARN of the scheduled audit.
     */
    public final String scheduledAuditArn() {
        return scheduledAuditArn;
    }

    /**
     * <p>
     * How often the scheduled audit occurs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #frequency} will
     * return {@link AuditFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #frequencyAsString}.
     * </p>
     * 
     * @return How often the scheduled audit occurs.
     * @see AuditFrequency
     */
    public final AuditFrequency frequency() {
        return AuditFrequency.fromValue(frequency);
    }

    /**
     * <p>
     * How often the scheduled audit occurs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #frequency} will
     * return {@link AuditFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #frequencyAsString}.
     * </p>
     * 
     * @return How often the scheduled audit occurs.
     * @see AuditFrequency
     */
    public final String frequencyAsString() {
        return frequency;
    }

    /**
     * <p>
     * The day of the month on which the scheduled audit is run (if the <code>frequency</code> is "MONTHLY"). If days
     * 29-31 are specified, and the month does not have that many days, the audit takes place on the "LAST" day of the
     * month.
     * </p>
     * 
     * @return The day of the month on which the scheduled audit is run (if the <code>frequency</code> is "MONTHLY"). If
     *         days 29-31 are specified, and the month does not have that many days, the audit takes place on the "LAST"
     *         day of the month.
     */
    public final String dayOfMonth() {
        return dayOfMonth;
    }

    /**
     * <p>
     * The day of the week on which the scheduled audit is run (if the <code>frequency</code> is "WEEKLY" or
     * "BIWEEKLY").
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dayOfWeek} will
     * return {@link DayOfWeek#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dayOfWeekAsString}.
     * </p>
     * 
     * @return The day of the week on which the scheduled audit is run (if the <code>frequency</code> is "WEEKLY" or
     *         "BIWEEKLY").
     * @see DayOfWeek
     */
    public final DayOfWeek dayOfWeek() {
        return DayOfWeek.fromValue(dayOfWeek);
    }

    /**
     * <p>
     * The day of the week on which the scheduled audit is run (if the <code>frequency</code> is "WEEKLY" or
     * "BIWEEKLY").
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dayOfWeek} will
     * return {@link DayOfWeek#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dayOfWeekAsString}.
     * </p>
     * 
     * @return The day of the week on which the scheduled audit is run (if the <code>frequency</code> is "WEEKLY" or
     *         "BIWEEKLY").
     * @see DayOfWeek
     */
    public final String dayOfWeekAsString() {
        return dayOfWeek;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scheduledAuditName());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledAuditArn());
        hashCode = 31 * hashCode + Objects.hashCode(frequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dayOfMonth());
        hashCode = 31 * hashCode + Objects.hashCode(dayOfWeekAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledAuditMetadata)) {
            return false;
        }
        ScheduledAuditMetadata other = (ScheduledAuditMetadata) obj;
        return Objects.equals(scheduledAuditName(), other.scheduledAuditName())
                && Objects.equals(scheduledAuditArn(), other.scheduledAuditArn())
                && Objects.equals(frequencyAsString(), other.frequencyAsString())
                && Objects.equals(dayOfMonth(), other.dayOfMonth())
                && Objects.equals(dayOfWeekAsString(), other.dayOfWeekAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScheduledAuditMetadata").add("ScheduledAuditName", scheduledAuditName())
                .add("ScheduledAuditArn", scheduledAuditArn()).add("Frequency", frequencyAsString())
                .add("DayOfMonth", dayOfMonth()).add("DayOfWeek", dayOfWeekAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scheduledAuditName":
            return Optional.ofNullable(clazz.cast(scheduledAuditName()));
        case "scheduledAuditArn":
            return Optional.ofNullable(clazz.cast(scheduledAuditArn()));
        case "frequency":
            return Optional.ofNullable(clazz.cast(frequencyAsString()));
        case "dayOfMonth":
            return Optional.ofNullable(clazz.cast(dayOfMonth()));
        case "dayOfWeek":
            return Optional.ofNullable(clazz.cast(dayOfWeekAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scheduledAuditName", SCHEDULED_AUDIT_NAME_FIELD);
        map.put("scheduledAuditArn", SCHEDULED_AUDIT_ARN_FIELD);
        map.put("frequency", FREQUENCY_FIELD);
        map.put("dayOfMonth", DAY_OF_MONTH_FIELD);
        map.put("dayOfWeek", DAY_OF_WEEK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScheduledAuditMetadata, T> g) {
        return obj -> g.apply((ScheduledAuditMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduledAuditMetadata> {
        /**
         * <p>
         * The name of the scheduled audit.
         * </p>
         * 
         * @param scheduledAuditName
         *        The name of the scheduled audit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledAuditName(String scheduledAuditName);

        /**
         * <p>
         * The ARN of the scheduled audit.
         * </p>
         * 
         * @param scheduledAuditArn
         *        The ARN of the scheduled audit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledAuditArn(String scheduledAuditArn);

        /**
         * <p>
         * How often the scheduled audit occurs.
         * </p>
         * 
         * @param frequency
         *        How often the scheduled audit occurs.
         * @see AuditFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuditFrequency
         */
        Builder frequency(String frequency);

        /**
         * <p>
         * How often the scheduled audit occurs.
         * </p>
         * 
         * @param frequency
         *        How often the scheduled audit occurs.
         * @see AuditFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuditFrequency
         */
        Builder frequency(AuditFrequency frequency);

        /**
         * <p>
         * The day of the month on which the scheduled audit is run (if the <code>frequency</code> is "MONTHLY"). If
         * days 29-31 are specified, and the month does not have that many days, the audit takes place on the "LAST" day
         * of the month.
         * </p>
         * 
         * @param dayOfMonth
         *        The day of the month on which the scheduled audit is run (if the <code>frequency</code> is "MONTHLY").
         *        If days 29-31 are specified, and the month does not have that many days, the audit takes place on the
         *        "LAST" day of the month.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dayOfMonth(String dayOfMonth);

        /**
         * <p>
         * The day of the week on which the scheduled audit is run (if the <code>frequency</code> is "WEEKLY" or
         * "BIWEEKLY").
         * </p>
         * 
         * @param dayOfWeek
         *        The day of the week on which the scheduled audit is run (if the <code>frequency</code> is "WEEKLY" or
         *        "BIWEEKLY").
         * @see DayOfWeek
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DayOfWeek
         */
        Builder dayOfWeek(String dayOfWeek);

        /**
         * <p>
         * The day of the week on which the scheduled audit is run (if the <code>frequency</code> is "WEEKLY" or
         * "BIWEEKLY").
         * </p>
         * 
         * @param dayOfWeek
         *        The day of the week on which the scheduled audit is run (if the <code>frequency</code> is "WEEKLY" or
         *        "BIWEEKLY").
         * @see DayOfWeek
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DayOfWeek
         */
        Builder dayOfWeek(DayOfWeek dayOfWeek);
    }

    static final class BuilderImpl implements Builder {
        private String scheduledAuditName;

        private String scheduledAuditArn;

        private String frequency;

        private String dayOfMonth;

        private String dayOfWeek;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledAuditMetadata model) {
            scheduledAuditName(model.scheduledAuditName);
            scheduledAuditArn(model.scheduledAuditArn);
            frequency(model.frequency);
            dayOfMonth(model.dayOfMonth);
            dayOfWeek(model.dayOfWeek);
        }

        public final String getScheduledAuditName() {
            return scheduledAuditName;
        }

        public final void setScheduledAuditName(String scheduledAuditName) {
            this.scheduledAuditName = scheduledAuditName;
        }

        @Override
        public final Builder scheduledAuditName(String scheduledAuditName) {
            this.scheduledAuditName = scheduledAuditName;
            return this;
        }

        public final String getScheduledAuditArn() {
            return scheduledAuditArn;
        }

        public final void setScheduledAuditArn(String scheduledAuditArn) {
            this.scheduledAuditArn = scheduledAuditArn;
        }

        @Override
        public final Builder scheduledAuditArn(String scheduledAuditArn) {
            this.scheduledAuditArn = scheduledAuditArn;
            return this;
        }

        public final String getFrequency() {
            return frequency;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        @Override
        public final Builder frequency(AuditFrequency frequency) {
            this.frequency(frequency == null ? null : frequency.toString());
            return this;
        }

        public final String getDayOfMonth() {
            return dayOfMonth;
        }

        public final void setDayOfMonth(String dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
        }

        @Override
        public final Builder dayOfMonth(String dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
            return this;
        }

        public final String getDayOfWeek() {
            return dayOfWeek;
        }

        public final void setDayOfWeek(String dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
        }

        @Override
        public final Builder dayOfWeek(String dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return this;
        }

        @Override
        public final Builder dayOfWeek(DayOfWeek dayOfWeek) {
            this.dayOfWeek(dayOfWeek == null ? null : dayOfWeek.toString());
            return this;
        }

        @Override
        public ScheduledAuditMetadata build() {
            return new ScheduledAuditMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
