/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.CommandExecutionSummary;
import software.amazon.awssdk.services.iot.model.CommandExecutionSummaryListCopier;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCommandExecutionsResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListCommandExecutionsResponse> {
    private static final SdkField<List<CommandExecutionSummary>> COMMAND_EXECUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("commandExecutions").getter(ListCommandExecutionsResponse.getter(ListCommandExecutionsResponse::commandExecutions)).setter(ListCommandExecutionsResponse.setter(Builder::commandExecutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commandExecutions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CommandExecutionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCommandExecutionsResponse.getter(ListCommandExecutionsResponse::nextToken)).setter(ListCommandExecutionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMAND_EXECUTIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCommandExecutionsResponse.memberNameToFieldInitializer();
    private final List<CommandExecutionSummary> commandExecutions;
    private final String nextToken;

    private ListCommandExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.commandExecutions = builder.commandExecutions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCommandExecutions() {
        return this.commandExecutions != null && !(this.commandExecutions instanceof SdkAutoConstructList);
    }

    public final List<CommandExecutionSummary> commandExecutions() {
        return this.commandExecutions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCommandExecutions() ? this.commandExecutions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCommandExecutionsResponse)) {
            return false;
        }
        ListCommandExecutionsResponse other = (ListCommandExecutionsResponse)((Object)obj);
        return this.hasCommandExecutions() == other.hasCommandExecutions() && Objects.equals(this.commandExecutions(), other.commandExecutions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCommandExecutionsResponse").add("CommandExecutions", this.hasCommandExecutions() ? this.commandExecutions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "commandExecutions": {
                return Optional.ofNullable(clazz.cast(this.commandExecutions()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("commandExecutions", COMMAND_EXECUTIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCommandExecutionsResponse, T> g) {
        return obj -> g.apply((ListCommandExecutionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<CommandExecutionSummary> commandExecutions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCommandExecutionsResponse model) {
            super(model);
            this.commandExecutions(model.commandExecutions);
            this.nextToken(model.nextToken);
        }

        public final List<CommandExecutionSummary.Builder> getCommandExecutions() {
            List<CommandExecutionSummary.Builder> result = CommandExecutionSummaryListCopier.copyToBuilder(this.commandExecutions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCommandExecutions(Collection<CommandExecutionSummary.BuilderImpl> commandExecutions) {
            this.commandExecutions = CommandExecutionSummaryListCopier.copyFromBuilder(commandExecutions);
        }

        @Override
        public final Builder commandExecutions(Collection<CommandExecutionSummary> commandExecutions) {
            this.commandExecutions = CommandExecutionSummaryListCopier.copy(commandExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commandExecutions(CommandExecutionSummary ... commandExecutions) {
            this.commandExecutions(Arrays.asList(commandExecutions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commandExecutions(Consumer<CommandExecutionSummary.Builder> ... commandExecutions) {
            this.commandExecutions(Stream.of(commandExecutions).map(c -> (CommandExecutionSummary)((CommandExecutionSummary.Builder)CommandExecutionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCommandExecutionsResponse build() {
            return new ListCommandExecutionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCommandExecutionsResponse> {
        public Builder commandExecutions(Collection<CommandExecutionSummary> var1);

        public Builder commandExecutions(CommandExecutionSummary ... var1);

        public Builder commandExecutions(Consumer<CommandExecutionSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

