/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCommandExecutionsRequest extends IotRequest implements
        ToCopyableBuilder<ListCommandExecutionsRequest.Builder, ListCommandExecutionsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListCommandExecutionsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListCommandExecutionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(ListCommandExecutionsRequest::namespaceAsString))
            .setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ListCommandExecutionsRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sortOrder").getter(getter(ListCommandExecutionsRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()).build();

    private static final SdkField<TimeFilter> STARTED_TIME_FILTER_FIELD = SdkField.<TimeFilter> builder(MarshallingType.SDK_POJO)
            .memberName("startedTimeFilter").getter(getter(ListCommandExecutionsRequest::startedTimeFilter))
            .setter(setter(Builder::startedTimeFilter)).constructor(TimeFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedTimeFilter").build()).build();

    private static final SdkField<TimeFilter> COMPLETED_TIME_FILTER_FIELD = SdkField
            .<TimeFilter> builder(MarshallingType.SDK_POJO).memberName("completedTimeFilter")
            .getter(getter(ListCommandExecutionsRequest::completedTimeFilter)).setter(setter(Builder::completedTimeFilter))
            .constructor(TimeFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completedTimeFilter").build())
            .build();

    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetArn").getter(getter(ListCommandExecutionsRequest::targetArn)).setter(setter(Builder::targetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetArn").build()).build();

    private static final SdkField<String> COMMAND_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("commandArn").getter(getter(ListCommandExecutionsRequest::commandArn))
            .setter(setter(Builder::commandArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commandArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, NAMESPACE_FIELD, STATUS_FIELD, SORT_ORDER_FIELD, STARTED_TIME_FILTER_FIELD,
            COMPLETED_TIME_FILTER_FIELD, TARGET_ARN_FIELD, COMMAND_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer maxResults;

    private final String nextToken;

    private final String namespace;

    private final String status;

    private final String sortOrder;

    private final TimeFilter startedTimeFilter;

    private final TimeFilter completedTimeFilter;

    private final String targetArn;

    private final String commandArn;

    private ListCommandExecutionsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.namespace = builder.namespace;
        this.status = builder.status;
        this.sortOrder = builder.sortOrder;
        this.startedTimeFilter = builder.startedTimeFilter;
        this.completedTimeFilter = builder.completedTimeFilter;
        this.targetArn = builder.targetArn;
        this.commandArn = builder.commandArn;
    }

    /**
     * <p>
     * The maximum number of results to return in this operation.
     * </p>
     * 
     * @return The maximum number of results to return in this operation.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise
     * <code>null</code> to receive the first set of results.
     * </p>
     * 
     * @return To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise
     *         <code>null</code> to receive the first set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The namespace of the command.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #namespace} will
     * return {@link CommandNamespace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #namespaceAsString}.
     * </p>
     * 
     * @return The namespace of the command.
     * @see CommandNamespace
     */
    public final CommandNamespace namespace() {
        return CommandNamespace.fromValue(namespace);
    }

    /**
     * <p>
     * The namespace of the command.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #namespace} will
     * return {@link CommandNamespace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #namespaceAsString}.
     * </p>
     * 
     * @return The namespace of the command.
     * @see CommandNamespace
     */
    public final String namespaceAsString() {
        return namespace;
    }

    /**
     * <p>
     * List all command executions for the device that have a particular status. For example, you can filter the list to
     * display only command executions that have failed or timed out.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CommandExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return List all command executions for the device that have a particular status. For example, you can filter the
     *         list to display only command executions that have failed or timed out.
     * @see CommandExecutionStatus
     */
    public final CommandExecutionStatus status() {
        return CommandExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * List all command executions for the device that have a particular status. For example, you can filter the list to
     * display only command executions that have failed or timed out.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CommandExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return List all command executions for the device that have a particular status. For example, you can filter the
     *         list to display only command executions that have failed or timed out.
     * @see CommandExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Specify whether to list the command executions that were created in the ascending or descending order. By
     * default, the API returns all commands in the descending order based on the start time or completion time of the
     * executions, that are determined by the <code>startTimeFilter</code> and <code>completeTimeFilter</code>
     * parameters.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Specify whether to list the command executions that were created in the ascending or descending order. By
     *         default, the API returns all commands in the descending order based on the start time or completion time
     *         of the executions, that are determined by the <code>startTimeFilter</code> and
     *         <code>completeTimeFilter</code> parameters.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * Specify whether to list the command executions that were created in the ascending or descending order. By
     * default, the API returns all commands in the descending order based on the start time or completion time of the
     * executions, that are determined by the <code>startTimeFilter</code> and <code>completeTimeFilter</code>
     * parameters.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Specify whether to list the command executions that were created in the ascending or descending order. By
     *         default, the API returns all commands in the descending order based on the start time or completion time
     *         of the executions, that are determined by the <code>startTimeFilter</code> and
     *         <code>completeTimeFilter</code> parameters.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * List all command executions that started any time before or after the date and time that you specify. The date
     * and time uses the format <code>yyyy-MM-dd'T'HH:mm</code>.
     * </p>
     * 
     * @return List all command executions that started any time before or after the date and time that you specify. The
     *         date and time uses the format <code>yyyy-MM-dd'T'HH:mm</code>.
     */
    public final TimeFilter startedTimeFilter() {
        return startedTimeFilter;
    }

    /**
     * <p>
     * List all command executions that completed any time before or after the date and time that you specify. The date
     * and time uses the format <code>yyyy-MM-dd'T'HH:mm</code>.
     * </p>
     * 
     * @return List all command executions that completed any time before or after the date and time that you specify.
     *         The date and time uses the format <code>yyyy-MM-dd'T'HH:mm</code>.
     */
    public final TimeFilter completedTimeFilter() {
        return completedTimeFilter;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the target device. You can use this information to list all command
     * executions for a particular device.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the target device. You can use this information to list all command
     *         executions for a particular device.
     */
    public final String targetArn() {
        return targetArn;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the command. You can use this information to list all command executions for
     * a particular command.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the command. You can use this information to list all command
     *         executions for a particular command.
     */
    public final String commandArn() {
        return commandArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startedTimeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(completedTimeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(commandArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCommandExecutionsRequest)) {
            return false;
        }
        ListCommandExecutionsRequest other = (ListCommandExecutionsRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(namespaceAsString(), other.namespaceAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(startedTimeFilter(), other.startedTimeFilter())
                && Objects.equals(completedTimeFilter(), other.completedTimeFilter())
                && Objects.equals(targetArn(), other.targetArn()) && Objects.equals(commandArn(), other.commandArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCommandExecutionsRequest").add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("Namespace", namespaceAsString()).add("Status", statusAsString()).add("SortOrder", sortOrderAsString())
                .add("StartedTimeFilter", startedTimeFilter()).add("CompletedTimeFilter", completedTimeFilter())
                .add("TargetArn", targetArn()).add("CommandArn", commandArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespaceAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "sortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "startedTimeFilter":
            return Optional.ofNullable(clazz.cast(startedTimeFilter()));
        case "completedTimeFilter":
            return Optional.ofNullable(clazz.cast(completedTimeFilter()));
        case "targetArn":
            return Optional.ofNullable(clazz.cast(targetArn()));
        case "commandArn":
            return Optional.ofNullable(clazz.cast(commandArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("namespace", NAMESPACE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("sortOrder", SORT_ORDER_FIELD);
        map.put("startedTimeFilter", STARTED_TIME_FILTER_FIELD);
        map.put("completedTimeFilter", COMPLETED_TIME_FILTER_FIELD);
        map.put("targetArn", TARGET_ARN_FIELD);
        map.put("commandArn", COMMAND_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCommandExecutionsRequest, T> g) {
        return obj -> g.apply((ListCommandExecutionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListCommandExecutionsRequest> {
        /**
         * <p>
         * The maximum number of results to return in this operation.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise
         * <code>null</code> to receive the first set of results.
         * </p>
         * 
         * @param nextToken
         *        To retrieve the next set of results, the <code>nextToken</code> value from a previous response;
         *        otherwise <code>null</code> to receive the first set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The namespace of the command.
         * </p>
         * 
         * @param namespace
         *        The namespace of the command.
         * @see CommandNamespace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommandNamespace
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The namespace of the command.
         * </p>
         * 
         * @param namespace
         *        The namespace of the command.
         * @see CommandNamespace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommandNamespace
         */
        Builder namespace(CommandNamespace namespace);

        /**
         * <p>
         * List all command executions for the device that have a particular status. For example, you can filter the
         * list to display only command executions that have failed or timed out.
         * </p>
         * 
         * @param status
         *        List all command executions for the device that have a particular status. For example, you can filter
         *        the list to display only command executions that have failed or timed out.
         * @see CommandExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommandExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * List all command executions for the device that have a particular status. For example, you can filter the
         * list to display only command executions that have failed or timed out.
         * </p>
         * 
         * @param status
         *        List all command executions for the device that have a particular status. For example, you can filter
         *        the list to display only command executions that have failed or timed out.
         * @see CommandExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommandExecutionStatus
         */
        Builder status(CommandExecutionStatus status);

        /**
         * <p>
         * Specify whether to list the command executions that were created in the ascending or descending order. By
         * default, the API returns all commands in the descending order based on the start time or completion time of
         * the executions, that are determined by the <code>startTimeFilter</code> and <code>completeTimeFilter</code>
         * parameters.
         * </p>
         * 
         * @param sortOrder
         *        Specify whether to list the command executions that were created in the ascending or descending order.
         *        By default, the API returns all commands in the descending order based on the start time or completion
         *        time of the executions, that are determined by the <code>startTimeFilter</code> and
         *        <code>completeTimeFilter</code> parameters.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * Specify whether to list the command executions that were created in the ascending or descending order. By
         * default, the API returns all commands in the descending order based on the start time or completion time of
         * the executions, that are determined by the <code>startTimeFilter</code> and <code>completeTimeFilter</code>
         * parameters.
         * </p>
         * 
         * @param sortOrder
         *        Specify whether to list the command executions that were created in the ascending or descending order.
         *        By default, the API returns all commands in the descending order based on the start time or completion
         *        time of the executions, that are determined by the <code>startTimeFilter</code> and
         *        <code>completeTimeFilter</code> parameters.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        /**
         * <p>
         * List all command executions that started any time before or after the date and time that you specify. The
         * date and time uses the format <code>yyyy-MM-dd'T'HH:mm</code>.
         * </p>
         * 
         * @param startedTimeFilter
         *        List all command executions that started any time before or after the date and time that you specify.
         *        The date and time uses the format <code>yyyy-MM-dd'T'HH:mm</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedTimeFilter(TimeFilter startedTimeFilter);

        /**
         * <p>
         * List all command executions that started any time before or after the date and time that you specify. The
         * date and time uses the format <code>yyyy-MM-dd'T'HH:mm</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeFilter.Builder} avoiding the need to
         * create one manually via {@link TimeFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeFilter.Builder#build()} is called immediately and its result
         * is passed to {@link #startedTimeFilter(TimeFilter)}.
         * 
         * @param startedTimeFilter
         *        a consumer that will call methods on {@link TimeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startedTimeFilter(TimeFilter)
         */
        default Builder startedTimeFilter(Consumer<TimeFilter.Builder> startedTimeFilter) {
            return startedTimeFilter(TimeFilter.builder().applyMutation(startedTimeFilter).build());
        }

        /**
         * <p>
         * List all command executions that completed any time before or after the date and time that you specify. The
         * date and time uses the format <code>yyyy-MM-dd'T'HH:mm</code>.
         * </p>
         * 
         * @param completedTimeFilter
         *        List all command executions that completed any time before or after the date and time that you
         *        specify. The date and time uses the format <code>yyyy-MM-dd'T'HH:mm</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedTimeFilter(TimeFilter completedTimeFilter);

        /**
         * <p>
         * List all command executions that completed any time before or after the date and time that you specify. The
         * date and time uses the format <code>yyyy-MM-dd'T'HH:mm</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeFilter.Builder} avoiding the need to
         * create one manually via {@link TimeFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeFilter.Builder#build()} is called immediately and its result
         * is passed to {@link #completedTimeFilter(TimeFilter)}.
         * 
         * @param completedTimeFilter
         *        a consumer that will call methods on {@link TimeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #completedTimeFilter(TimeFilter)
         */
        default Builder completedTimeFilter(Consumer<TimeFilter.Builder> completedTimeFilter) {
            return completedTimeFilter(TimeFilter.builder().applyMutation(completedTimeFilter).build());
        }

        /**
         * <p>
         * The Amazon Resource Number (ARN) of the target device. You can use this information to list all command
         * executions for a particular device.
         * </p>
         * 
         * @param targetArn
         *        The Amazon Resource Number (ARN) of the target device. You can use this information to list all
         *        command executions for a particular device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetArn(String targetArn);

        /**
         * <p>
         * The Amazon Resource Number (ARN) of the command. You can use this information to list all command executions
         * for a particular command.
         * </p>
         * 
         * @param commandArn
         *        The Amazon Resource Number (ARN) of the command. You can use this information to list all command
         *        executions for a particular command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandArn(String commandArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private String namespace;

        private String status;

        private String sortOrder;

        private TimeFilter startedTimeFilter;

        private TimeFilter completedTimeFilter;

        private String targetArn;

        private String commandArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCommandExecutionsRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            namespace(model.namespace);
            status(model.status);
            sortOrder(model.sortOrder);
            startedTimeFilter(model.startedTimeFilter);
            completedTimeFilter(model.completedTimeFilter);
            targetArn(model.targetArn);
            commandArn(model.commandArn);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public final Builder namespace(CommandNamespace namespace) {
            this.namespace(namespace == null ? null : namespace.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CommandExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final TimeFilter.Builder getStartedTimeFilter() {
            return startedTimeFilter != null ? startedTimeFilter.toBuilder() : null;
        }

        public final void setStartedTimeFilter(TimeFilter.BuilderImpl startedTimeFilter) {
            this.startedTimeFilter = startedTimeFilter != null ? startedTimeFilter.build() : null;
        }

        @Override
        public final Builder startedTimeFilter(TimeFilter startedTimeFilter) {
            this.startedTimeFilter = startedTimeFilter;
            return this;
        }

        public final TimeFilter.Builder getCompletedTimeFilter() {
            return completedTimeFilter != null ? completedTimeFilter.toBuilder() : null;
        }

        public final void setCompletedTimeFilter(TimeFilter.BuilderImpl completedTimeFilter) {
            this.completedTimeFilter = completedTimeFilter != null ? completedTimeFilter.build() : null;
        }

        @Override
        public final Builder completedTimeFilter(TimeFilter completedTimeFilter) {
            this.completedTimeFilter = completedTimeFilter;
            return this;
        }

        public final String getTargetArn() {
            return targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final String getCommandArn() {
            return commandArn;
        }

        public final void setCommandArn(String commandArn) {
            this.commandArn = commandArn;
        }

        @Override
        public final Builder commandArn(String commandArn) {
            this.commandArn = commandArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCommandExecutionsRequest build() {
            return new ListCommandExecutionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
