/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaskStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TaskStatistics> {
    private static final SdkField<Integer> TOTAL_CHECKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("totalChecks").getter(TaskStatistics.getter(TaskStatistics::totalChecks)).setter(TaskStatistics.setter(Builder::totalChecks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalChecks").build()}).build();
    private static final SdkField<Integer> IN_PROGRESS_CHECKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("inProgressChecks").getter(TaskStatistics.getter(TaskStatistics::inProgressChecks)).setter(TaskStatistics.setter(Builder::inProgressChecks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inProgressChecks").build()}).build();
    private static final SdkField<Integer> WAITING_FOR_DATA_COLLECTION_CHECKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("waitingForDataCollectionChecks").getter(TaskStatistics.getter(TaskStatistics::waitingForDataCollectionChecks)).setter(TaskStatistics.setter(Builder::waitingForDataCollectionChecks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("waitingForDataCollectionChecks").build()}).build();
    private static final SdkField<Integer> COMPLIANT_CHECKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("compliantChecks").getter(TaskStatistics.getter(TaskStatistics::compliantChecks)).setter(TaskStatistics.setter(Builder::compliantChecks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compliantChecks").build()}).build();
    private static final SdkField<Integer> NON_COMPLIANT_CHECKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("nonCompliantChecks").getter(TaskStatistics.getter(TaskStatistics::nonCompliantChecks)).setter(TaskStatistics.setter(Builder::nonCompliantChecks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nonCompliantChecks").build()}).build();
    private static final SdkField<Integer> FAILED_CHECKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("failedChecks").getter(TaskStatistics.getter(TaskStatistics::failedChecks)).setter(TaskStatistics.setter(Builder::failedChecks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedChecks").build()}).build();
    private static final SdkField<Integer> CANCELED_CHECKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("canceledChecks").getter(TaskStatistics.getter(TaskStatistics::canceledChecks)).setter(TaskStatistics.setter(Builder::canceledChecks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canceledChecks").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_CHECKS_FIELD, IN_PROGRESS_CHECKS_FIELD, WAITING_FOR_DATA_COLLECTION_CHECKS_FIELD, COMPLIANT_CHECKS_FIELD, NON_COMPLIANT_CHECKS_FIELD, FAILED_CHECKS_FIELD, CANCELED_CHECKS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TaskStatistics.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer totalChecks;
    private final Integer inProgressChecks;
    private final Integer waitingForDataCollectionChecks;
    private final Integer compliantChecks;
    private final Integer nonCompliantChecks;
    private final Integer failedChecks;
    private final Integer canceledChecks;

    private TaskStatistics(BuilderImpl builder) {
        this.totalChecks = builder.totalChecks;
        this.inProgressChecks = builder.inProgressChecks;
        this.waitingForDataCollectionChecks = builder.waitingForDataCollectionChecks;
        this.compliantChecks = builder.compliantChecks;
        this.nonCompliantChecks = builder.nonCompliantChecks;
        this.failedChecks = builder.failedChecks;
        this.canceledChecks = builder.canceledChecks;
    }

    public final Integer totalChecks() {
        return this.totalChecks;
    }

    public final Integer inProgressChecks() {
        return this.inProgressChecks;
    }

    public final Integer waitingForDataCollectionChecks() {
        return this.waitingForDataCollectionChecks;
    }

    public final Integer compliantChecks() {
        return this.compliantChecks;
    }

    public final Integer nonCompliantChecks() {
        return this.nonCompliantChecks;
    }

    public final Integer failedChecks() {
        return this.failedChecks;
    }

    public final Integer canceledChecks() {
        return this.canceledChecks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.totalChecks());
        hashCode = 31 * hashCode + Objects.hashCode(this.inProgressChecks());
        hashCode = 31 * hashCode + Objects.hashCode(this.waitingForDataCollectionChecks());
        hashCode = 31 * hashCode + Objects.hashCode(this.compliantChecks());
        hashCode = 31 * hashCode + Objects.hashCode(this.nonCompliantChecks());
        hashCode = 31 * hashCode + Objects.hashCode(this.failedChecks());
        hashCode = 31 * hashCode + Objects.hashCode(this.canceledChecks());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskStatistics)) {
            return false;
        }
        TaskStatistics other = (TaskStatistics)obj;
        return Objects.equals(this.totalChecks(), other.totalChecks()) && Objects.equals(this.inProgressChecks(), other.inProgressChecks()) && Objects.equals(this.waitingForDataCollectionChecks(), other.waitingForDataCollectionChecks()) && Objects.equals(this.compliantChecks(), other.compliantChecks()) && Objects.equals(this.nonCompliantChecks(), other.nonCompliantChecks()) && Objects.equals(this.failedChecks(), other.failedChecks()) && Objects.equals(this.canceledChecks(), other.canceledChecks());
    }

    public final String toString() {
        return ToString.builder((String)"TaskStatistics").add("TotalChecks", (Object)this.totalChecks()).add("InProgressChecks", (Object)this.inProgressChecks()).add("WaitingForDataCollectionChecks", (Object)this.waitingForDataCollectionChecks()).add("CompliantChecks", (Object)this.compliantChecks()).add("NonCompliantChecks", (Object)this.nonCompliantChecks()).add("FailedChecks", (Object)this.failedChecks()).add("CanceledChecks", (Object)this.canceledChecks()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "totalChecks": {
                return Optional.ofNullable(clazz.cast(this.totalChecks()));
            }
            case "inProgressChecks": {
                return Optional.ofNullable(clazz.cast(this.inProgressChecks()));
            }
            case "waitingForDataCollectionChecks": {
                return Optional.ofNullable(clazz.cast(this.waitingForDataCollectionChecks()));
            }
            case "compliantChecks": {
                return Optional.ofNullable(clazz.cast(this.compliantChecks()));
            }
            case "nonCompliantChecks": {
                return Optional.ofNullable(clazz.cast(this.nonCompliantChecks()));
            }
            case "failedChecks": {
                return Optional.ofNullable(clazz.cast(this.failedChecks()));
            }
            case "canceledChecks": {
                return Optional.ofNullable(clazz.cast(this.canceledChecks()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Integer>> map = new HashMap<String, SdkField<Integer>>();
        map.put("totalChecks", TOTAL_CHECKS_FIELD);
        map.put("inProgressChecks", IN_PROGRESS_CHECKS_FIELD);
        map.put("waitingForDataCollectionChecks", WAITING_FOR_DATA_COLLECTION_CHECKS_FIELD);
        map.put("compliantChecks", COMPLIANT_CHECKS_FIELD);
        map.put("nonCompliantChecks", NON_COMPLIANT_CHECKS_FIELD);
        map.put("failedChecks", FAILED_CHECKS_FIELD);
        map.put("canceledChecks", CANCELED_CHECKS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TaskStatistics, T> g) {
        return obj -> g.apply((TaskStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer totalChecks;
        private Integer inProgressChecks;
        private Integer waitingForDataCollectionChecks;
        private Integer compliantChecks;
        private Integer nonCompliantChecks;
        private Integer failedChecks;
        private Integer canceledChecks;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskStatistics model) {
            this.totalChecks(model.totalChecks);
            this.inProgressChecks(model.inProgressChecks);
            this.waitingForDataCollectionChecks(model.waitingForDataCollectionChecks);
            this.compliantChecks(model.compliantChecks);
            this.nonCompliantChecks(model.nonCompliantChecks);
            this.failedChecks(model.failedChecks);
            this.canceledChecks(model.canceledChecks);
        }

        public final Integer getTotalChecks() {
            return this.totalChecks;
        }

        public final void setTotalChecks(Integer totalChecks) {
            this.totalChecks = totalChecks;
        }

        @Override
        public final Builder totalChecks(Integer totalChecks) {
            this.totalChecks = totalChecks;
            return this;
        }

        public final Integer getInProgressChecks() {
            return this.inProgressChecks;
        }

        public final void setInProgressChecks(Integer inProgressChecks) {
            this.inProgressChecks = inProgressChecks;
        }

        @Override
        public final Builder inProgressChecks(Integer inProgressChecks) {
            this.inProgressChecks = inProgressChecks;
            return this;
        }

        public final Integer getWaitingForDataCollectionChecks() {
            return this.waitingForDataCollectionChecks;
        }

        public final void setWaitingForDataCollectionChecks(Integer waitingForDataCollectionChecks) {
            this.waitingForDataCollectionChecks = waitingForDataCollectionChecks;
        }

        @Override
        public final Builder waitingForDataCollectionChecks(Integer waitingForDataCollectionChecks) {
            this.waitingForDataCollectionChecks = waitingForDataCollectionChecks;
            return this;
        }

        public final Integer getCompliantChecks() {
            return this.compliantChecks;
        }

        public final void setCompliantChecks(Integer compliantChecks) {
            this.compliantChecks = compliantChecks;
        }

        @Override
        public final Builder compliantChecks(Integer compliantChecks) {
            this.compliantChecks = compliantChecks;
            return this;
        }

        public final Integer getNonCompliantChecks() {
            return this.nonCompliantChecks;
        }

        public final void setNonCompliantChecks(Integer nonCompliantChecks) {
            this.nonCompliantChecks = nonCompliantChecks;
        }

        @Override
        public final Builder nonCompliantChecks(Integer nonCompliantChecks) {
            this.nonCompliantChecks = nonCompliantChecks;
            return this;
        }

        public final Integer getFailedChecks() {
            return this.failedChecks;
        }

        public final void setFailedChecks(Integer failedChecks) {
            this.failedChecks = failedChecks;
        }

        @Override
        public final Builder failedChecks(Integer failedChecks) {
            this.failedChecks = failedChecks;
            return this;
        }

        public final Integer getCanceledChecks() {
            return this.canceledChecks;
        }

        public final void setCanceledChecks(Integer canceledChecks) {
            this.canceledChecks = canceledChecks;
        }

        @Override
        public final Builder canceledChecks(Integer canceledChecks) {
            this.canceledChecks = canceledChecks;
            return this;
        }

        public TaskStatistics build() {
            return new TaskStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TaskStatistics> {
        public Builder totalChecks(Integer var1);

        public Builder inProgressChecks(Integer var1);

        public Builder waitingForDataCollectionChecks(Integer var1);

        public Builder compliantChecks(Integer var1);

        public Builder nonCompliantChecks(Integer var1);

        public Builder failedChecks(Integer var1);

        public Builder canceledChecks(Integer var1);
    }
}

