/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the CreateCertificateFromCsr operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCertificateFromCsrRequest extends IotRequest implements
        ToCopyableBuilder<CreateCertificateFromCsrRequest.Builder, CreateCertificateFromCsrRequest> {
    private static final SdkField<String> CERTIFICATE_SIGNING_REQUEST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificateSigningRequest").getter(getter(CreateCertificateFromCsrRequest::certificateSigningRequest))
            .setter(setter(Builder::certificateSigningRequest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateSigningRequest").build())
            .build();

    private static final SdkField<Boolean> SET_AS_ACTIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("setAsActive").getter(getter(CreateCertificateFromCsrRequest::setAsActive))
            .setter(setter(Builder::setAsActive))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("setAsActive").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CERTIFICATE_SIGNING_REQUEST_FIELD, SET_AS_ACTIVE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String certificateSigningRequest;

    private final Boolean setAsActive;

    private CreateCertificateFromCsrRequest(BuilderImpl builder) {
        super(builder);
        this.certificateSigningRequest = builder.certificateSigningRequest;
        this.setAsActive = builder.setAsActive;
    }

    /**
     * <p>
     * The certificate signing request (CSR).
     * </p>
     * 
     * @return The certificate signing request (CSR).
     */
    public final String certificateSigningRequest() {
        return certificateSigningRequest;
    }

    /**
     * <p>
     * Specifies whether the certificate is active.
     * </p>
     * 
     * @return Specifies whether the certificate is active.
     */
    public final Boolean setAsActive() {
        return setAsActive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(certificateSigningRequest());
        hashCode = 31 * hashCode + Objects.hashCode(setAsActive());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCertificateFromCsrRequest)) {
            return false;
        }
        CreateCertificateFromCsrRequest other = (CreateCertificateFromCsrRequest) obj;
        return Objects.equals(certificateSigningRequest(), other.certificateSigningRequest())
                && Objects.equals(setAsActive(), other.setAsActive());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCertificateFromCsrRequest").add("CertificateSigningRequest", certificateSigningRequest())
                .add("SetAsActive", setAsActive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateSigningRequest":
            return Optional.ofNullable(clazz.cast(certificateSigningRequest()));
        case "setAsActive":
            return Optional.ofNullable(clazz.cast(setAsActive()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("certificateSigningRequest", CERTIFICATE_SIGNING_REQUEST_FIELD);
        map.put("setAsActive", SET_AS_ACTIVE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCertificateFromCsrRequest, T> g) {
        return obj -> g.apply((CreateCertificateFromCsrRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateCertificateFromCsrRequest> {
        /**
         * <p>
         * The certificate signing request (CSR).
         * </p>
         * 
         * @param certificateSigningRequest
         *        The certificate signing request (CSR).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateSigningRequest(String certificateSigningRequest);

        /**
         * <p>
         * Specifies whether the certificate is active.
         * </p>
         * 
         * @param setAsActive
         *        Specifies whether the certificate is active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder setAsActive(Boolean setAsActive);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String certificateSigningRequest;

        private Boolean setAsActive;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCertificateFromCsrRequest model) {
            super(model);
            certificateSigningRequest(model.certificateSigningRequest);
            setAsActive(model.setAsActive);
        }

        public final String getCertificateSigningRequest() {
            return certificateSigningRequest;
        }

        public final void setCertificateSigningRequest(String certificateSigningRequest) {
            this.certificateSigningRequest = certificateSigningRequest;
        }

        @Override
        public final Builder certificateSigningRequest(String certificateSigningRequest) {
            this.certificateSigningRequest = certificateSigningRequest;
            return this;
        }

        public final Boolean getSetAsActive() {
            return setAsActive;
        }

        public final void setSetAsActive(Boolean setAsActive) {
            this.setAsActive = setAsActive;
        }

        @Override
        @Transient
        public final Builder setAsActive(Boolean setAsActive) {
            this.setAsActive = setAsActive;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCertificateFromCsrRequest build() {
            return new CreateCertificateFromCsrRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
