/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The connectivity status of the thing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThingConnectivity implements SdkPojo, Serializable,
        ToCopyableBuilder<ThingConnectivity.Builder, ThingConnectivity> {
    private static final SdkField<Boolean> CONNECTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("connected").getter(getter(ThingConnectivity::connected)).setter(setter(Builder::connected))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connected").build()).build();

    private static final SdkField<Long> TIMESTAMP_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("timestamp")
            .getter(getter(ThingConnectivity::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()).build();

    private static final SdkField<String> DISCONNECT_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("disconnectReason").getter(getter(ThingConnectivity::disconnectReason))
            .setter(setter(Builder::disconnectReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disconnectReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTED_FIELD,
            TIMESTAMP_FIELD, DISCONNECT_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean connected;

    private final Long timestamp;

    private final String disconnectReason;

    private ThingConnectivity(BuilderImpl builder) {
        this.connected = builder.connected;
        this.timestamp = builder.timestamp;
        this.disconnectReason = builder.disconnectReason;
    }

    /**
     * <p>
     * True if the thing is connected to the Amazon Web Services IoT Core service; false if it is not connected.
     * </p>
     * 
     * @return True if the thing is connected to the Amazon Web Services IoT Core service; false if it is not connected.
     */
    public final Boolean connected() {
        return connected;
    }

    /**
     * <p>
     * The epoch time (in milliseconds) when the thing last connected or disconnected. If the thing has been
     * disconnected for approximately an hour, the time value might be missing.
     * </p>
     * 
     * @return The epoch time (in milliseconds) when the thing last connected or disconnected. If the thing has been
     *         disconnected for approximately an hour, the time value might be missing.
     */
    public final Long timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The reason why the client is disconnected. If the thing has been disconnected for approximately an hour, the
     * <code>disconnectReason</code> value might be missing.
     * </p>
     * 
     * @return The reason why the client is disconnected. If the thing has been disconnected for approximately an hour,
     *         the <code>disconnectReason</code> value might be missing.
     */
    public final String disconnectReason() {
        return disconnectReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connected());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(disconnectReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingConnectivity)) {
            return false;
        }
        ThingConnectivity other = (ThingConnectivity) obj;
        return Objects.equals(connected(), other.connected()) && Objects.equals(timestamp(), other.timestamp())
                && Objects.equals(disconnectReason(), other.disconnectReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ThingConnectivity").add("Connected", connected()).add("Timestamp", timestamp())
                .add("DisconnectReason", disconnectReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connected":
            return Optional.ofNullable(clazz.cast(connected()));
        case "timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "disconnectReason":
            return Optional.ofNullable(clazz.cast(disconnectReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("connected", CONNECTED_FIELD);
        map.put("timestamp", TIMESTAMP_FIELD);
        map.put("disconnectReason", DISCONNECT_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ThingConnectivity, T> g) {
        return obj -> g.apply((ThingConnectivity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThingConnectivity> {
        /**
         * <p>
         * True if the thing is connected to the Amazon Web Services IoT Core service; false if it is not connected.
         * </p>
         * 
         * @param connected
         *        True if the thing is connected to the Amazon Web Services IoT Core service; false if it is not
         *        connected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connected(Boolean connected);

        /**
         * <p>
         * The epoch time (in milliseconds) when the thing last connected or disconnected. If the thing has been
         * disconnected for approximately an hour, the time value might be missing.
         * </p>
         * 
         * @param timestamp
         *        The epoch time (in milliseconds) when the thing last connected or disconnected. If the thing has been
         *        disconnected for approximately an hour, the time value might be missing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Long timestamp);

        /**
         * <p>
         * The reason why the client is disconnected. If the thing has been disconnected for approximately an hour, the
         * <code>disconnectReason</code> value might be missing.
         * </p>
         * 
         * @param disconnectReason
         *        The reason why the client is disconnected. If the thing has been disconnected for approximately an
         *        hour, the <code>disconnectReason</code> value might be missing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disconnectReason(String disconnectReason);
    }

    static final class BuilderImpl implements Builder {
        private Boolean connected;

        private Long timestamp;

        private String disconnectReason;

        private BuilderImpl() {
        }

        private BuilderImpl(ThingConnectivity model) {
            connected(model.connected);
            timestamp(model.timestamp);
            disconnectReason(model.disconnectReason);
        }

        public final Boolean getConnected() {
            return connected;
        }

        public final void setConnected(Boolean connected) {
            this.connected = connected;
        }

        @Override
        public final Builder connected(Boolean connected) {
            this.connected = connected;
            return this;
        }

        public final Long getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getDisconnectReason() {
            return disconnectReason;
        }

        public final void setDisconnectReason(String disconnectReason) {
            this.disconnectReason = disconnectReason;
        }

        @Override
        public final Builder disconnectReason(String disconnectReason) {
            this.disconnectReason = disconnectReason;
            return this;
        }

        @Override
        public ThingConnectivity build() {
            return new ThingConnectivity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
