/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSecurityProfileResponse extends IotResponse implements
        ToCopyableBuilder<UpdateSecurityProfileResponse.Builder, UpdateSecurityProfileResponse> {
    private static final SdkField<String> SECURITY_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateSecurityProfileResponse::securityProfileName)).setter(setter(Builder::securityProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityProfileName").build())
            .build();

    private static final SdkField<String> SECURITY_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateSecurityProfileResponse::securityProfileArn)).setter(setter(Builder::securityProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityProfileArn").build())
            .build();

    private static final SdkField<String> SECURITY_PROFILE_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateSecurityProfileResponse::securityProfileDescription))
            .setter(setter(Builder::securityProfileDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityProfileDescription").build())
            .build();

    private static final SdkField<List<Behavior>> BEHAVIORS_FIELD = SdkField
            .<List<Behavior>> builder(MarshallingType.LIST)
            .getter(getter(UpdateSecurityProfileResponse::behaviors))
            .setter(setter(Builder::behaviors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("behaviors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Behavior> builder(MarshallingType.SDK_POJO)
                                            .constructor(Behavior::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, AlertTarget>> ALERT_TARGETS_FIELD = SdkField
            .<Map<String, AlertTarget>> builder(MarshallingType.MAP)
            .getter(getter(UpdateSecurityProfileResponse::alertTargetsAsStrings))
            .setter(setter(Builder::alertTargetsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alertTargets").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AlertTarget> builder(MarshallingType.SDK_POJO)
                                            .constructor(AlertTarget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Long> VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(UpdateSecurityProfileResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(UpdateSecurityProfileResponse::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(UpdateSecurityProfileResponse::lastModifiedDate)).setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_PROFILE_NAME_FIELD,
            SECURITY_PROFILE_ARN_FIELD, SECURITY_PROFILE_DESCRIPTION_FIELD, BEHAVIORS_FIELD, ALERT_TARGETS_FIELD, VERSION_FIELD,
            CREATION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD));

    private final String securityProfileName;

    private final String securityProfileArn;

    private final String securityProfileDescription;

    private final List<Behavior> behaviors;

    private final Map<String, AlertTarget> alertTargets;

    private final Long version;

    private final Instant creationDate;

    private final Instant lastModifiedDate;

    private UpdateSecurityProfileResponse(BuilderImpl builder) {
        super(builder);
        this.securityProfileName = builder.securityProfileName;
        this.securityProfileArn = builder.securityProfileArn;
        this.securityProfileDescription = builder.securityProfileDescription;
        this.behaviors = builder.behaviors;
        this.alertTargets = builder.alertTargets;
        this.version = builder.version;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    /**
     * <p>
     * The name of the security profile that was updated.
     * </p>
     * 
     * @return The name of the security profile that was updated.
     */
    public String securityProfileName() {
        return securityProfileName;
    }

    /**
     * <p>
     * The ARN of the security profile that was updated.
     * </p>
     * 
     * @return The ARN of the security profile that was updated.
     */
    public String securityProfileArn() {
        return securityProfileArn;
    }

    /**
     * <p>
     * The description of the security profile.
     * </p>
     * 
     * @return The description of the security profile.
     */
    public String securityProfileDescription() {
        return securityProfileDescription;
    }

    /**
     * <p>
     * Specifies the behaviors that, when violated by a device (thing), cause an alert.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Specifies the behaviors that, when violated by a device (thing), cause an alert.
     */
    public List<Behavior> behaviors() {
        return behaviors;
    }

    /**
     * <p>
     * Where the alerts are sent. (Alerts are always sent to the console.)
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Where the alerts are sent. (Alerts are always sent to the console.)
     */
    public Map<AlertTargetType, AlertTarget> alertTargets() {
        return TypeConverter.convert(alertTargets, AlertTargetType::fromValue, Function.identity(),
                (k, v) -> !Objects.equals(k, AlertTargetType.UNKNOWN_TO_SDK_VERSION));
    }

    /**
     * <p>
     * Where the alerts are sent. (Alerts are always sent to the console.)
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Where the alerts are sent. (Alerts are always sent to the console.)
     */
    public Map<String, AlertTarget> alertTargetsAsStrings() {
        return alertTargets;
    }

    /**
     * <p>
     * The updated version of the security profile.
     * </p>
     * 
     * @return The updated version of the security profile.
     */
    public Long version() {
        return version;
    }

    /**
     * <p>
     * The time the security profile was created.
     * </p>
     * 
     * @return The time the security profile was created.
     */
    public Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The time the security profile was last modified.
     * </p>
     * 
     * @return The time the security profile was last modified.
     */
    public Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(securityProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(securityProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(securityProfileDescription());
        hashCode = 31 * hashCode + Objects.hashCode(behaviors());
        hashCode = 31 * hashCode + Objects.hashCode(alertTargetsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSecurityProfileResponse)) {
            return false;
        }
        UpdateSecurityProfileResponse other = (UpdateSecurityProfileResponse) obj;
        return Objects.equals(securityProfileName(), other.securityProfileName())
                && Objects.equals(securityProfileArn(), other.securityProfileArn())
                && Objects.equals(securityProfileDescription(), other.securityProfileDescription())
                && Objects.equals(behaviors(), other.behaviors())
                && Objects.equals(alertTargetsAsStrings(), other.alertTargetsAsStrings())
                && Objects.equals(version(), other.version()) && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateSecurityProfileResponse").add("SecurityProfileName", securityProfileName())
                .add("SecurityProfileArn", securityProfileArn()).add("SecurityProfileDescription", securityProfileDescription())
                .add("Behaviors", behaviors()).add("AlertTargets", alertTargetsAsStrings()).add("Version", version())
                .add("CreationDate", creationDate()).add("LastModifiedDate", lastModifiedDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "securityProfileName":
            return Optional.ofNullable(clazz.cast(securityProfileName()));
        case "securityProfileArn":
            return Optional.ofNullable(clazz.cast(securityProfileArn()));
        case "securityProfileDescription":
            return Optional.ofNullable(clazz.cast(securityProfileDescription()));
        case "behaviors":
            return Optional.ofNullable(clazz.cast(behaviors()));
        case "alertTargets":
            return Optional.ofNullable(clazz.cast(alertTargetsAsStrings()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "lastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSecurityProfileResponse, T> g) {
        return obj -> g.apply((UpdateSecurityProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSecurityProfileResponse> {
        /**
         * <p>
         * The name of the security profile that was updated.
         * </p>
         * 
         * @param securityProfileName
         *        The name of the security profile that was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileName(String securityProfileName);

        /**
         * <p>
         * The ARN of the security profile that was updated.
         * </p>
         * 
         * @param securityProfileArn
         *        The ARN of the security profile that was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileArn(String securityProfileArn);

        /**
         * <p>
         * The description of the security profile.
         * </p>
         * 
         * @param securityProfileDescription
         *        The description of the security profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileDescription(String securityProfileDescription);

        /**
         * <p>
         * Specifies the behaviors that, when violated by a device (thing), cause an alert.
         * </p>
         * 
         * @param behaviors
         *        Specifies the behaviors that, when violated by a device (thing), cause an alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder behaviors(Collection<Behavior> behaviors);

        /**
         * <p>
         * Specifies the behaviors that, when violated by a device (thing), cause an alert.
         * </p>
         * 
         * @param behaviors
         *        Specifies the behaviors that, when violated by a device (thing), cause an alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder behaviors(Behavior... behaviors);

        /**
         * <p>
         * Specifies the behaviors that, when violated by a device (thing), cause an alert.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Behavior>.Builder} avoiding the need to
         * create one manually via {@link List<Behavior>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Behavior>.Builder#build()} is called immediately and its
         * result is passed to {@link #behaviors(List<Behavior>)}.
         * 
         * @param behaviors
         *        a consumer that will call methods on {@link List<Behavior>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #behaviors(List<Behavior>)
         */
        Builder behaviors(Consumer<Behavior.Builder>... behaviors);

        /**
         * <p>
         * Where the alerts are sent. (Alerts are always sent to the console.)
         * </p>
         * 
         * @param alertTargets
         *        Where the alerts are sent. (Alerts are always sent to the console.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alertTargetsWithStrings(Map<String, AlertTarget> alertTargets);

        /**
         * <p>
         * Where the alerts are sent. (Alerts are always sent to the console.)
         * </p>
         * 
         * @param alertTargets
         *        Where the alerts are sent. (Alerts are always sent to the console.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alertTargets(Map<AlertTargetType, AlertTarget> alertTargets);

        /**
         * <p>
         * The updated version of the security profile.
         * </p>
         * 
         * @param version
         *        The updated version of the security profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Long version);

        /**
         * <p>
         * The time the security profile was created.
         * </p>
         * 
         * @param creationDate
         *        The time the security profile was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The time the security profile was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The time the security profile was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String securityProfileName;

        private String securityProfileArn;

        private String securityProfileDescription;

        private List<Behavior> behaviors = DefaultSdkAutoConstructList.getInstance();

        private Map<String, AlertTarget> alertTargets = DefaultSdkAutoConstructMap.getInstance();

        private Long version;

        private Instant creationDate;

        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSecurityProfileResponse model) {
            super(model);
            securityProfileName(model.securityProfileName);
            securityProfileArn(model.securityProfileArn);
            securityProfileDescription(model.securityProfileDescription);
            behaviors(model.behaviors);
            alertTargetsWithStrings(model.alertTargets);
            version(model.version);
            creationDate(model.creationDate);
            lastModifiedDate(model.lastModifiedDate);
        }

        public final String getSecurityProfileName() {
            return securityProfileName;
        }

        @Override
        public final Builder securityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
            return this;
        }

        public final void setSecurityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
        }

        public final String getSecurityProfileArn() {
            return securityProfileArn;
        }

        @Override
        public final Builder securityProfileArn(String securityProfileArn) {
            this.securityProfileArn = securityProfileArn;
            return this;
        }

        public final void setSecurityProfileArn(String securityProfileArn) {
            this.securityProfileArn = securityProfileArn;
        }

        public final String getSecurityProfileDescription() {
            return securityProfileDescription;
        }

        @Override
        public final Builder securityProfileDescription(String securityProfileDescription) {
            this.securityProfileDescription = securityProfileDescription;
            return this;
        }

        public final void setSecurityProfileDescription(String securityProfileDescription) {
            this.securityProfileDescription = securityProfileDescription;
        }

        public final Collection<Behavior.Builder> getBehaviors() {
            return behaviors != null ? behaviors.stream().map(Behavior::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder behaviors(Collection<Behavior> behaviors) {
            this.behaviors = BehaviorsCopier.copy(behaviors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder behaviors(Behavior... behaviors) {
            behaviors(Arrays.asList(behaviors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder behaviors(Consumer<Behavior.Builder>... behaviors) {
            behaviors(Stream.of(behaviors).map(c -> Behavior.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBehaviors(Collection<Behavior.BuilderImpl> behaviors) {
            this.behaviors = BehaviorsCopier.copyFromBuilder(behaviors);
        }

        public final Map<String, AlertTarget.Builder> getAlertTargetsAsStrings() {
            return alertTargets != null ? CollectionUtils.mapValues(alertTargets, AlertTarget::toBuilder) : null;
        }

        @Override
        public final Builder alertTargetsWithStrings(Map<String, AlertTarget> alertTargets) {
            this.alertTargets = AlertTargetsCopier.copy(alertTargets);
            return this;
        }

        @Override
        public final Builder alertTargets(Map<AlertTargetType, AlertTarget> alertTargets) {
            this.alertTargets = AlertTargetsCopier.copyEnumToString(alertTargets);
            return this;
        }

        public final void setAlertTargetsWithStrings(Map<String, AlertTarget.BuilderImpl> alertTargets) {
            this.alertTargets = AlertTargetsCopier.copyFromBuilder(alertTargets);
        }

        public final Long getVersion() {
            return version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public UpdateSecurityProfileResponse build() {
            return new UpdateSecurityProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
