/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestInvokeAuthorizerRequest extends IotRequest implements
        ToCopyableBuilder<TestInvokeAuthorizerRequest.Builder, TestInvokeAuthorizerRequest> {
    private static final SdkField<String> AUTHORIZER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TestInvokeAuthorizerRequest::authorizerName)).setter(setter(Builder::authorizerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("authorizerName").build()).build();

    private static final SdkField<String> TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TestInvokeAuthorizerRequest::token)).setter(setter(Builder::token))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("token").build()).build();

    private static final SdkField<String> TOKEN_SIGNATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TestInvokeAuthorizerRequest::tokenSignature)).setter(setter(Builder::tokenSignature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenSignature").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZER_NAME_FIELD,
            TOKEN_FIELD, TOKEN_SIGNATURE_FIELD));

    private final String authorizerName;

    private final String token;

    private final String tokenSignature;

    private TestInvokeAuthorizerRequest(BuilderImpl builder) {
        super(builder);
        this.authorizerName = builder.authorizerName;
        this.token = builder.token;
        this.tokenSignature = builder.tokenSignature;
    }

    /**
     * <p>
     * The custom authorizer name.
     * </p>
     * 
     * @return The custom authorizer name.
     */
    public String authorizerName() {
        return authorizerName;
    }

    /**
     * <p>
     * The token returned by your custom authentication service.
     * </p>
     * 
     * @return The token returned by your custom authentication service.
     */
    public String token() {
        return token;
    }

    /**
     * <p>
     * The signature made with the token and your custom authentication service's private key.
     * </p>
     * 
     * @return The signature made with the token and your custom authentication service's private key.
     */
    public String tokenSignature() {
        return tokenSignature;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authorizerName());
        hashCode = 31 * hashCode + Objects.hashCode(token());
        hashCode = 31 * hashCode + Objects.hashCode(tokenSignature());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestInvokeAuthorizerRequest)) {
            return false;
        }
        TestInvokeAuthorizerRequest other = (TestInvokeAuthorizerRequest) obj;
        return Objects.equals(authorizerName(), other.authorizerName()) && Objects.equals(token(), other.token())
                && Objects.equals(tokenSignature(), other.tokenSignature());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TestInvokeAuthorizerRequest").add("AuthorizerName", authorizerName()).add("Token", token())
                .add("TokenSignature", tokenSignature()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authorizerName":
            return Optional.ofNullable(clazz.cast(authorizerName()));
        case "token":
            return Optional.ofNullable(clazz.cast(token()));
        case "tokenSignature":
            return Optional.ofNullable(clazz.cast(tokenSignature()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestInvokeAuthorizerRequest, T> g) {
        return obj -> g.apply((TestInvokeAuthorizerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, TestInvokeAuthorizerRequest> {
        /**
         * <p>
         * The custom authorizer name.
         * </p>
         * 
         * @param authorizerName
         *        The custom authorizer name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizerName(String authorizerName);

        /**
         * <p>
         * The token returned by your custom authentication service.
         * </p>
         * 
         * @param token
         *        The token returned by your custom authentication service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder token(String token);

        /**
         * <p>
         * The signature made with the token and your custom authentication service's private key.
         * </p>
         * 
         * @param tokenSignature
         *        The signature made with the token and your custom authentication service's private key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenSignature(String tokenSignature);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String authorizerName;

        private String token;

        private String tokenSignature;

        private BuilderImpl() {
        }

        private BuilderImpl(TestInvokeAuthorizerRequest model) {
            super(model);
            authorizerName(model.authorizerName);
            token(model.token);
            tokenSignature(model.tokenSignature);
        }

        public final String getAuthorizerName() {
            return authorizerName;
        }

        @Override
        public final Builder authorizerName(String authorizerName) {
            this.authorizerName = authorizerName;
            return this;
        }

        public final void setAuthorizerName(String authorizerName) {
            this.authorizerName = authorizerName;
        }

        public final String getToken() {
            return token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        public final String getTokenSignature() {
            return tokenSignature;
        }

        @Override
        public final Builder tokenSignature(String tokenSignature) {
            this.tokenSignature = tokenSignature;
            return this;
        }

        public final void setTokenSignature(String tokenSignature) {
            this.tokenSignature = tokenSignature;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestInvokeAuthorizerRequest build() {
            return new TestInvokeAuthorizerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
