/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBillingGroupResponse extends IotResponse implements
        ToCopyableBuilder<UpdateBillingGroupResponse.Builder, UpdateBillingGroupResponse> {
    private static final SdkField<Long> VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(UpdateBillingGroupResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_FIELD));

    private final Long version;

    private UpdateBillingGroupResponse(BuilderImpl builder) {
        super(builder);
        this.version = builder.version;
    }

    /**
     * <p>
     * The latest version of the billing group.
     * </p>
     * 
     * @return The latest version of the billing group.
     */
    public Long version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBillingGroupResponse)) {
            return false;
        }
        UpdateBillingGroupResponse other = (UpdateBillingGroupResponse) obj;
        return Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateBillingGroupResponse").add("Version", version()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBillingGroupResponse, T> g) {
        return obj -> g.apply((UpdateBillingGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateBillingGroupResponse> {
        /**
         * <p>
         * The latest version of the billing group.
         * </p>
         * 
         * @param version
         *        The latest version of the billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Long version);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private Long version;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBillingGroupResponse model) {
            super(model);
            version(model.version);
        }

        public final Long getVersion() {
            return version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        @Override
        public UpdateBillingGroupResponse build() {
            return new UpdateBillingGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
