/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.ListPrincipalPoliciesRequest;
import software.amazon.awssdk.services.iot.model.ListPrincipalPoliciesResponse;
import software.amazon.awssdk.services.iot.model.Policy;

public class ListPrincipalPoliciesPublisher
implements SdkPublisher<ListPrincipalPoliciesResponse> {
    private final IotAsyncClient client;
    private final ListPrincipalPoliciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPrincipalPoliciesPublisher(IotAsyncClient client, ListPrincipalPoliciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPrincipalPoliciesPublisher(IotAsyncClient client, ListPrincipalPoliciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPrincipalPoliciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPrincipalPoliciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Policy> policies() {
        Function<ListPrincipalPoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.policies() != null) {
                return response.policies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPrincipalPoliciesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPrincipalPoliciesResponseFetcher
    implements AsyncPageFetcher<ListPrincipalPoliciesResponse> {
        private ListPrincipalPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListPrincipalPoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<ListPrincipalPoliciesResponse> nextPage(ListPrincipalPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListPrincipalPoliciesPublisher.this.client.listPrincipalPolicies(ListPrincipalPoliciesPublisher.this.firstRequest);
            }
            return ListPrincipalPoliciesPublisher.this.client.listPrincipalPolicies((ListPrincipalPoliciesRequest)((Object)ListPrincipalPoliciesPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

