/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The job execution object represents the execution of a job on a particular device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobExecution implements SdkPojo, Serializable, ToCopyableBuilder<JobExecution.Builder, JobExecution> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JobExecution::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JobExecution::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Boolean> FORCE_CANCELED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(JobExecution::forceCanceled)).setter(setter(Builder::forceCanceled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forceCanceled").build()).build();

    private static final SdkField<JobExecutionStatusDetails> STATUS_DETAILS_FIELD = SdkField
            .<JobExecutionStatusDetails> builder(MarshallingType.SDK_POJO).getter(getter(JobExecution::statusDetails))
            .setter(setter(Builder::statusDetails)).constructor(JobExecutionStatusDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusDetails").build()).build();

    private static final SdkField<String> THING_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JobExecution::thingArn)).setter(setter(Builder::thingArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingArn").build()).build();

    private static final SdkField<Instant> QUEUED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(JobExecution::queuedAt)).setter(setter(Builder::queuedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queuedAt").build()).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(JobExecution::startedAt)).setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(JobExecution::lastUpdatedAt)).setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()).build();

    private static final SdkField<Long> EXECUTION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(JobExecution::executionNumber)).setter(setter(Builder::executionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionNumber").build()).build();

    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(JobExecution::versionNumber)).setter(setter(Builder::versionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionNumber").build()).build();

    private static final SdkField<Long> APPROXIMATE_SECONDS_BEFORE_TIMED_OUT_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .getter(getter(JobExecution::approximateSecondsBeforeTimedOut))
            .setter(setter(Builder::approximateSecondsBeforeTimedOut))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approximateSecondsBeforeTimedOut")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, STATUS_FIELD,
            FORCE_CANCELED_FIELD, STATUS_DETAILS_FIELD, THING_ARN_FIELD, QUEUED_AT_FIELD, STARTED_AT_FIELD,
            LAST_UPDATED_AT_FIELD, EXECUTION_NUMBER_FIELD, VERSION_NUMBER_FIELD, APPROXIMATE_SECONDS_BEFORE_TIMED_OUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String jobId;

    private final String status;

    private final Boolean forceCanceled;

    private final JobExecutionStatusDetails statusDetails;

    private final String thingArn;

    private final Instant queuedAt;

    private final Instant startedAt;

    private final Instant lastUpdatedAt;

    private final Long executionNumber;

    private final Long versionNumber;

    private final Long approximateSecondsBeforeTimedOut;

    private JobExecution(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.status = builder.status;
        this.forceCanceled = builder.forceCanceled;
        this.statusDetails = builder.statusDetails;
        this.thingArn = builder.thingArn;
        this.queuedAt = builder.queuedAt;
        this.startedAt = builder.startedAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.executionNumber = builder.executionNumber;
        this.versionNumber = builder.versionNumber;
        this.approximateSecondsBeforeTimedOut = builder.approximateSecondsBeforeTimedOut;
    }

    /**
     * <p>
     * The unique identifier you assigned to the job when it was created.
     * </p>
     * 
     * @return The unique identifier you assigned to the job when it was created.
     */
    public String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The status of the job execution (IN_PROGRESS, QUEUED, FAILED, SUCCEEDED, TIMED_OUT, CANCELED, or REJECTED).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the job execution (IN_PROGRESS, QUEUED, FAILED, SUCCEEDED, TIMED_OUT, CANCELED, or
     *         REJECTED).
     * @see JobExecutionStatus
     */
    public JobExecutionStatus status() {
        return JobExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the job execution (IN_PROGRESS, QUEUED, FAILED, SUCCEEDED, TIMED_OUT, CANCELED, or REJECTED).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the job execution (IN_PROGRESS, QUEUED, FAILED, SUCCEEDED, TIMED_OUT, CANCELED, or
     *         REJECTED).
     * @see JobExecutionStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Will be <code>true</code> if the job execution was canceled with the optional <code>force</code> parameter set to
     * <code>true</code>.
     * </p>
     * 
     * @return Will be <code>true</code> if the job execution was canceled with the optional <code>force</code>
     *         parameter set to <code>true</code>.
     */
    public Boolean forceCanceled() {
        return forceCanceled;
    }

    /**
     * <p>
     * A collection of name/value pairs that describe the status of the job execution.
     * </p>
     * 
     * @return A collection of name/value pairs that describe the status of the job execution.
     */
    public JobExecutionStatusDetails statusDetails() {
        return statusDetails;
    }

    /**
     * <p>
     * The ARN of the thing on which the job execution is running.
     * </p>
     * 
     * @return The ARN of the thing on which the job execution is running.
     */
    public String thingArn() {
        return thingArn;
    }

    /**
     * <p>
     * The time, in seconds since the epoch, when the job execution was queued.
     * </p>
     * 
     * @return The time, in seconds since the epoch, when the job execution was queued.
     */
    public Instant queuedAt() {
        return queuedAt;
    }

    /**
     * <p>
     * The time, in seconds since the epoch, when the job execution started.
     * </p>
     * 
     * @return The time, in seconds since the epoch, when the job execution started.
     */
    public Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The time, in seconds since the epoch, when the job execution was last updated.
     * </p>
     * 
     * @return The time, in seconds since the epoch, when the job execution was last updated.
     */
    public Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * A string (consisting of the digits "0" through "9") which identifies this particular job execution on this
     * particular device. It can be used in commands which return or update job execution information.
     * </p>
     * 
     * @return A string (consisting of the digits "0" through "9") which identifies this particular job execution on
     *         this particular device. It can be used in commands which return or update job execution information.
     */
    public Long executionNumber() {
        return executionNumber;
    }

    /**
     * <p>
     * The version of the job execution. Job execution versions are incremented each time they are updated by a device.
     * </p>
     * 
     * @return The version of the job execution. Job execution versions are incremented each time they are updated by a
     *         device.
     */
    public Long versionNumber() {
        return versionNumber;
    }

    /**
     * <p>
     * The estimated number of seconds that remain before the job execution status will be changed to
     * <code>TIMED_OUT</code>. The timeout interval can be anywhere between 1 minute and 7 days (1 to 10080 minutes).
     * The actual job execution timeout can occur up to 60 seconds later than the estimated duration. This value will
     * not be included if the job execution has reached a terminal status.
     * </p>
     * 
     * @return The estimated number of seconds that remain before the job execution status will be changed to
     *         <code>TIMED_OUT</code>. The timeout interval can be anywhere between 1 minute and 7 days (1 to 10080
     *         minutes). The actual job execution timeout can occur up to 60 seconds later than the estimated duration.
     *         This value will not be included if the job execution has reached a terminal status.
     */
    public Long approximateSecondsBeforeTimedOut() {
        return approximateSecondsBeforeTimedOut;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(forceCanceled());
        hashCode = 31 * hashCode + Objects.hashCode(statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(thingArn());
        hashCode = 31 * hashCode + Objects.hashCode(queuedAt());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(executionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(approximateSecondsBeforeTimedOut());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobExecution)) {
            return false;
        }
        JobExecution other = (JobExecution) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(forceCanceled(), other.forceCanceled())
                && Objects.equals(statusDetails(), other.statusDetails()) && Objects.equals(thingArn(), other.thingArn())
                && Objects.equals(queuedAt(), other.queuedAt()) && Objects.equals(startedAt(), other.startedAt())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(executionNumber(), other.executionNumber())
                && Objects.equals(versionNumber(), other.versionNumber())
                && Objects.equals(approximateSecondsBeforeTimedOut(), other.approximateSecondsBeforeTimedOut());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("JobExecution").add("JobId", jobId()).add("Status", statusAsString())
                .add("ForceCanceled", forceCanceled()).add("StatusDetails", statusDetails()).add("ThingArn", thingArn())
                .add("QueuedAt", queuedAt()).add("StartedAt", startedAt()).add("LastUpdatedAt", lastUpdatedAt())
                .add("ExecutionNumber", executionNumber()).add("VersionNumber", versionNumber())
                .add("ApproximateSecondsBeforeTimedOut", approximateSecondsBeforeTimedOut()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "forceCanceled":
            return Optional.ofNullable(clazz.cast(forceCanceled()));
        case "statusDetails":
            return Optional.ofNullable(clazz.cast(statusDetails()));
        case "thingArn":
            return Optional.ofNullable(clazz.cast(thingArn()));
        case "queuedAt":
            return Optional.ofNullable(clazz.cast(queuedAt()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "executionNumber":
            return Optional.ofNullable(clazz.cast(executionNumber()));
        case "versionNumber":
            return Optional.ofNullable(clazz.cast(versionNumber()));
        case "approximateSecondsBeforeTimedOut":
            return Optional.ofNullable(clazz.cast(approximateSecondsBeforeTimedOut()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobExecution, T> g) {
        return obj -> g.apply((JobExecution) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobExecution> {
        /**
         * <p>
         * The unique identifier you assigned to the job when it was created.
         * </p>
         * 
         * @param jobId
         *        The unique identifier you assigned to the job when it was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The status of the job execution (IN_PROGRESS, QUEUED, FAILED, SUCCEEDED, TIMED_OUT, CANCELED, or REJECTED).
         * </p>
         * 
         * @param status
         *        The status of the job execution (IN_PROGRESS, QUEUED, FAILED, SUCCEEDED, TIMED_OUT, CANCELED, or
         *        REJECTED).
         * @see JobExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the job execution (IN_PROGRESS, QUEUED, FAILED, SUCCEEDED, TIMED_OUT, CANCELED, or REJECTED).
         * </p>
         * 
         * @param status
         *        The status of the job execution (IN_PROGRESS, QUEUED, FAILED, SUCCEEDED, TIMED_OUT, CANCELED, or
         *        REJECTED).
         * @see JobExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobExecutionStatus
         */
        Builder status(JobExecutionStatus status);

        /**
         * <p>
         * Will be <code>true</code> if the job execution was canceled with the optional <code>force</code> parameter
         * set to <code>true</code>.
         * </p>
         * 
         * @param forceCanceled
         *        Will be <code>true</code> if the job execution was canceled with the optional <code>force</code>
         *        parameter set to <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forceCanceled(Boolean forceCanceled);

        /**
         * <p>
         * A collection of name/value pairs that describe the status of the job execution.
         * </p>
         * 
         * @param statusDetails
         *        A collection of name/value pairs that describe the status of the job execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusDetails(JobExecutionStatusDetails statusDetails);

        /**
         * <p>
         * A collection of name/value pairs that describe the status of the job execution.
         * </p>
         * This is a convenience that creates an instance of the {@link JobExecutionStatusDetails.Builder} avoiding the
         * need to create one manually via {@link JobExecutionStatusDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobExecutionStatusDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #statusDetails(JobExecutionStatusDetails)}.
         * 
         * @param statusDetails
         *        a consumer that will call methods on {@link JobExecutionStatusDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statusDetails(JobExecutionStatusDetails)
         */
        default Builder statusDetails(Consumer<JobExecutionStatusDetails.Builder> statusDetails) {
            return statusDetails(JobExecutionStatusDetails.builder().applyMutation(statusDetails).build());
        }

        /**
         * <p>
         * The ARN of the thing on which the job execution is running.
         * </p>
         * 
         * @param thingArn
         *        The ARN of the thing on which the job execution is running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingArn(String thingArn);

        /**
         * <p>
         * The time, in seconds since the epoch, when the job execution was queued.
         * </p>
         * 
         * @param queuedAt
         *        The time, in seconds since the epoch, when the job execution was queued.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queuedAt(Instant queuedAt);

        /**
         * <p>
         * The time, in seconds since the epoch, when the job execution started.
         * </p>
         * 
         * @param startedAt
         *        The time, in seconds since the epoch, when the job execution started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * The time, in seconds since the epoch, when the job execution was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The time, in seconds since the epoch, when the job execution was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * A string (consisting of the digits "0" through "9") which identifies this particular job execution on this
         * particular device. It can be used in commands which return or update job execution information.
         * </p>
         * 
         * @param executionNumber
         *        A string (consisting of the digits "0" through "9") which identifies this particular job execution on
         *        this particular device. It can be used in commands which return or update job execution information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionNumber(Long executionNumber);

        /**
         * <p>
         * The version of the job execution. Job execution versions are incremented each time they are updated by a
         * device.
         * </p>
         * 
         * @param versionNumber
         *        The version of the job execution. Job execution versions are incremented each time they are updated by
         *        a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionNumber(Long versionNumber);

        /**
         * <p>
         * The estimated number of seconds that remain before the job execution status will be changed to
         * <code>TIMED_OUT</code>. The timeout interval can be anywhere between 1 minute and 7 days (1 to 10080
         * minutes). The actual job execution timeout can occur up to 60 seconds later than the estimated duration. This
         * value will not be included if the job execution has reached a terminal status.
         * </p>
         * 
         * @param approximateSecondsBeforeTimedOut
         *        The estimated number of seconds that remain before the job execution status will be changed to
         *        <code>TIMED_OUT</code>. The timeout interval can be anywhere between 1 minute and 7 days (1 to 10080
         *        minutes). The actual job execution timeout can occur up to 60 seconds later than the estimated
         *        duration. This value will not be included if the job execution has reached a terminal status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approximateSecondsBeforeTimedOut(Long approximateSecondsBeforeTimedOut);
    }

    static final class BuilderImpl implements Builder {
        private String jobId;

        private String status;

        private Boolean forceCanceled;

        private JobExecutionStatusDetails statusDetails;

        private String thingArn;

        private Instant queuedAt;

        private Instant startedAt;

        private Instant lastUpdatedAt;

        private Long executionNumber;

        private Long versionNumber;

        private Long approximateSecondsBeforeTimedOut;

        private BuilderImpl() {
        }

        private BuilderImpl(JobExecution model) {
            jobId(model.jobId);
            status(model.status);
            forceCanceled(model.forceCanceled);
            statusDetails(model.statusDetails);
            thingArn(model.thingArn);
            queuedAt(model.queuedAt);
            startedAt(model.startedAt);
            lastUpdatedAt(model.lastUpdatedAt);
            executionNumber(model.executionNumber);
            versionNumber(model.versionNumber);
            approximateSecondsBeforeTimedOut(model.approximateSecondsBeforeTimedOut);
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobExecutionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Boolean getForceCanceled() {
            return forceCanceled;
        }

        @Override
        public final Builder forceCanceled(Boolean forceCanceled) {
            this.forceCanceled = forceCanceled;
            return this;
        }

        public final void setForceCanceled(Boolean forceCanceled) {
            this.forceCanceled = forceCanceled;
        }

        public final JobExecutionStatusDetails.Builder getStatusDetails() {
            return statusDetails != null ? statusDetails.toBuilder() : null;
        }

        @Override
        public final Builder statusDetails(JobExecutionStatusDetails statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final void setStatusDetails(JobExecutionStatusDetails.BuilderImpl statusDetails) {
            this.statusDetails = statusDetails != null ? statusDetails.build() : null;
        }

        public final String getThingArn() {
            return thingArn;
        }

        @Override
        public final Builder thingArn(String thingArn) {
            this.thingArn = thingArn;
            return this;
        }

        public final void setThingArn(String thingArn) {
            this.thingArn = thingArn;
        }

        public final Instant getQueuedAt() {
            return queuedAt;
        }

        @Override
        public final Builder queuedAt(Instant queuedAt) {
            this.queuedAt = queuedAt;
            return this;
        }

        public final void setQueuedAt(Instant queuedAt) {
            this.queuedAt = queuedAt;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public final Long getExecutionNumber() {
            return executionNumber;
        }

        @Override
        public final Builder executionNumber(Long executionNumber) {
            this.executionNumber = executionNumber;
            return this;
        }

        public final void setExecutionNumber(Long executionNumber) {
            this.executionNumber = executionNumber;
        }

        public final Long getVersionNumber() {
            return versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public final Long getApproximateSecondsBeforeTimedOut() {
            return approximateSecondsBeforeTimedOut;
        }

        @Override
        public final Builder approximateSecondsBeforeTimedOut(Long approximateSecondsBeforeTimedOut) {
            this.approximateSecondsBeforeTimedOut = approximateSecondsBeforeTimedOut;
            return this;
        }

        public final void setApproximateSecondsBeforeTimedOut(Long approximateSecondsBeforeTimedOut) {
            this.approximateSecondsBeforeTimedOut = approximateSecondsBeforeTimedOut;
        }

        @Override
        public JobExecution build() {
            return new JobExecution(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
