/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRoleAliasRequest extends IotRequest implements
        ToCopyableBuilder<CreateRoleAliasRequest.Builder, CreateRoleAliasRequest> {
    private static final SdkField<String> ROLE_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRoleAliasRequest::roleAlias)).setter(setter(Builder::roleAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("roleAlias").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRoleAliasRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<Integer> CREDENTIAL_DURATION_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).getter(getter(CreateRoleAliasRequest::credentialDurationSeconds))
            .setter(setter(Builder::credentialDurationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialDurationSeconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ALIAS_FIELD,
            ROLE_ARN_FIELD, CREDENTIAL_DURATION_SECONDS_FIELD));

    private final String roleAlias;

    private final String roleArn;

    private final Integer credentialDurationSeconds;

    private CreateRoleAliasRequest(BuilderImpl builder) {
        super(builder);
        this.roleAlias = builder.roleAlias;
        this.roleArn = builder.roleArn;
        this.credentialDurationSeconds = builder.credentialDurationSeconds;
    }

    /**
     * <p>
     * The role alias that points to a role ARN. This allows you to change the role without having to update the device.
     * </p>
     * 
     * @return The role alias that points to a role ARN. This allows you to change the role without having to update the
     *         device.
     */
    public String roleAlias() {
        return roleAlias;
    }

    /**
     * <p>
     * The role ARN.
     * </p>
     * 
     * @return The role ARN.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * How long (in seconds) the credentials will be valid.
     * </p>
     * 
     * @return How long (in seconds) the credentials will be valid.
     */
    public Integer credentialDurationSeconds() {
        return credentialDurationSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleAlias());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(credentialDurationSeconds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRoleAliasRequest)) {
            return false;
        }
        CreateRoleAliasRequest other = (CreateRoleAliasRequest) obj;
        return Objects.equals(roleAlias(), other.roleAlias()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(credentialDurationSeconds(), other.credentialDurationSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateRoleAliasRequest").add("RoleAlias", roleAlias()).add("RoleArn", roleArn())
                .add("CredentialDurationSeconds", credentialDurationSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleAlias":
            return Optional.ofNullable(clazz.cast(roleAlias()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "credentialDurationSeconds":
            return Optional.ofNullable(clazz.cast(credentialDurationSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRoleAliasRequest, T> g) {
        return obj -> g.apply((CreateRoleAliasRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateRoleAliasRequest> {
        /**
         * <p>
         * The role alias that points to a role ARN. This allows you to change the role without having to update the
         * device.
         * </p>
         * 
         * @param roleAlias
         *        The role alias that points to a role ARN. This allows you to change the role without having to update
         *        the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleAlias(String roleAlias);

        /**
         * <p>
         * The role ARN.
         * </p>
         * 
         * @param roleArn
         *        The role ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * How long (in seconds) the credentials will be valid.
         * </p>
         * 
         * @param credentialDurationSeconds
         *        How long (in seconds) the credentials will be valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialDurationSeconds(Integer credentialDurationSeconds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String roleAlias;

        private String roleArn;

        private Integer credentialDurationSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRoleAliasRequest model) {
            super(model);
            roleAlias(model.roleAlias);
            roleArn(model.roleArn);
            credentialDurationSeconds(model.credentialDurationSeconds);
        }

        public final String getRoleAlias() {
            return roleAlias;
        }

        @Override
        public final Builder roleAlias(String roleAlias) {
            this.roleAlias = roleAlias;
            return this;
        }

        public final void setRoleAlias(String roleAlias) {
            this.roleAlias = roleAlias;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Integer getCredentialDurationSeconds() {
            return credentialDurationSeconds;
        }

        @Override
        public final Builder credentialDurationSeconds(Integer credentialDurationSeconds) {
            this.credentialDurationSeconds = credentialDurationSeconds;
            return this;
        }

        public final void setCredentialDurationSeconds(Integer credentialDurationSeconds) {
            this.credentialDurationSeconds = credentialDurationSeconds;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRoleAliasRequest build() {
            return new CreateRoleAliasRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
