/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestInvokeAuthorizerRequest
extends IotRequest
implements ToCopyableBuilder<Builder, TestInvokeAuthorizerRequest> {
    private static final SdkField<String> AUTHORIZER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TestInvokeAuthorizerRequest.getter(TestInvokeAuthorizerRequest::authorizerName)).setter(TestInvokeAuthorizerRequest.setter(Builder::authorizerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("authorizerName").build()}).build();
    private static final SdkField<String> TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TestInvokeAuthorizerRequest.getter(TestInvokeAuthorizerRequest::token)).setter(TestInvokeAuthorizerRequest.setter(Builder::token)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("token").build()}).build();
    private static final SdkField<String> TOKEN_SIGNATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TestInvokeAuthorizerRequest.getter(TestInvokeAuthorizerRequest::tokenSignature)).setter(TestInvokeAuthorizerRequest.setter(Builder::tokenSignature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenSignature").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZER_NAME_FIELD, TOKEN_FIELD, TOKEN_SIGNATURE_FIELD));
    private final String authorizerName;
    private final String token;
    private final String tokenSignature;

    private TestInvokeAuthorizerRequest(BuilderImpl builder) {
        super(builder);
        this.authorizerName = builder.authorizerName;
        this.token = builder.token;
        this.tokenSignature = builder.tokenSignature;
    }

    public String authorizerName() {
        return this.authorizerName;
    }

    public String token() {
        return this.token;
    }

    public String tokenSignature() {
        return this.tokenSignature;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.token());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenSignature());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestInvokeAuthorizerRequest)) {
            return false;
        }
        TestInvokeAuthorizerRequest other = (TestInvokeAuthorizerRequest)((Object)obj);
        return Objects.equals(this.authorizerName(), other.authorizerName()) && Objects.equals(this.token(), other.token()) && Objects.equals(this.tokenSignature(), other.tokenSignature());
    }

    public String toString() {
        return ToString.builder((String)"TestInvokeAuthorizerRequest").add("AuthorizerName", (Object)this.authorizerName()).add("Token", (Object)this.token()).add("TokenSignature", (Object)this.tokenSignature()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authorizerName": {
                return Optional.ofNullable(clazz.cast(this.authorizerName()));
            }
            case "token": {
                return Optional.ofNullable(clazz.cast(this.token()));
            }
            case "tokenSignature": {
                return Optional.ofNullable(clazz.cast(this.tokenSignature()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestInvokeAuthorizerRequest, T> g) {
        return obj -> g.apply((TestInvokeAuthorizerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String authorizerName;
        private String token;
        private String tokenSignature;

        private BuilderImpl() {
        }

        private BuilderImpl(TestInvokeAuthorizerRequest model) {
            super(model);
            this.authorizerName(model.authorizerName);
            this.token(model.token);
            this.tokenSignature(model.tokenSignature);
        }

        public final String getAuthorizerName() {
            return this.authorizerName;
        }

        @Override
        public final Builder authorizerName(String authorizerName) {
            this.authorizerName = authorizerName;
            return this;
        }

        public final void setAuthorizerName(String authorizerName) {
            this.authorizerName = authorizerName;
        }

        public final String getToken() {
            return this.token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        public final String getTokenSignature() {
            return this.tokenSignature;
        }

        @Override
        public final Builder tokenSignature(String tokenSignature) {
            this.tokenSignature = tokenSignature;
            return this;
        }

        public final void setTokenSignature(String tokenSignature) {
            this.tokenSignature = tokenSignature;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestInvokeAuthorizerRequest build() {
            return new TestInvokeAuthorizerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TestInvokeAuthorizerRequest> {
        public Builder authorizerName(String var1);

        public Builder token(String var1);

        public Builder tokenSignature(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

