/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Thing group properties.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThingGroupProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<ThingGroupProperties.Builder, ThingGroupProperties> {
    private static final SdkField<String> THING_GROUP_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ThingGroupProperties::thingGroupDescription)).setter(setter(Builder::thingGroupDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupDescription").build())
            .build();

    private static final SdkField<AttributePayload> ATTRIBUTE_PAYLOAD_FIELD = SdkField
            .<AttributePayload> builder(MarshallingType.SDK_POJO).getter(getter(ThingGroupProperties::attributePayload))
            .setter(setter(Builder::attributePayload)).constructor(AttributePayload::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributePayload").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_GROUP_DESCRIPTION_FIELD,
            ATTRIBUTE_PAYLOAD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String thingGroupDescription;

    private final AttributePayload attributePayload;

    private ThingGroupProperties(BuilderImpl builder) {
        this.thingGroupDescription = builder.thingGroupDescription;
        this.attributePayload = builder.attributePayload;
    }

    /**
     * <p>
     * The thing group description.
     * </p>
     * 
     * @return The thing group description.
     */
    public String thingGroupDescription() {
        return thingGroupDescription;
    }

    /**
     * <p>
     * The thing group attributes in JSON format.
     * </p>
     * 
     * @return The thing group attributes in JSON format.
     */
    public AttributePayload attributePayload() {
        return attributePayload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(attributePayload());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingGroupProperties)) {
            return false;
        }
        ThingGroupProperties other = (ThingGroupProperties) obj;
        return Objects.equals(thingGroupDescription(), other.thingGroupDescription())
                && Objects.equals(attributePayload(), other.attributePayload());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ThingGroupProperties").add("ThingGroupDescription", thingGroupDescription())
                .add("AttributePayload", attributePayload()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingGroupDescription":
            return Optional.ofNullable(clazz.cast(thingGroupDescription()));
        case "attributePayload":
            return Optional.ofNullable(clazz.cast(attributePayload()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThingGroupProperties, T> g) {
        return obj -> g.apply((ThingGroupProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThingGroupProperties> {
        /**
         * <p>
         * The thing group description.
         * </p>
         * 
         * @param thingGroupDescription
         *        The thing group description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupDescription(String thingGroupDescription);

        /**
         * <p>
         * The thing group attributes in JSON format.
         * </p>
         * 
         * @param attributePayload
         *        The thing group attributes in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributePayload(AttributePayload attributePayload);

        /**
         * <p>
         * The thing group attributes in JSON format.
         * </p>
         * This is a convenience that creates an instance of the {@link AttributePayload.Builder} avoiding the need to
         * create one manually via {@link AttributePayload#builder()}.
         *
         * When the {@link Consumer} completes, {@link AttributePayload.Builder#build()} is called immediately and its
         * result is passed to {@link #attributePayload(AttributePayload)}.
         * 
         * @param attributePayload
         *        a consumer that will call methods on {@link AttributePayload.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributePayload(AttributePayload)
         */
        default Builder attributePayload(Consumer<AttributePayload.Builder> attributePayload) {
            return attributePayload(AttributePayload.builder().applyMutation(attributePayload).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String thingGroupDescription;

        private AttributePayload attributePayload;

        private BuilderImpl() {
        }

        private BuilderImpl(ThingGroupProperties model) {
            thingGroupDescription(model.thingGroupDescription);
            attributePayload(model.attributePayload);
        }

        public final String getThingGroupDescription() {
            return thingGroupDescription;
        }

        @Override
        public final Builder thingGroupDescription(String thingGroupDescription) {
            this.thingGroupDescription = thingGroupDescription;
            return this;
        }

        public final void setThingGroupDescription(String thingGroupDescription) {
            this.thingGroupDescription = thingGroupDescription;
        }

        public final AttributePayload.Builder getAttributePayload() {
            return attributePayload != null ? attributePayload.toBuilder() : null;
        }

        @Override
        public final Builder attributePayload(AttributePayload attributePayload) {
            this.attributePayload = attributePayload;
            return this;
        }

        public final void setAttributePayload(AttributePayload.BuilderImpl attributePayload) {
            this.attributePayload = attributePayload != null ? attributePayload.build() : null;
        }

        @Override
        public ThingGroupProperties build() {
            return new ThingGroupProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
