/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Starts execution of a Step Functions state machine.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StepFunctionsAction implements SdkPojo, Serializable,
        ToCopyableBuilder<StepFunctionsAction.Builder, StepFunctionsAction> {
    private static final SdkField<String> EXECUTION_NAME_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StepFunctionsAction::executionNamePrefix)).setter(setter(Builder::executionNamePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionNamePrefix").build())
            .build();

    private static final SdkField<String> STATE_MACHINE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StepFunctionsAction::stateMachineName)).setter(setter(Builder::stateMachineName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineName").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StepFunctionsAction::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_NAME_PREFIX_FIELD,
            STATE_MACHINE_NAME_FIELD, ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String executionNamePrefix;

    private final String stateMachineName;

    private final String roleArn;

    private StepFunctionsAction(BuilderImpl builder) {
        this.executionNamePrefix = builder.executionNamePrefix;
        this.stateMachineName = builder.stateMachineName;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * (Optional) A name will be given to the state machine execution consisting of this prefix followed by a UUID. Step
     * Functions automatically creates a unique name for each state machine execution if one is not provided.
     * </p>
     * 
     * @return (Optional) A name will be given to the state machine execution consisting of this prefix followed by a
     *         UUID. Step Functions automatically creates a unique name for each state machine execution if one is not
     *         provided.
     */
    public String executionNamePrefix() {
        return executionNamePrefix;
    }

    /**
     * <p>
     * The name of the Step Functions state machine whose execution will be started.
     * </p>
     * 
     * @return The name of the Step Functions state machine whose execution will be started.
     */
    public String stateMachineName() {
        return stateMachineName;
    }

    /**
     * <p>
     * The ARN of the role that grants IoT permission to start execution of a state machine
     * ("Action":"states:StartExecution").
     * </p>
     * 
     * @return The ARN of the role that grants IoT permission to start execution of a state machine
     *         ("Action":"states:StartExecution").
     */
    public String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(executionNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(stateMachineName());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepFunctionsAction)) {
            return false;
        }
        StepFunctionsAction other = (StepFunctionsAction) obj;
        return Objects.equals(executionNamePrefix(), other.executionNamePrefix())
                && Objects.equals(stateMachineName(), other.stateMachineName()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StepFunctionsAction").add("ExecutionNamePrefix", executionNamePrefix())
                .add("StateMachineName", stateMachineName()).add("RoleArn", roleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "executionNamePrefix":
            return Optional.ofNullable(clazz.cast(executionNamePrefix()));
        case "stateMachineName":
            return Optional.ofNullable(clazz.cast(stateMachineName()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StepFunctionsAction, T> g) {
        return obj -> g.apply((StepFunctionsAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StepFunctionsAction> {
        /**
         * <p>
         * (Optional) A name will be given to the state machine execution consisting of this prefix followed by a UUID.
         * Step Functions automatically creates a unique name for each state machine execution if one is not provided.
         * </p>
         * 
         * @param executionNamePrefix
         *        (Optional) A name will be given to the state machine execution consisting of this prefix followed by a
         *        UUID. Step Functions automatically creates a unique name for each state machine execution if one is
         *        not provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionNamePrefix(String executionNamePrefix);

        /**
         * <p>
         * The name of the Step Functions state machine whose execution will be started.
         * </p>
         * 
         * @param stateMachineName
         *        The name of the Step Functions state machine whose execution will be started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateMachineName(String stateMachineName);

        /**
         * <p>
         * The ARN of the role that grants IoT permission to start execution of a state machine
         * ("Action":"states:StartExecution").
         * </p>
         * 
         * @param roleArn
         *        The ARN of the role that grants IoT permission to start execution of a state machine
         *        ("Action":"states:StartExecution").
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private String executionNamePrefix;

        private String stateMachineName;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(StepFunctionsAction model) {
            executionNamePrefix(model.executionNamePrefix);
            stateMachineName(model.stateMachineName);
            roleArn(model.roleArn);
        }

        public final String getExecutionNamePrefix() {
            return executionNamePrefix;
        }

        @Override
        public final Builder executionNamePrefix(String executionNamePrefix) {
            this.executionNamePrefix = executionNamePrefix;
            return this;
        }

        public final void setExecutionNamePrefix(String executionNamePrefix) {
            this.executionNamePrefix = executionNamePrefix;
        }

        public final String getStateMachineName() {
            return stateMachineName;
        }

        @Override
        public final Builder stateMachineName(String stateMachineName) {
            this.stateMachineName = stateMachineName;
            return this;
        }

        public final void setStateMachineName(String stateMachineName) {
            this.stateMachineName = stateMachineName;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public StepFunctionsAction build() {
            return new StepFunctionsAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
