/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.CloudwatchAlarmAction;
import software.amazon.awssdk.services.iot.model.CloudwatchMetricAction;
import software.amazon.awssdk.services.iot.model.DynamoDBAction;
import software.amazon.awssdk.services.iot.model.DynamoDBv2Action;
import software.amazon.awssdk.services.iot.model.ElasticsearchAction;
import software.amazon.awssdk.services.iot.model.FirehoseAction;
import software.amazon.awssdk.services.iot.model.IotAnalyticsAction;
import software.amazon.awssdk.services.iot.model.IotEventsAction;
import software.amazon.awssdk.services.iot.model.KinesisAction;
import software.amazon.awssdk.services.iot.model.LambdaAction;
import software.amazon.awssdk.services.iot.model.RepublishAction;
import software.amazon.awssdk.services.iot.model.S3Action;
import software.amazon.awssdk.services.iot.model.SalesforceAction;
import software.amazon.awssdk.services.iot.model.SnsAction;
import software.amazon.awssdk.services.iot.model.SqsAction;
import software.amazon.awssdk.services.iot.model.StepFunctionsAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Action
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Action> {
    private static final SdkField<DynamoDBAction> DYNAMO_DB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Action.getter(Action::dynamoDB)).setter(Action.setter(Builder::dynamoDB)).constructor(DynamoDBAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamoDB").build()}).build();
    private static final SdkField<DynamoDBv2Action> DYNAMO_DB_V2_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Action.getter(Action::dynamoDBv2)).setter(Action.setter(Builder::dynamoDBv2)).constructor(DynamoDBv2Action::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamoDBv2").build()}).build();
    private static final SdkField<LambdaAction> LAMBDA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Action.getter(Action::lambda)).setter(Action.setter(Builder::lambda)).constructor(LambdaAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambda").build()}).build();
    private static final SdkField<SnsAction> SNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Action.getter(Action::sns)).setter(Action.setter(Builder::sns)).constructor(SnsAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sns").build()}).build();
    private static final SdkField<SqsAction> SQS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Action.getter(Action::sqs)).setter(Action.setter(Builder::sqs)).constructor(SqsAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sqs").build()}).build();
    private static final SdkField<KinesisAction> KINESIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Action.getter(Action::kinesis)).setter(Action.setter(Builder::kinesis)).constructor(KinesisAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kinesis").build()}).build();
    private static final SdkField<RepublishAction> REPUBLISH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Action.getter(Action::republish)).setter(Action.setter(Builder::republish)).constructor(RepublishAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("republish").build()}).build();
    private static final SdkField<S3Action> S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Action.getter(Action::s3)).setter(Action.setter(Builder::s3)).constructor(S3Action::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3").build()}).build();
    private static final SdkField<FirehoseAction> FIREHOSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Action.getter(Action::firehose)).setter(Action.setter(Builder::firehose)).constructor(FirehoseAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firehose").build()}).build();
    private static final SdkField<CloudwatchMetricAction> CLOUDWATCH_METRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Action.getter(Action::cloudwatchMetric)).setter(Action.setter(Builder::cloudwatchMetric)).constructor(CloudwatchMetricAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudwatchMetric").build()}).build();
    private static final SdkField<CloudwatchAlarmAction> CLOUDWATCH_ALARM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Action.getter(Action::cloudwatchAlarm)).setter(Action.setter(Builder::cloudwatchAlarm)).constructor(CloudwatchAlarmAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudwatchAlarm").build()}).build();
    private static final SdkField<ElasticsearchAction> ELASTICSEARCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Action.getter(Action::elasticsearch)).setter(Action.setter(Builder::elasticsearch)).constructor(ElasticsearchAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elasticsearch").build()}).build();
    private static final SdkField<SalesforceAction> SALESFORCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Action.getter(Action::salesforce)).setter(Action.setter(Builder::salesforce)).constructor(SalesforceAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("salesforce").build()}).build();
    private static final SdkField<IotAnalyticsAction> IOT_ANALYTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Action.getter(Action::iotAnalytics)).setter(Action.setter(Builder::iotAnalytics)).constructor(IotAnalyticsAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotAnalytics").build()}).build();
    private static final SdkField<IotEventsAction> IOT_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Action.getter(Action::iotEvents)).setter(Action.setter(Builder::iotEvents)).constructor(IotEventsAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotEvents").build()}).build();
    private static final SdkField<StepFunctionsAction> STEP_FUNCTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Action.getter(Action::stepFunctions)).setter(Action.setter(Builder::stepFunctions)).constructor(StepFunctionsAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepFunctions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DYNAMO_DB_FIELD, DYNAMO_DB_V2_FIELD, LAMBDA_FIELD, SNS_FIELD, SQS_FIELD, KINESIS_FIELD, REPUBLISH_FIELD, S3_FIELD, FIREHOSE_FIELD, CLOUDWATCH_METRIC_FIELD, CLOUDWATCH_ALARM_FIELD, ELASTICSEARCH_FIELD, SALESFORCE_FIELD, IOT_ANALYTICS_FIELD, IOT_EVENTS_FIELD, STEP_FUNCTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final DynamoDBAction dynamoDB;
    private final DynamoDBv2Action dynamoDBv2;
    private final LambdaAction lambda;
    private final SnsAction sns;
    private final SqsAction sqs;
    private final KinesisAction kinesis;
    private final RepublishAction republish;
    private final S3Action s3;
    private final FirehoseAction firehose;
    private final CloudwatchMetricAction cloudwatchMetric;
    private final CloudwatchAlarmAction cloudwatchAlarm;
    private final ElasticsearchAction elasticsearch;
    private final SalesforceAction salesforce;
    private final IotAnalyticsAction iotAnalytics;
    private final IotEventsAction iotEvents;
    private final StepFunctionsAction stepFunctions;

    private Action(BuilderImpl builder) {
        this.dynamoDB = builder.dynamoDB;
        this.dynamoDBv2 = builder.dynamoDBv2;
        this.lambda = builder.lambda;
        this.sns = builder.sns;
        this.sqs = builder.sqs;
        this.kinesis = builder.kinesis;
        this.republish = builder.republish;
        this.s3 = builder.s3;
        this.firehose = builder.firehose;
        this.cloudwatchMetric = builder.cloudwatchMetric;
        this.cloudwatchAlarm = builder.cloudwatchAlarm;
        this.elasticsearch = builder.elasticsearch;
        this.salesforce = builder.salesforce;
        this.iotAnalytics = builder.iotAnalytics;
        this.iotEvents = builder.iotEvents;
        this.stepFunctions = builder.stepFunctions;
    }

    public DynamoDBAction dynamoDB() {
        return this.dynamoDB;
    }

    public DynamoDBv2Action dynamoDBv2() {
        return this.dynamoDBv2;
    }

    public LambdaAction lambda() {
        return this.lambda;
    }

    public SnsAction sns() {
        return this.sns;
    }

    public SqsAction sqs() {
        return this.sqs;
    }

    public KinesisAction kinesis() {
        return this.kinesis;
    }

    public RepublishAction republish() {
        return this.republish;
    }

    public S3Action s3() {
        return this.s3;
    }

    public FirehoseAction firehose() {
        return this.firehose;
    }

    public CloudwatchMetricAction cloudwatchMetric() {
        return this.cloudwatchMetric;
    }

    public CloudwatchAlarmAction cloudwatchAlarm() {
        return this.cloudwatchAlarm;
    }

    public ElasticsearchAction elasticsearch() {
        return this.elasticsearch;
    }

    public SalesforceAction salesforce() {
        return this.salesforce;
    }

    public IotAnalyticsAction iotAnalytics() {
        return this.iotAnalytics;
    }

    public IotEventsAction iotEvents() {
        return this.iotEvents;
    }

    public StepFunctionsAction stepFunctions() {
        return this.stepFunctions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamoDB());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamoDBv2());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambda());
        hashCode = 31 * hashCode + Objects.hashCode(this.sns());
        hashCode = 31 * hashCode + Objects.hashCode(this.sqs());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesis());
        hashCode = 31 * hashCode + Objects.hashCode(this.republish());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3());
        hashCode = 31 * hashCode + Objects.hashCode(this.firehose());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudwatchMetric());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudwatchAlarm());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticsearch());
        hashCode = 31 * hashCode + Objects.hashCode(this.salesforce());
        hashCode = 31 * hashCode + Objects.hashCode(this.iotAnalytics());
        hashCode = 31 * hashCode + Objects.hashCode(this.iotEvents());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepFunctions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Action)) {
            return false;
        }
        Action other = (Action)obj;
        return Objects.equals(this.dynamoDB(), other.dynamoDB()) && Objects.equals(this.dynamoDBv2(), other.dynamoDBv2()) && Objects.equals(this.lambda(), other.lambda()) && Objects.equals(this.sns(), other.sns()) && Objects.equals(this.sqs(), other.sqs()) && Objects.equals(this.kinesis(), other.kinesis()) && Objects.equals(this.republish(), other.republish()) && Objects.equals(this.s3(), other.s3()) && Objects.equals(this.firehose(), other.firehose()) && Objects.equals(this.cloudwatchMetric(), other.cloudwatchMetric()) && Objects.equals(this.cloudwatchAlarm(), other.cloudwatchAlarm()) && Objects.equals(this.elasticsearch(), other.elasticsearch()) && Objects.equals(this.salesforce(), other.salesforce()) && Objects.equals(this.iotAnalytics(), other.iotAnalytics()) && Objects.equals(this.iotEvents(), other.iotEvents()) && Objects.equals(this.stepFunctions(), other.stepFunctions());
    }

    public String toString() {
        return ToString.builder((String)"Action").add("DynamoDB", (Object)this.dynamoDB()).add("DynamoDBv2", (Object)this.dynamoDBv2()).add("Lambda", (Object)this.lambda()).add("Sns", (Object)this.sns()).add("Sqs", (Object)this.sqs()).add("Kinesis", (Object)this.kinesis()).add("Republish", (Object)this.republish()).add("S3", (Object)this.s3()).add("Firehose", (Object)this.firehose()).add("CloudwatchMetric", (Object)this.cloudwatchMetric()).add("CloudwatchAlarm", (Object)this.cloudwatchAlarm()).add("Elasticsearch", (Object)this.elasticsearch()).add("Salesforce", (Object)this.salesforce()).add("IotAnalytics", (Object)this.iotAnalytics()).add("IotEvents", (Object)this.iotEvents()).add("StepFunctions", (Object)this.stepFunctions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dynamoDB": {
                return Optional.ofNullable(clazz.cast(this.dynamoDB()));
            }
            case "dynamoDBv2": {
                return Optional.ofNullable(clazz.cast(this.dynamoDBv2()));
            }
            case "lambda": {
                return Optional.ofNullable(clazz.cast(this.lambda()));
            }
            case "sns": {
                return Optional.ofNullable(clazz.cast(this.sns()));
            }
            case "sqs": {
                return Optional.ofNullable(clazz.cast(this.sqs()));
            }
            case "kinesis": {
                return Optional.ofNullable(clazz.cast(this.kinesis()));
            }
            case "republish": {
                return Optional.ofNullable(clazz.cast(this.republish()));
            }
            case "s3": {
                return Optional.ofNullable(clazz.cast(this.s3()));
            }
            case "firehose": {
                return Optional.ofNullable(clazz.cast(this.firehose()));
            }
            case "cloudwatchMetric": {
                return Optional.ofNullable(clazz.cast(this.cloudwatchMetric()));
            }
            case "cloudwatchAlarm": {
                return Optional.ofNullable(clazz.cast(this.cloudwatchAlarm()));
            }
            case "elasticsearch": {
                return Optional.ofNullable(clazz.cast(this.elasticsearch()));
            }
            case "salesforce": {
                return Optional.ofNullable(clazz.cast(this.salesforce()));
            }
            case "iotAnalytics": {
                return Optional.ofNullable(clazz.cast(this.iotAnalytics()));
            }
            case "iotEvents": {
                return Optional.ofNullable(clazz.cast(this.iotEvents()));
            }
            case "stepFunctions": {
                return Optional.ofNullable(clazz.cast(this.stepFunctions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Action, T> g) {
        return obj -> g.apply((Action)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DynamoDBAction dynamoDB;
        private DynamoDBv2Action dynamoDBv2;
        private LambdaAction lambda;
        private SnsAction sns;
        private SqsAction sqs;
        private KinesisAction kinesis;
        private RepublishAction republish;
        private S3Action s3;
        private FirehoseAction firehose;
        private CloudwatchMetricAction cloudwatchMetric;
        private CloudwatchAlarmAction cloudwatchAlarm;
        private ElasticsearchAction elasticsearch;
        private SalesforceAction salesforce;
        private IotAnalyticsAction iotAnalytics;
        private IotEventsAction iotEvents;
        private StepFunctionsAction stepFunctions;

        private BuilderImpl() {
        }

        private BuilderImpl(Action model) {
            this.dynamoDB(model.dynamoDB);
            this.dynamoDBv2(model.dynamoDBv2);
            this.lambda(model.lambda);
            this.sns(model.sns);
            this.sqs(model.sqs);
            this.kinesis(model.kinesis);
            this.republish(model.republish);
            this.s3(model.s3);
            this.firehose(model.firehose);
            this.cloudwatchMetric(model.cloudwatchMetric);
            this.cloudwatchAlarm(model.cloudwatchAlarm);
            this.elasticsearch(model.elasticsearch);
            this.salesforce(model.salesforce);
            this.iotAnalytics(model.iotAnalytics);
            this.iotEvents(model.iotEvents);
            this.stepFunctions(model.stepFunctions);
        }

        public final DynamoDBAction.Builder getDynamoDB() {
            return this.dynamoDB != null ? this.dynamoDB.toBuilder() : null;
        }

        @Override
        public final Builder dynamoDB(DynamoDBAction dynamoDB) {
            this.dynamoDB = dynamoDB;
            return this;
        }

        public final void setDynamoDB(DynamoDBAction.BuilderImpl dynamoDB) {
            this.dynamoDB = dynamoDB != null ? dynamoDB.build() : null;
        }

        public final DynamoDBv2Action.Builder getDynamoDBv2() {
            return this.dynamoDBv2 != null ? this.dynamoDBv2.toBuilder() : null;
        }

        @Override
        public final Builder dynamoDBv2(DynamoDBv2Action dynamoDBv2) {
            this.dynamoDBv2 = dynamoDBv2;
            return this;
        }

        public final void setDynamoDBv2(DynamoDBv2Action.BuilderImpl dynamoDBv2) {
            this.dynamoDBv2 = dynamoDBv2 != null ? dynamoDBv2.build() : null;
        }

        public final LambdaAction.Builder getLambda() {
            return this.lambda != null ? this.lambda.toBuilder() : null;
        }

        @Override
        public final Builder lambda(LambdaAction lambda) {
            this.lambda = lambda;
            return this;
        }

        public final void setLambda(LambdaAction.BuilderImpl lambda) {
            this.lambda = lambda != null ? lambda.build() : null;
        }

        public final SnsAction.Builder getSns() {
            return this.sns != null ? this.sns.toBuilder() : null;
        }

        @Override
        public final Builder sns(SnsAction sns) {
            this.sns = sns;
            return this;
        }

        public final void setSns(SnsAction.BuilderImpl sns) {
            this.sns = sns != null ? sns.build() : null;
        }

        public final SqsAction.Builder getSqs() {
            return this.sqs != null ? this.sqs.toBuilder() : null;
        }

        @Override
        public final Builder sqs(SqsAction sqs) {
            this.sqs = sqs;
            return this;
        }

        public final void setSqs(SqsAction.BuilderImpl sqs) {
            this.sqs = sqs != null ? sqs.build() : null;
        }

        public final KinesisAction.Builder getKinesis() {
            return this.kinesis != null ? this.kinesis.toBuilder() : null;
        }

        @Override
        public final Builder kinesis(KinesisAction kinesis) {
            this.kinesis = kinesis;
            return this;
        }

        public final void setKinesis(KinesisAction.BuilderImpl kinesis) {
            this.kinesis = kinesis != null ? kinesis.build() : null;
        }

        public final RepublishAction.Builder getRepublish() {
            return this.republish != null ? this.republish.toBuilder() : null;
        }

        @Override
        public final Builder republish(RepublishAction republish) {
            this.republish = republish;
            return this;
        }

        public final void setRepublish(RepublishAction.BuilderImpl republish) {
            this.republish = republish != null ? republish.build() : null;
        }

        public final S3Action.Builder getS3() {
            return this.s3 != null ? this.s3.toBuilder() : null;
        }

        @Override
        public final Builder s3(S3Action s3) {
            this.s3 = s3;
            return this;
        }

        public final void setS3(S3Action.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        public final FirehoseAction.Builder getFirehose() {
            return this.firehose != null ? this.firehose.toBuilder() : null;
        }

        @Override
        public final Builder firehose(FirehoseAction firehose) {
            this.firehose = firehose;
            return this;
        }

        public final void setFirehose(FirehoseAction.BuilderImpl firehose) {
            this.firehose = firehose != null ? firehose.build() : null;
        }

        public final CloudwatchMetricAction.Builder getCloudwatchMetric() {
            return this.cloudwatchMetric != null ? this.cloudwatchMetric.toBuilder() : null;
        }

        @Override
        public final Builder cloudwatchMetric(CloudwatchMetricAction cloudwatchMetric) {
            this.cloudwatchMetric = cloudwatchMetric;
            return this;
        }

        public final void setCloudwatchMetric(CloudwatchMetricAction.BuilderImpl cloudwatchMetric) {
            this.cloudwatchMetric = cloudwatchMetric != null ? cloudwatchMetric.build() : null;
        }

        public final CloudwatchAlarmAction.Builder getCloudwatchAlarm() {
            return this.cloudwatchAlarm != null ? this.cloudwatchAlarm.toBuilder() : null;
        }

        @Override
        public final Builder cloudwatchAlarm(CloudwatchAlarmAction cloudwatchAlarm) {
            this.cloudwatchAlarm = cloudwatchAlarm;
            return this;
        }

        public final void setCloudwatchAlarm(CloudwatchAlarmAction.BuilderImpl cloudwatchAlarm) {
            this.cloudwatchAlarm = cloudwatchAlarm != null ? cloudwatchAlarm.build() : null;
        }

        public final ElasticsearchAction.Builder getElasticsearch() {
            return this.elasticsearch != null ? this.elasticsearch.toBuilder() : null;
        }

        @Override
        public final Builder elasticsearch(ElasticsearchAction elasticsearch) {
            this.elasticsearch = elasticsearch;
            return this;
        }

        public final void setElasticsearch(ElasticsearchAction.BuilderImpl elasticsearch) {
            this.elasticsearch = elasticsearch != null ? elasticsearch.build() : null;
        }

        public final SalesforceAction.Builder getSalesforce() {
            return this.salesforce != null ? this.salesforce.toBuilder() : null;
        }

        @Override
        public final Builder salesforce(SalesforceAction salesforce) {
            this.salesforce = salesforce;
            return this;
        }

        public final void setSalesforce(SalesforceAction.BuilderImpl salesforce) {
            this.salesforce = salesforce != null ? salesforce.build() : null;
        }

        public final IotAnalyticsAction.Builder getIotAnalytics() {
            return this.iotAnalytics != null ? this.iotAnalytics.toBuilder() : null;
        }

        @Override
        public final Builder iotAnalytics(IotAnalyticsAction iotAnalytics) {
            this.iotAnalytics = iotAnalytics;
            return this;
        }

        public final void setIotAnalytics(IotAnalyticsAction.BuilderImpl iotAnalytics) {
            this.iotAnalytics = iotAnalytics != null ? iotAnalytics.build() : null;
        }

        public final IotEventsAction.Builder getIotEvents() {
            return this.iotEvents != null ? this.iotEvents.toBuilder() : null;
        }

        @Override
        public final Builder iotEvents(IotEventsAction iotEvents) {
            this.iotEvents = iotEvents;
            return this;
        }

        public final void setIotEvents(IotEventsAction.BuilderImpl iotEvents) {
            this.iotEvents = iotEvents != null ? iotEvents.build() : null;
        }

        public final StepFunctionsAction.Builder getStepFunctions() {
            return this.stepFunctions != null ? this.stepFunctions.toBuilder() : null;
        }

        @Override
        public final Builder stepFunctions(StepFunctionsAction stepFunctions) {
            this.stepFunctions = stepFunctions;
            return this;
        }

        public final void setStepFunctions(StepFunctionsAction.BuilderImpl stepFunctions) {
            this.stepFunctions = stepFunctions != null ? stepFunctions.build() : null;
        }

        public Action build() {
            return new Action(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Action> {
        public Builder dynamoDB(DynamoDBAction var1);

        default public Builder dynamoDB(Consumer<DynamoDBAction.Builder> dynamoDB) {
            return this.dynamoDB((DynamoDBAction)((DynamoDBAction.Builder)DynamoDBAction.builder().applyMutation(dynamoDB)).build());
        }

        public Builder dynamoDBv2(DynamoDBv2Action var1);

        default public Builder dynamoDBv2(Consumer<DynamoDBv2Action.Builder> dynamoDBv2) {
            return this.dynamoDBv2((DynamoDBv2Action)((DynamoDBv2Action.Builder)DynamoDBv2Action.builder().applyMutation(dynamoDBv2)).build());
        }

        public Builder lambda(LambdaAction var1);

        default public Builder lambda(Consumer<LambdaAction.Builder> lambda) {
            return this.lambda((LambdaAction)((LambdaAction.Builder)LambdaAction.builder().applyMutation(lambda)).build());
        }

        public Builder sns(SnsAction var1);

        default public Builder sns(Consumer<SnsAction.Builder> sns) {
            return this.sns((SnsAction)((SnsAction.Builder)SnsAction.builder().applyMutation(sns)).build());
        }

        public Builder sqs(SqsAction var1);

        default public Builder sqs(Consumer<SqsAction.Builder> sqs) {
            return this.sqs((SqsAction)((SqsAction.Builder)SqsAction.builder().applyMutation(sqs)).build());
        }

        public Builder kinesis(KinesisAction var1);

        default public Builder kinesis(Consumer<KinesisAction.Builder> kinesis) {
            return this.kinesis((KinesisAction)((KinesisAction.Builder)KinesisAction.builder().applyMutation(kinesis)).build());
        }

        public Builder republish(RepublishAction var1);

        default public Builder republish(Consumer<RepublishAction.Builder> republish) {
            return this.republish((RepublishAction)((RepublishAction.Builder)RepublishAction.builder().applyMutation(republish)).build());
        }

        public Builder s3(S3Action var1);

        default public Builder s3(Consumer<S3Action.Builder> s3) {
            return this.s3((S3Action)((S3Action.Builder)S3Action.builder().applyMutation(s3)).build());
        }

        public Builder firehose(FirehoseAction var1);

        default public Builder firehose(Consumer<FirehoseAction.Builder> firehose) {
            return this.firehose((FirehoseAction)((FirehoseAction.Builder)FirehoseAction.builder().applyMutation(firehose)).build());
        }

        public Builder cloudwatchMetric(CloudwatchMetricAction var1);

        default public Builder cloudwatchMetric(Consumer<CloudwatchMetricAction.Builder> cloudwatchMetric) {
            return this.cloudwatchMetric((CloudwatchMetricAction)((CloudwatchMetricAction.Builder)CloudwatchMetricAction.builder().applyMutation(cloudwatchMetric)).build());
        }

        public Builder cloudwatchAlarm(CloudwatchAlarmAction var1);

        default public Builder cloudwatchAlarm(Consumer<CloudwatchAlarmAction.Builder> cloudwatchAlarm) {
            return this.cloudwatchAlarm((CloudwatchAlarmAction)((CloudwatchAlarmAction.Builder)CloudwatchAlarmAction.builder().applyMutation(cloudwatchAlarm)).build());
        }

        public Builder elasticsearch(ElasticsearchAction var1);

        default public Builder elasticsearch(Consumer<ElasticsearchAction.Builder> elasticsearch) {
            return this.elasticsearch((ElasticsearchAction)((ElasticsearchAction.Builder)ElasticsearchAction.builder().applyMutation(elasticsearch)).build());
        }

        public Builder salesforce(SalesforceAction var1);

        default public Builder salesforce(Consumer<SalesforceAction.Builder> salesforce) {
            return this.salesforce((SalesforceAction)((SalesforceAction.Builder)SalesforceAction.builder().applyMutation(salesforce)).build());
        }

        public Builder iotAnalytics(IotAnalyticsAction var1);

        default public Builder iotAnalytics(Consumer<IotAnalyticsAction.Builder> iotAnalytics) {
            return this.iotAnalytics((IotAnalyticsAction)((IotAnalyticsAction.Builder)IotAnalyticsAction.builder().applyMutation(iotAnalytics)).build());
        }

        public Builder iotEvents(IotEventsAction var1);

        default public Builder iotEvents(Consumer<IotEventsAction.Builder> iotEvents) {
            return this.iotEvents((IotEventsAction)((IotEventsAction.Builder)IotEventsAction.builder().applyMutation(iotEvents)).build());
        }

        public Builder stepFunctions(StepFunctionsAction var1);

        default public Builder stepFunctions(Consumer<StepFunctionsAction.Builder> stepFunctions) {
            return this.stepFunctions((StepFunctionsAction)((StepFunctionsAction.Builder)StepFunctionsAction.builder().applyMutation(stepFunctions)).build());
        }
    }
}

