/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRoleAliasResponse extends IotResponse implements
        ToCopyableBuilder<UpdateRoleAliasResponse.Builder, UpdateRoleAliasResponse> {
    private static final SdkField<String> ROLE_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateRoleAliasResponse::roleAlias)).setter(setter(Builder::roleAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleAlias").build()).build();

    private static final SdkField<String> ROLE_ALIAS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateRoleAliasResponse::roleAliasArn)).setter(setter(Builder::roleAliasArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleAliasArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ALIAS_FIELD,
            ROLE_ALIAS_ARN_FIELD));

    private final String roleAlias;

    private final String roleAliasArn;

    private UpdateRoleAliasResponse(BuilderImpl builder) {
        super(builder);
        this.roleAlias = builder.roleAlias;
        this.roleAliasArn = builder.roleAliasArn;
    }

    /**
     * <p>
     * The role alias.
     * </p>
     * 
     * @return The role alias.
     */
    public String roleAlias() {
        return roleAlias;
    }

    /**
     * <p>
     * The role alias ARN.
     * </p>
     * 
     * @return The role alias ARN.
     */
    public String roleAliasArn() {
        return roleAliasArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleAlias());
        hashCode = 31 * hashCode + Objects.hashCode(roleAliasArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRoleAliasResponse)) {
            return false;
        }
        UpdateRoleAliasResponse other = (UpdateRoleAliasResponse) obj;
        return Objects.equals(roleAlias(), other.roleAlias()) && Objects.equals(roleAliasArn(), other.roleAliasArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateRoleAliasResponse").add("RoleAlias", roleAlias()).add("RoleAliasArn", roleAliasArn())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleAlias":
            return Optional.ofNullable(clazz.cast(roleAlias()));
        case "roleAliasArn":
            return Optional.ofNullable(clazz.cast(roleAliasArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRoleAliasResponse, T> g) {
        return obj -> g.apply((UpdateRoleAliasResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateRoleAliasResponse> {
        /**
         * <p>
         * The role alias.
         * </p>
         * 
         * @param roleAlias
         *        The role alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleAlias(String roleAlias);

        /**
         * <p>
         * The role alias ARN.
         * </p>
         * 
         * @param roleAliasArn
         *        The role alias ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleAliasArn(String roleAliasArn);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String roleAlias;

        private String roleAliasArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRoleAliasResponse model) {
            super(model);
            roleAlias(model.roleAlias);
            roleAliasArn(model.roleAliasArn);
        }

        public final String getRoleAlias() {
            return roleAlias;
        }

        @Override
        public final Builder roleAlias(String roleAlias) {
            this.roleAlias = roleAlias;
            return this;
        }

        public final void setRoleAlias(String roleAlias) {
            this.roleAlias = roleAlias;
        }

        public final String getRoleAliasArn() {
            return roleAliasArn;
        }

        @Override
        public final Builder roleAliasArn(String roleAliasArn) {
            this.roleAliasArn = roleAliasArn;
            return this;
        }

        public final void setRoleAliasArn(String roleAliasArn) {
            this.roleAliasArn = roleAliasArn;
        }

        @Override
        public UpdateRoleAliasResponse build() {
            return new UpdateRoleAliasResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
