/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The thing indexing configuration. For more information, see <a
 * href="https://docs.aws.amazon.com/iot/latest/developerguide/managing-index.html">Managing Thing Indexing</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThingIndexingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ThingIndexingConfiguration.Builder, ThingIndexingConfiguration> {
    private static final SdkField<String> THING_INDEXING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ThingIndexingConfiguration::thingIndexingModeAsString)).setter(setter(Builder::thingIndexingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingIndexingMode").build()).build();

    private static final SdkField<String> THING_CONNECTIVITY_INDEXING_MODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ThingIndexingConfiguration::thingConnectivityIndexingModeAsString))
            .setter(setter(Builder::thingConnectivityIndexingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingConnectivityIndexingMode")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_INDEXING_MODE_FIELD,
            THING_CONNECTIVITY_INDEXING_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String thingIndexingMode;

    private final String thingConnectivityIndexingMode;

    private ThingIndexingConfiguration(BuilderImpl builder) {
        this.thingIndexingMode = builder.thingIndexingMode;
        this.thingConnectivityIndexingMode = builder.thingConnectivityIndexingMode;
    }

    /**
     * <p>
     * Thing indexing mode. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * REGISTRY – Your thing index contains registry data only.
     * </p>
     * </li>
     * <li>
     * <p>
     * REGISTRY_AND_SHADOW - Your thing index contains registry and shadow data.
     * </p>
     * </li>
     * <li>
     * <p>
     * OFF - Thing indexing is disabled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #thingIndexingMode}
     * will return {@link ThingIndexingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #thingIndexingModeAsString}.
     * </p>
     * 
     * @return Thing indexing mode. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         REGISTRY – Your thing index contains registry data only.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         REGISTRY_AND_SHADOW - Your thing index contains registry and shadow data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OFF - Thing indexing is disabled.
     *         </p>
     *         </li>
     * @see ThingIndexingMode
     */
    public ThingIndexingMode thingIndexingMode() {
        return ThingIndexingMode.fromValue(thingIndexingMode);
    }

    /**
     * <p>
     * Thing indexing mode. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * REGISTRY – Your thing index contains registry data only.
     * </p>
     * </li>
     * <li>
     * <p>
     * REGISTRY_AND_SHADOW - Your thing index contains registry and shadow data.
     * </p>
     * </li>
     * <li>
     * <p>
     * OFF - Thing indexing is disabled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #thingIndexingMode}
     * will return {@link ThingIndexingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #thingIndexingModeAsString}.
     * </p>
     * 
     * @return Thing indexing mode. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         REGISTRY – Your thing index contains registry data only.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         REGISTRY_AND_SHADOW - Your thing index contains registry and shadow data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OFF - Thing indexing is disabled.
     *         </p>
     *         </li>
     * @see ThingIndexingMode
     */
    public String thingIndexingModeAsString() {
        return thingIndexingMode;
    }

    /**
     * <p>
     * Thing connectivity indexing mode. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * STATUS – Your thing index contains connectivity status. To enable thing connectivity indexing, thingIndexMode
     * must not be set to OFF.
     * </p>
     * </li>
     * <li>
     * <p>
     * OFF - Thing connectivity status indexing is disabled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #thingConnectivityIndexingMode} will return {@link ThingConnectivityIndexingMode#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #thingConnectivityIndexingModeAsString}.
     * </p>
     * 
     * @return Thing connectivity indexing mode. Valid values are: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         STATUS – Your thing index contains connectivity status. To enable thing connectivity indexing,
     *         thingIndexMode must not be set to OFF.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OFF - Thing connectivity status indexing is disabled.
     *         </p>
     *         </li>
     * @see ThingConnectivityIndexingMode
     */
    public ThingConnectivityIndexingMode thingConnectivityIndexingMode() {
        return ThingConnectivityIndexingMode.fromValue(thingConnectivityIndexingMode);
    }

    /**
     * <p>
     * Thing connectivity indexing mode. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * STATUS – Your thing index contains connectivity status. To enable thing connectivity indexing, thingIndexMode
     * must not be set to OFF.
     * </p>
     * </li>
     * <li>
     * <p>
     * OFF - Thing connectivity status indexing is disabled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #thingConnectivityIndexingMode} will return {@link ThingConnectivityIndexingMode#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #thingConnectivityIndexingModeAsString}.
     * </p>
     * 
     * @return Thing connectivity indexing mode. Valid values are: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         STATUS – Your thing index contains connectivity status. To enable thing connectivity indexing,
     *         thingIndexMode must not be set to OFF.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OFF - Thing connectivity status indexing is disabled.
     *         </p>
     *         </li>
     * @see ThingConnectivityIndexingMode
     */
    public String thingConnectivityIndexingModeAsString() {
        return thingConnectivityIndexingMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thingIndexingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(thingConnectivityIndexingModeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingIndexingConfiguration)) {
            return false;
        }
        ThingIndexingConfiguration other = (ThingIndexingConfiguration) obj;
        return Objects.equals(thingIndexingModeAsString(), other.thingIndexingModeAsString())
                && Objects.equals(thingConnectivityIndexingModeAsString(), other.thingConnectivityIndexingModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ThingIndexingConfiguration").add("ThingIndexingMode", thingIndexingModeAsString())
                .add("ThingConnectivityIndexingMode", thingConnectivityIndexingModeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingIndexingMode":
            return Optional.ofNullable(clazz.cast(thingIndexingModeAsString()));
        case "thingConnectivityIndexingMode":
            return Optional.ofNullable(clazz.cast(thingConnectivityIndexingModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThingIndexingConfiguration, T> g) {
        return obj -> g.apply((ThingIndexingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThingIndexingConfiguration> {
        /**
         * <p>
         * Thing indexing mode. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * REGISTRY – Your thing index contains registry data only.
         * </p>
         * </li>
         * <li>
         * <p>
         * REGISTRY_AND_SHADOW - Your thing index contains registry and shadow data.
         * </p>
         * </li>
         * <li>
         * <p>
         * OFF - Thing indexing is disabled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param thingIndexingMode
         *        Thing indexing mode. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        REGISTRY – Your thing index contains registry data only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REGISTRY_AND_SHADOW - Your thing index contains registry and shadow data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OFF - Thing indexing is disabled.
         *        </p>
         *        </li>
         * @see ThingIndexingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThingIndexingMode
         */
        Builder thingIndexingMode(String thingIndexingMode);

        /**
         * <p>
         * Thing indexing mode. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * REGISTRY – Your thing index contains registry data only.
         * </p>
         * </li>
         * <li>
         * <p>
         * REGISTRY_AND_SHADOW - Your thing index contains registry and shadow data.
         * </p>
         * </li>
         * <li>
         * <p>
         * OFF - Thing indexing is disabled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param thingIndexingMode
         *        Thing indexing mode. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        REGISTRY – Your thing index contains registry data only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REGISTRY_AND_SHADOW - Your thing index contains registry and shadow data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OFF - Thing indexing is disabled.
         *        </p>
         *        </li>
         * @see ThingIndexingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThingIndexingMode
         */
        Builder thingIndexingMode(ThingIndexingMode thingIndexingMode);

        /**
         * <p>
         * Thing connectivity indexing mode. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * STATUS – Your thing index contains connectivity status. To enable thing connectivity indexing, thingIndexMode
         * must not be set to OFF.
         * </p>
         * </li>
         * <li>
         * <p>
         * OFF - Thing connectivity status indexing is disabled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param thingConnectivityIndexingMode
         *        Thing connectivity indexing mode. Valid values are: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        STATUS – Your thing index contains connectivity status. To enable thing connectivity indexing,
         *        thingIndexMode must not be set to OFF.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OFF - Thing connectivity status indexing is disabled.
         *        </p>
         *        </li>
         * @see ThingConnectivityIndexingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThingConnectivityIndexingMode
         */
        Builder thingConnectivityIndexingMode(String thingConnectivityIndexingMode);

        /**
         * <p>
         * Thing connectivity indexing mode. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * STATUS – Your thing index contains connectivity status. To enable thing connectivity indexing, thingIndexMode
         * must not be set to OFF.
         * </p>
         * </li>
         * <li>
         * <p>
         * OFF - Thing connectivity status indexing is disabled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param thingConnectivityIndexingMode
         *        Thing connectivity indexing mode. Valid values are: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        STATUS – Your thing index contains connectivity status. To enable thing connectivity indexing,
         *        thingIndexMode must not be set to OFF.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OFF - Thing connectivity status indexing is disabled.
         *        </p>
         *        </li>
         * @see ThingConnectivityIndexingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThingConnectivityIndexingMode
         */
        Builder thingConnectivityIndexingMode(ThingConnectivityIndexingMode thingConnectivityIndexingMode);
    }

    static final class BuilderImpl implements Builder {
        private String thingIndexingMode;

        private String thingConnectivityIndexingMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ThingIndexingConfiguration model) {
            thingIndexingMode(model.thingIndexingMode);
            thingConnectivityIndexingMode(model.thingConnectivityIndexingMode);
        }

        public final String getThingIndexingModeAsString() {
            return thingIndexingMode;
        }

        @Override
        public final Builder thingIndexingMode(String thingIndexingMode) {
            this.thingIndexingMode = thingIndexingMode;
            return this;
        }

        @Override
        public final Builder thingIndexingMode(ThingIndexingMode thingIndexingMode) {
            this.thingIndexingMode(thingIndexingMode.toString());
            return this;
        }

        public final void setThingIndexingMode(String thingIndexingMode) {
            this.thingIndexingMode = thingIndexingMode;
        }

        public final String getThingConnectivityIndexingModeAsString() {
            return thingConnectivityIndexingMode;
        }

        @Override
        public final Builder thingConnectivityIndexingMode(String thingConnectivityIndexingMode) {
            this.thingConnectivityIndexingMode = thingConnectivityIndexingMode;
            return this;
        }

        @Override
        public final Builder thingConnectivityIndexingMode(ThingConnectivityIndexingMode thingConnectivityIndexingMode) {
            this.thingConnectivityIndexingMode(thingConnectivityIndexingMode.toString());
            return this;
        }

        public final void setThingConnectivityIndexingMode(String thingConnectivityIndexingMode) {
            this.thingConnectivityIndexingMode = thingConnectivityIndexingMode;
        }

        @Override
        public ThingIndexingConfiguration build() {
            return new ThingIndexingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
