/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the SetLoggingOptions operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetLoggingOptionsRequest extends IotRequest implements
        ToCopyableBuilder<SetLoggingOptionsRequest.Builder, SetLoggingOptionsRequest> {
    private static final SdkField<LoggingOptionsPayload> LOGGING_OPTIONS_PAYLOAD_FIELD = SdkField
            .<LoggingOptionsPayload> builder(MarshallingType.SDK_POJO)
            .getter(getter(SetLoggingOptionsRequest::loggingOptionsPayload))
            .setter(setter(Builder::loggingOptionsPayload))
            .constructor(LoggingOptionsPayload::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingOptionsPayload").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(LOGGING_OPTIONS_PAYLOAD_FIELD));

    private final LoggingOptionsPayload loggingOptionsPayload;

    private SetLoggingOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.loggingOptionsPayload = builder.loggingOptionsPayload;
    }

    /**
     * <p>
     * The logging options payload.
     * </p>
     * 
     * @return The logging options payload.
     */
    public LoggingOptionsPayload loggingOptionsPayload() {
        return loggingOptionsPayload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(loggingOptionsPayload());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetLoggingOptionsRequest)) {
            return false;
        }
        SetLoggingOptionsRequest other = (SetLoggingOptionsRequest) obj;
        return Objects.equals(loggingOptionsPayload(), other.loggingOptionsPayload());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SetLoggingOptionsRequest").add("LoggingOptionsPayload", loggingOptionsPayload()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "loggingOptionsPayload":
            return Optional.ofNullable(clazz.cast(loggingOptionsPayload()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetLoggingOptionsRequest, T> g) {
        return obj -> g.apply((SetLoggingOptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, SetLoggingOptionsRequest> {
        /**
         * <p>
         * The logging options payload.
         * </p>
         * 
         * @param loggingOptionsPayload
         *        The logging options payload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingOptionsPayload(LoggingOptionsPayload loggingOptionsPayload);

        /**
         * <p>
         * The logging options payload.
         * </p>
         * This is a convenience that creates an instance of the {@link LoggingOptionsPayload.Builder} avoiding the need
         * to create one manually via {@link LoggingOptionsPayload#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoggingOptionsPayload.Builder#build()} is called immediately and
         * its result is passed to {@link #loggingOptionsPayload(LoggingOptionsPayload)}.
         * 
         * @param loggingOptionsPayload
         *        a consumer that will call methods on {@link LoggingOptionsPayload.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingOptionsPayload(LoggingOptionsPayload)
         */
        default Builder loggingOptionsPayload(Consumer<LoggingOptionsPayload.Builder> loggingOptionsPayload) {
            return loggingOptionsPayload(LoggingOptionsPayload.builder().applyMutation(loggingOptionsPayload).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private LoggingOptionsPayload loggingOptionsPayload;

        private BuilderImpl() {
        }

        private BuilderImpl(SetLoggingOptionsRequest model) {
            super(model);
            loggingOptionsPayload(model.loggingOptionsPayload);
        }

        public final LoggingOptionsPayload.Builder getLoggingOptionsPayload() {
            return loggingOptionsPayload != null ? loggingOptionsPayload.toBuilder() : null;
        }

        @Override
        public final Builder loggingOptionsPayload(LoggingOptionsPayload loggingOptionsPayload) {
            this.loggingOptionsPayload = loggingOptionsPayload;
            return this;
        }

        public final void setLoggingOptionsPayload(LoggingOptionsPayload.BuilderImpl loggingOptionsPayload) {
            this.loggingOptionsPayload = loggingOptionsPayload != null ? loggingOptionsPayload.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetLoggingOptionsRequest build() {
            return new SetLoggingOptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
