/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Statistics for the checks performed during the audit.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaskStatistics implements SdkPojo, Serializable, ToCopyableBuilder<TaskStatistics.Builder, TaskStatistics> {
    private static final SdkField<Integer> TOTAL_CHECKS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(TaskStatistics::totalChecks)).setter(setter(Builder::totalChecks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalChecks").build()).build();

    private static final SdkField<Integer> IN_PROGRESS_CHECKS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(TaskStatistics::inProgressChecks)).setter(setter(Builder::inProgressChecks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inProgressChecks").build()).build();

    private static final SdkField<Integer> WAITING_FOR_DATA_COLLECTION_CHECKS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(TaskStatistics::waitingForDataCollectionChecks))
            .setter(setter(Builder::waitingForDataCollectionChecks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("waitingForDataCollectionChecks")
                    .build()).build();

    private static final SdkField<Integer> COMPLIANT_CHECKS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(TaskStatistics::compliantChecks)).setter(setter(Builder::compliantChecks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compliantChecks").build()).build();

    private static final SdkField<Integer> NON_COMPLIANT_CHECKS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(TaskStatistics::nonCompliantChecks)).setter(setter(Builder::nonCompliantChecks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nonCompliantChecks").build())
            .build();

    private static final SdkField<Integer> FAILED_CHECKS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(TaskStatistics::failedChecks)).setter(setter(Builder::failedChecks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedChecks").build()).build();

    private static final SdkField<Integer> CANCELED_CHECKS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(TaskStatistics::canceledChecks)).setter(setter(Builder::canceledChecks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canceledChecks").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_CHECKS_FIELD,
            IN_PROGRESS_CHECKS_FIELD, WAITING_FOR_DATA_COLLECTION_CHECKS_FIELD, COMPLIANT_CHECKS_FIELD,
            NON_COMPLIANT_CHECKS_FIELD, FAILED_CHECKS_FIELD, CANCELED_CHECKS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer totalChecks;

    private final Integer inProgressChecks;

    private final Integer waitingForDataCollectionChecks;

    private final Integer compliantChecks;

    private final Integer nonCompliantChecks;

    private final Integer failedChecks;

    private final Integer canceledChecks;

    private TaskStatistics(BuilderImpl builder) {
        this.totalChecks = builder.totalChecks;
        this.inProgressChecks = builder.inProgressChecks;
        this.waitingForDataCollectionChecks = builder.waitingForDataCollectionChecks;
        this.compliantChecks = builder.compliantChecks;
        this.nonCompliantChecks = builder.nonCompliantChecks;
        this.failedChecks = builder.failedChecks;
        this.canceledChecks = builder.canceledChecks;
    }

    /**
     * <p>
     * The number of checks in this audit.
     * </p>
     * 
     * @return The number of checks in this audit.
     */
    public Integer totalChecks() {
        return totalChecks;
    }

    /**
     * <p>
     * The number of checks in progress.
     * </p>
     * 
     * @return The number of checks in progress.
     */
    public Integer inProgressChecks() {
        return inProgressChecks;
    }

    /**
     * <p>
     * The number of checks waiting for data collection.
     * </p>
     * 
     * @return The number of checks waiting for data collection.
     */
    public Integer waitingForDataCollectionChecks() {
        return waitingForDataCollectionChecks;
    }

    /**
     * <p>
     * The number of checks that found compliant resources.
     * </p>
     * 
     * @return The number of checks that found compliant resources.
     */
    public Integer compliantChecks() {
        return compliantChecks;
    }

    /**
     * <p>
     * The number of checks that found non-compliant resources.
     * </p>
     * 
     * @return The number of checks that found non-compliant resources.
     */
    public Integer nonCompliantChecks() {
        return nonCompliantChecks;
    }

    /**
     * <p>
     * The number of checks
     * </p>
     * 
     * @return The number of checks
     */
    public Integer failedChecks() {
        return failedChecks;
    }

    /**
     * <p>
     * The number of checks that did not run because the audit was canceled.
     * </p>
     * 
     * @return The number of checks that did not run because the audit was canceled.
     */
    public Integer canceledChecks() {
        return canceledChecks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalChecks());
        hashCode = 31 * hashCode + Objects.hashCode(inProgressChecks());
        hashCode = 31 * hashCode + Objects.hashCode(waitingForDataCollectionChecks());
        hashCode = 31 * hashCode + Objects.hashCode(compliantChecks());
        hashCode = 31 * hashCode + Objects.hashCode(nonCompliantChecks());
        hashCode = 31 * hashCode + Objects.hashCode(failedChecks());
        hashCode = 31 * hashCode + Objects.hashCode(canceledChecks());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskStatistics)) {
            return false;
        }
        TaskStatistics other = (TaskStatistics) obj;
        return Objects.equals(totalChecks(), other.totalChecks()) && Objects.equals(inProgressChecks(), other.inProgressChecks())
                && Objects.equals(waitingForDataCollectionChecks(), other.waitingForDataCollectionChecks())
                && Objects.equals(compliantChecks(), other.compliantChecks())
                && Objects.equals(nonCompliantChecks(), other.nonCompliantChecks())
                && Objects.equals(failedChecks(), other.failedChecks())
                && Objects.equals(canceledChecks(), other.canceledChecks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TaskStatistics").add("TotalChecks", totalChecks()).add("InProgressChecks", inProgressChecks())
                .add("WaitingForDataCollectionChecks", waitingForDataCollectionChecks())
                .add("CompliantChecks", compliantChecks()).add("NonCompliantChecks", nonCompliantChecks())
                .add("FailedChecks", failedChecks()).add("CanceledChecks", canceledChecks()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "totalChecks":
            return Optional.ofNullable(clazz.cast(totalChecks()));
        case "inProgressChecks":
            return Optional.ofNullable(clazz.cast(inProgressChecks()));
        case "waitingForDataCollectionChecks":
            return Optional.ofNullable(clazz.cast(waitingForDataCollectionChecks()));
        case "compliantChecks":
            return Optional.ofNullable(clazz.cast(compliantChecks()));
        case "nonCompliantChecks":
            return Optional.ofNullable(clazz.cast(nonCompliantChecks()));
        case "failedChecks":
            return Optional.ofNullable(clazz.cast(failedChecks()));
        case "canceledChecks":
            return Optional.ofNullable(clazz.cast(canceledChecks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TaskStatistics, T> g) {
        return obj -> g.apply((TaskStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaskStatistics> {
        /**
         * <p>
         * The number of checks in this audit.
         * </p>
         * 
         * @param totalChecks
         *        The number of checks in this audit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalChecks(Integer totalChecks);

        /**
         * <p>
         * The number of checks in progress.
         * </p>
         * 
         * @param inProgressChecks
         *        The number of checks in progress.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inProgressChecks(Integer inProgressChecks);

        /**
         * <p>
         * The number of checks waiting for data collection.
         * </p>
         * 
         * @param waitingForDataCollectionChecks
         *        The number of checks waiting for data collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waitingForDataCollectionChecks(Integer waitingForDataCollectionChecks);

        /**
         * <p>
         * The number of checks that found compliant resources.
         * </p>
         * 
         * @param compliantChecks
         *        The number of checks that found compliant resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compliantChecks(Integer compliantChecks);

        /**
         * <p>
         * The number of checks that found non-compliant resources.
         * </p>
         * 
         * @param nonCompliantChecks
         *        The number of checks that found non-compliant resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonCompliantChecks(Integer nonCompliantChecks);

        /**
         * <p>
         * The number of checks
         * </p>
         * 
         * @param failedChecks
         *        The number of checks
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedChecks(Integer failedChecks);

        /**
         * <p>
         * The number of checks that did not run because the audit was canceled.
         * </p>
         * 
         * @param canceledChecks
         *        The number of checks that did not run because the audit was canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canceledChecks(Integer canceledChecks);
    }

    static final class BuilderImpl implements Builder {
        private Integer totalChecks;

        private Integer inProgressChecks;

        private Integer waitingForDataCollectionChecks;

        private Integer compliantChecks;

        private Integer nonCompliantChecks;

        private Integer failedChecks;

        private Integer canceledChecks;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskStatistics model) {
            totalChecks(model.totalChecks);
            inProgressChecks(model.inProgressChecks);
            waitingForDataCollectionChecks(model.waitingForDataCollectionChecks);
            compliantChecks(model.compliantChecks);
            nonCompliantChecks(model.nonCompliantChecks);
            failedChecks(model.failedChecks);
            canceledChecks(model.canceledChecks);
        }

        public final Integer getTotalChecks() {
            return totalChecks;
        }

        @Override
        public final Builder totalChecks(Integer totalChecks) {
            this.totalChecks = totalChecks;
            return this;
        }

        public final void setTotalChecks(Integer totalChecks) {
            this.totalChecks = totalChecks;
        }

        public final Integer getInProgressChecks() {
            return inProgressChecks;
        }

        @Override
        public final Builder inProgressChecks(Integer inProgressChecks) {
            this.inProgressChecks = inProgressChecks;
            return this;
        }

        public final void setInProgressChecks(Integer inProgressChecks) {
            this.inProgressChecks = inProgressChecks;
        }

        public final Integer getWaitingForDataCollectionChecks() {
            return waitingForDataCollectionChecks;
        }

        @Override
        public final Builder waitingForDataCollectionChecks(Integer waitingForDataCollectionChecks) {
            this.waitingForDataCollectionChecks = waitingForDataCollectionChecks;
            return this;
        }

        public final void setWaitingForDataCollectionChecks(Integer waitingForDataCollectionChecks) {
            this.waitingForDataCollectionChecks = waitingForDataCollectionChecks;
        }

        public final Integer getCompliantChecks() {
            return compliantChecks;
        }

        @Override
        public final Builder compliantChecks(Integer compliantChecks) {
            this.compliantChecks = compliantChecks;
            return this;
        }

        public final void setCompliantChecks(Integer compliantChecks) {
            this.compliantChecks = compliantChecks;
        }

        public final Integer getNonCompliantChecks() {
            return nonCompliantChecks;
        }

        @Override
        public final Builder nonCompliantChecks(Integer nonCompliantChecks) {
            this.nonCompliantChecks = nonCompliantChecks;
            return this;
        }

        public final void setNonCompliantChecks(Integer nonCompliantChecks) {
            this.nonCompliantChecks = nonCompliantChecks;
        }

        public final Integer getFailedChecks() {
            return failedChecks;
        }

        @Override
        public final Builder failedChecks(Integer failedChecks) {
            this.failedChecks = failedChecks;
            return this;
        }

        public final void setFailedChecks(Integer failedChecks) {
            this.failedChecks = failedChecks;
        }

        public final Integer getCanceledChecks() {
            return canceledChecks;
        }

        @Override
        public final Builder canceledChecks(Integer canceledChecks) {
            this.canceledChecks = canceledChecks;
            return this;
        }

        public final void setCanceledChecks(Integer canceledChecks) {
            this.canceledChecks = canceledChecks;
        }

        @Override
        public TaskStatistics build() {
            return new TaskStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
