/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetStatisticsResponse extends IotResponse implements
        ToCopyableBuilder<GetStatisticsResponse.Builder, GetStatisticsResponse> {
    private static final SdkField<Statistics> STATISTICS_FIELD = SdkField.<Statistics> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetStatisticsResponse::statistics)).setter(setter(Builder::statistics))
            .constructor(Statistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistics").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATISTICS_FIELD));

    private final Statistics statistics;

    private GetStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.statistics = builder.statistics;
    }

    /**
     * <p>
     * The statistics returned by the Fleet Indexing service based on the query and aggregation field.
     * </p>
     * 
     * @return The statistics returned by the Fleet Indexing service based on the query and aggregation field.
     */
    public Statistics statistics() {
        return statistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statistics());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStatisticsResponse)) {
            return false;
        }
        GetStatisticsResponse other = (GetStatisticsResponse) obj;
        return Objects.equals(statistics(), other.statistics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetStatisticsResponse").add("Statistics", statistics()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "statistics":
            return Optional.ofNullable(clazz.cast(statistics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetStatisticsResponse, T> g) {
        return obj -> g.apply((GetStatisticsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetStatisticsResponse> {
        /**
         * <p>
         * The statistics returned by the Fleet Indexing service based on the query and aggregation field.
         * </p>
         * 
         * @param statistics
         *        The statistics returned by the Fleet Indexing service based on the query and aggregation field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statistics(Statistics statistics);

        /**
         * <p>
         * The statistics returned by the Fleet Indexing service based on the query and aggregation field.
         * </p>
         * This is a convenience that creates an instance of the {@link Statistics.Builder} avoiding the need to create
         * one manually via {@link Statistics#builder()}.
         *
         * When the {@link Consumer} completes, {@link Statistics.Builder#build()} is called immediately and its result
         * is passed to {@link #statistics(Statistics)}.
         * 
         * @param statistics
         *        a consumer that will call methods on {@link Statistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statistics(Statistics)
         */
        default Builder statistics(Consumer<Statistics.Builder> statistics) {
            return statistics(Statistics.builder().applyMutation(statistics).build());
        }
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private Statistics statistics;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStatisticsResponse model) {
            super(model);
            statistics(model.statistics);
        }

        public final Statistics.Builder getStatistics() {
            return statistics != null ? statistics.toBuilder() : null;
        }

        @Override
        public final Builder statistics(Statistics statistics) {
            this.statistics = statistics;
            return this;
        }

        public final void setStatistics(Statistics.BuilderImpl statistics) {
            this.statistics = statistics != null ? statistics.build() : null;
        }

        @Override
        public GetStatisticsResponse build() {
            return new GetStatisticsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
