/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeThingGroupResponse extends IotResponse implements
        ToCopyableBuilder<DescribeThingGroupResponse.Builder, DescribeThingGroupResponse> {
    private static final SdkField<String> THING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeThingGroupResponse::thingGroupName)).setter(setter(Builder::thingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupName").build()).build();

    private static final SdkField<String> THING_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeThingGroupResponse::thingGroupId)).setter(setter(Builder::thingGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupId").build()).build();

    private static final SdkField<String> THING_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeThingGroupResponse::thingGroupArn)).setter(setter(Builder::thingGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupArn").build()).build();

    private static final SdkField<Long> VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DescribeThingGroupResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<ThingGroupProperties> THING_GROUP_PROPERTIES_FIELD = SdkField
            .<ThingGroupProperties> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeThingGroupResponse::thingGroupProperties)).setter(setter(Builder::thingGroupProperties))
            .constructor(ThingGroupProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupProperties").build())
            .build();

    private static final SdkField<ThingGroupMetadata> THING_GROUP_METADATA_FIELD = SdkField
            .<ThingGroupMetadata> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeThingGroupResponse::thingGroupMetadata)).setter(setter(Builder::thingGroupMetadata))
            .constructor(ThingGroupMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupMetadata").build())
            .build();

    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeThingGroupResponse::indexName)).setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexName").build()).build();

    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeThingGroupResponse::queryString)).setter(setter(Builder::queryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryString").build()).build();

    private static final SdkField<String> QUERY_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeThingGroupResponse::queryVersion)).setter(setter(Builder::queryVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryVersion").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeThingGroupResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_GROUP_NAME_FIELD,
            THING_GROUP_ID_FIELD, THING_GROUP_ARN_FIELD, VERSION_FIELD, THING_GROUP_PROPERTIES_FIELD, THING_GROUP_METADATA_FIELD,
            INDEX_NAME_FIELD, QUERY_STRING_FIELD, QUERY_VERSION_FIELD, STATUS_FIELD));

    private final String thingGroupName;

    private final String thingGroupId;

    private final String thingGroupArn;

    private final Long version;

    private final ThingGroupProperties thingGroupProperties;

    private final ThingGroupMetadata thingGroupMetadata;

    private final String indexName;

    private final String queryString;

    private final String queryVersion;

    private final String status;

    private DescribeThingGroupResponse(BuilderImpl builder) {
        super(builder);
        this.thingGroupName = builder.thingGroupName;
        this.thingGroupId = builder.thingGroupId;
        this.thingGroupArn = builder.thingGroupArn;
        this.version = builder.version;
        this.thingGroupProperties = builder.thingGroupProperties;
        this.thingGroupMetadata = builder.thingGroupMetadata;
        this.indexName = builder.indexName;
        this.queryString = builder.queryString;
        this.queryVersion = builder.queryVersion;
        this.status = builder.status;
    }

    /**
     * <p>
     * The name of the thing group.
     * </p>
     * 
     * @return The name of the thing group.
     */
    public String thingGroupName() {
        return thingGroupName;
    }

    /**
     * <p>
     * The thing group ID.
     * </p>
     * 
     * @return The thing group ID.
     */
    public String thingGroupId() {
        return thingGroupId;
    }

    /**
     * <p>
     * The thing group ARN.
     * </p>
     * 
     * @return The thing group ARN.
     */
    public String thingGroupArn() {
        return thingGroupArn;
    }

    /**
     * <p>
     * The version of the thing group.
     * </p>
     * 
     * @return The version of the thing group.
     */
    public Long version() {
        return version;
    }

    /**
     * <p>
     * The thing group properties.
     * </p>
     * 
     * @return The thing group properties.
     */
    public ThingGroupProperties thingGroupProperties() {
        return thingGroupProperties;
    }

    /**
     * <p>
     * Thing group metadata.
     * </p>
     * 
     * @return Thing group metadata.
     */
    public ThingGroupMetadata thingGroupMetadata() {
        return thingGroupMetadata;
    }

    /**
     * <p>
     * The dynamic thing group index name.
     * </p>
     * 
     * @return The dynamic thing group index name.
     */
    public String indexName() {
        return indexName;
    }

    /**
     * <p>
     * The dynamic thing group search query string.
     * </p>
     * 
     * @return The dynamic thing group search query string.
     */
    public String queryString() {
        return queryString;
    }

    /**
     * <p>
     * The dynamic thing group query version.
     * </p>
     * 
     * @return The dynamic thing group query version.
     */
    public String queryVersion() {
        return queryVersion;
    }

    /**
     * <p>
     * The dynamic thing group status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DynamicGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The dynamic thing group status.
     * @see DynamicGroupStatus
     */
    public DynamicGroupStatus status() {
        return DynamicGroupStatus.fromValue(status);
    }

    /**
     * <p>
     * The dynamic thing group status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DynamicGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The dynamic thing group status.
     * @see DynamicGroupStatus
     */
    public String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupProperties());
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        hashCode = 31 * hashCode + Objects.hashCode(queryVersion());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeThingGroupResponse)) {
            return false;
        }
        DescribeThingGroupResponse other = (DescribeThingGroupResponse) obj;
        return Objects.equals(thingGroupName(), other.thingGroupName()) && Objects.equals(thingGroupId(), other.thingGroupId())
                && Objects.equals(thingGroupArn(), other.thingGroupArn()) && Objects.equals(version(), other.version())
                && Objects.equals(thingGroupProperties(), other.thingGroupProperties())
                && Objects.equals(thingGroupMetadata(), other.thingGroupMetadata())
                && Objects.equals(indexName(), other.indexName()) && Objects.equals(queryString(), other.queryString())
                && Objects.equals(queryVersion(), other.queryVersion())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeThingGroupResponse").add("ThingGroupName", thingGroupName())
                .add("ThingGroupId", thingGroupId()).add("ThingGroupArn", thingGroupArn()).add("Version", version())
                .add("ThingGroupProperties", thingGroupProperties()).add("ThingGroupMetadata", thingGroupMetadata())
                .add("IndexName", indexName()).add("QueryString", queryString()).add("QueryVersion", queryVersion())
                .add("Status", statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingGroupName":
            return Optional.ofNullable(clazz.cast(thingGroupName()));
        case "thingGroupId":
            return Optional.ofNullable(clazz.cast(thingGroupId()));
        case "thingGroupArn":
            return Optional.ofNullable(clazz.cast(thingGroupArn()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "thingGroupProperties":
            return Optional.ofNullable(clazz.cast(thingGroupProperties()));
        case "thingGroupMetadata":
            return Optional.ofNullable(clazz.cast(thingGroupMetadata()));
        case "indexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "queryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        case "queryVersion":
            return Optional.ofNullable(clazz.cast(queryVersion()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeThingGroupResponse, T> g) {
        return obj -> g.apply((DescribeThingGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeThingGroupResponse> {
        /**
         * <p>
         * The name of the thing group.
         * </p>
         * 
         * @param thingGroupName
         *        The name of the thing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupName(String thingGroupName);

        /**
         * <p>
         * The thing group ID.
         * </p>
         * 
         * @param thingGroupId
         *        The thing group ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupId(String thingGroupId);

        /**
         * <p>
         * The thing group ARN.
         * </p>
         * 
         * @param thingGroupArn
         *        The thing group ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupArn(String thingGroupArn);

        /**
         * <p>
         * The version of the thing group.
         * </p>
         * 
         * @param version
         *        The version of the thing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Long version);

        /**
         * <p>
         * The thing group properties.
         * </p>
         * 
         * @param thingGroupProperties
         *        The thing group properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupProperties(ThingGroupProperties thingGroupProperties);

        /**
         * <p>
         * The thing group properties.
         * </p>
         * This is a convenience that creates an instance of the {@link ThingGroupProperties.Builder} avoiding the need
         * to create one manually via {@link ThingGroupProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link ThingGroupProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #thingGroupProperties(ThingGroupProperties)}.
         * 
         * @param thingGroupProperties
         *        a consumer that will call methods on {@link ThingGroupProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thingGroupProperties(ThingGroupProperties)
         */
        default Builder thingGroupProperties(Consumer<ThingGroupProperties.Builder> thingGroupProperties) {
            return thingGroupProperties(ThingGroupProperties.builder().applyMutation(thingGroupProperties).build());
        }

        /**
         * <p>
         * Thing group metadata.
         * </p>
         * 
         * @param thingGroupMetadata
         *        Thing group metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupMetadata(ThingGroupMetadata thingGroupMetadata);

        /**
         * <p>
         * Thing group metadata.
         * </p>
         * This is a convenience that creates an instance of the {@link ThingGroupMetadata.Builder} avoiding the need to
         * create one manually via {@link ThingGroupMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link ThingGroupMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #thingGroupMetadata(ThingGroupMetadata)}.
         * 
         * @param thingGroupMetadata
         *        a consumer that will call methods on {@link ThingGroupMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thingGroupMetadata(ThingGroupMetadata)
         */
        default Builder thingGroupMetadata(Consumer<ThingGroupMetadata.Builder> thingGroupMetadata) {
            return thingGroupMetadata(ThingGroupMetadata.builder().applyMutation(thingGroupMetadata).build());
        }

        /**
         * <p>
         * The dynamic thing group index name.
         * </p>
         * 
         * @param indexName
         *        The dynamic thing group index name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * The dynamic thing group search query string.
         * </p>
         * 
         * @param queryString
         *        The dynamic thing group search query string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(String queryString);

        /**
         * <p>
         * The dynamic thing group query version.
         * </p>
         * 
         * @param queryVersion
         *        The dynamic thing group query version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryVersion(String queryVersion);

        /**
         * <p>
         * The dynamic thing group status.
         * </p>
         * 
         * @param status
         *        The dynamic thing group status.
         * @see DynamicGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DynamicGroupStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The dynamic thing group status.
         * </p>
         * 
         * @param status
         *        The dynamic thing group status.
         * @see DynamicGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DynamicGroupStatus
         */
        Builder status(DynamicGroupStatus status);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String thingGroupName;

        private String thingGroupId;

        private String thingGroupArn;

        private Long version;

        private ThingGroupProperties thingGroupProperties;

        private ThingGroupMetadata thingGroupMetadata;

        private String indexName;

        private String queryString;

        private String queryVersion;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeThingGroupResponse model) {
            super(model);
            thingGroupName(model.thingGroupName);
            thingGroupId(model.thingGroupId);
            thingGroupArn(model.thingGroupArn);
            version(model.version);
            thingGroupProperties(model.thingGroupProperties);
            thingGroupMetadata(model.thingGroupMetadata);
            indexName(model.indexName);
            queryString(model.queryString);
            queryVersion(model.queryVersion);
            status(model.status);
        }

        public final String getThingGroupName() {
            return thingGroupName;
        }

        @Override
        public final Builder thingGroupName(String thingGroupName) {
            this.thingGroupName = thingGroupName;
            return this;
        }

        public final void setThingGroupName(String thingGroupName) {
            this.thingGroupName = thingGroupName;
        }

        public final String getThingGroupId() {
            return thingGroupId;
        }

        @Override
        public final Builder thingGroupId(String thingGroupId) {
            this.thingGroupId = thingGroupId;
            return this;
        }

        public final void setThingGroupId(String thingGroupId) {
            this.thingGroupId = thingGroupId;
        }

        public final String getThingGroupArn() {
            return thingGroupArn;
        }

        @Override
        public final Builder thingGroupArn(String thingGroupArn) {
            this.thingGroupArn = thingGroupArn;
            return this;
        }

        public final void setThingGroupArn(String thingGroupArn) {
            this.thingGroupArn = thingGroupArn;
        }

        public final Long getVersion() {
            return version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        public final ThingGroupProperties.Builder getThingGroupProperties() {
            return thingGroupProperties != null ? thingGroupProperties.toBuilder() : null;
        }

        @Override
        public final Builder thingGroupProperties(ThingGroupProperties thingGroupProperties) {
            this.thingGroupProperties = thingGroupProperties;
            return this;
        }

        public final void setThingGroupProperties(ThingGroupProperties.BuilderImpl thingGroupProperties) {
            this.thingGroupProperties = thingGroupProperties != null ? thingGroupProperties.build() : null;
        }

        public final ThingGroupMetadata.Builder getThingGroupMetadata() {
            return thingGroupMetadata != null ? thingGroupMetadata.toBuilder() : null;
        }

        @Override
        public final Builder thingGroupMetadata(ThingGroupMetadata thingGroupMetadata) {
            this.thingGroupMetadata = thingGroupMetadata;
            return this;
        }

        public final void setThingGroupMetadata(ThingGroupMetadata.BuilderImpl thingGroupMetadata) {
            this.thingGroupMetadata = thingGroupMetadata != null ? thingGroupMetadata.build() : null;
        }

        public final String getIndexName() {
            return indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final String getQueryString() {
            return queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        public final String getQueryVersion() {
            return queryVersion;
        }

        @Override
        public final Builder queryVersion(String queryVersion) {
            this.queryVersion = queryVersion;
            return this;
        }

        public final void setQueryVersion(String queryVersion) {
            this.queryVersion = queryVersion;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DynamicGroupStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public DescribeThingGroupResponse build() {
            return new DescribeThingGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
