/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.AutoRegistrationStatus;
import software.amazon.awssdk.services.iot.model.CACertificateStatus;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.RegistrationConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCaCertificateRequest
extends IotRequest
implements ToCopyableBuilder<Builder, UpdateCaCertificateRequest> {
    private static final SdkField<String> CERTIFICATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateCaCertificateRequest.getter(UpdateCaCertificateRequest::certificateId)).setter(UpdateCaCertificateRequest.setter(Builder::certificateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("caCertificateId").build()}).build();
    private static final SdkField<String> NEW_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateCaCertificateRequest.getter(UpdateCaCertificateRequest::newStatusAsString)).setter(UpdateCaCertificateRequest.setter(Builder::newStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("newStatus").build()}).build();
    private static final SdkField<String> NEW_AUTO_REGISTRATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateCaCertificateRequest.getter(UpdateCaCertificateRequest::newAutoRegistrationStatusAsString)).setter(UpdateCaCertificateRequest.setter(Builder::newAutoRegistrationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("newAutoRegistrationStatus").build()}).build();
    private static final SdkField<RegistrationConfig> REGISTRATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateCaCertificateRequest.getter(UpdateCaCertificateRequest::registrationConfig)).setter(UpdateCaCertificateRequest.setter(Builder::registrationConfig)).constructor(RegistrationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registrationConfig").build()}).build();
    private static final SdkField<Boolean> REMOVE_AUTO_REGISTRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(UpdateCaCertificateRequest.getter(UpdateCaCertificateRequest::removeAutoRegistration)).setter(UpdateCaCertificateRequest.setter(Builder::removeAutoRegistration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("removeAutoRegistration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ID_FIELD, NEW_STATUS_FIELD, NEW_AUTO_REGISTRATION_STATUS_FIELD, REGISTRATION_CONFIG_FIELD, REMOVE_AUTO_REGISTRATION_FIELD));
    private final String certificateId;
    private final String newStatus;
    private final String newAutoRegistrationStatus;
    private final RegistrationConfig registrationConfig;
    private final Boolean removeAutoRegistration;

    private UpdateCaCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.certificateId = builder.certificateId;
        this.newStatus = builder.newStatus;
        this.newAutoRegistrationStatus = builder.newAutoRegistrationStatus;
        this.registrationConfig = builder.registrationConfig;
        this.removeAutoRegistration = builder.removeAutoRegistration;
    }

    public String certificateId() {
        return this.certificateId;
    }

    public CACertificateStatus newStatus() {
        return CACertificateStatus.fromValue(this.newStatus);
    }

    public String newStatusAsString() {
        return this.newStatus;
    }

    public AutoRegistrationStatus newAutoRegistrationStatus() {
        return AutoRegistrationStatus.fromValue(this.newAutoRegistrationStatus);
    }

    public String newAutoRegistrationStatusAsString() {
        return this.newAutoRegistrationStatus;
    }

    public RegistrationConfig registrationConfig() {
        return this.registrationConfig;
    }

    public Boolean removeAutoRegistration() {
        return this.removeAutoRegistration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.newStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.newAutoRegistrationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeAutoRegistration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCaCertificateRequest)) {
            return false;
        }
        UpdateCaCertificateRequest other = (UpdateCaCertificateRequest)((Object)obj);
        return Objects.equals(this.certificateId(), other.certificateId()) && Objects.equals(this.newStatusAsString(), other.newStatusAsString()) && Objects.equals(this.newAutoRegistrationStatusAsString(), other.newAutoRegistrationStatusAsString()) && Objects.equals(this.registrationConfig(), other.registrationConfig()) && Objects.equals(this.removeAutoRegistration(), other.removeAutoRegistration());
    }

    public String toString() {
        return ToString.builder((String)"UpdateCaCertificateRequest").add("CertificateId", (Object)this.certificateId()).add("NewStatus", (Object)this.newStatusAsString()).add("NewAutoRegistrationStatus", (Object)this.newAutoRegistrationStatusAsString()).add("RegistrationConfig", (Object)this.registrationConfig()).add("RemoveAutoRegistration", (Object)this.removeAutoRegistration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificateId": {
                return Optional.ofNullable(clazz.cast(this.certificateId()));
            }
            case "newStatus": {
                return Optional.ofNullable(clazz.cast(this.newStatusAsString()));
            }
            case "newAutoRegistrationStatus": {
                return Optional.ofNullable(clazz.cast(this.newAutoRegistrationStatusAsString()));
            }
            case "registrationConfig": {
                return Optional.ofNullable(clazz.cast(this.registrationConfig()));
            }
            case "removeAutoRegistration": {
                return Optional.ofNullable(clazz.cast(this.removeAutoRegistration()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCaCertificateRequest, T> g) {
        return obj -> g.apply((UpdateCaCertificateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String certificateId;
        private String newStatus;
        private String newAutoRegistrationStatus;
        private RegistrationConfig registrationConfig;
        private Boolean removeAutoRegistration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCaCertificateRequest model) {
            super(model);
            this.certificateId(model.certificateId);
            this.newStatus(model.newStatus);
            this.newAutoRegistrationStatus(model.newAutoRegistrationStatus);
            this.registrationConfig(model.registrationConfig);
            this.removeAutoRegistration(model.removeAutoRegistration);
        }

        public final String getCertificateId() {
            return this.certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final String getNewStatusAsString() {
            return this.newStatus;
        }

        @Override
        public final Builder newStatus(String newStatus) {
            this.newStatus = newStatus;
            return this;
        }

        @Override
        public final Builder newStatus(CACertificateStatus newStatus) {
            this.newStatus(newStatus.toString());
            return this;
        }

        public final void setNewStatus(String newStatus) {
            this.newStatus = newStatus;
        }

        public final String getNewAutoRegistrationStatusAsString() {
            return this.newAutoRegistrationStatus;
        }

        @Override
        public final Builder newAutoRegistrationStatus(String newAutoRegistrationStatus) {
            this.newAutoRegistrationStatus = newAutoRegistrationStatus;
            return this;
        }

        @Override
        public final Builder newAutoRegistrationStatus(AutoRegistrationStatus newAutoRegistrationStatus) {
            this.newAutoRegistrationStatus(newAutoRegistrationStatus.toString());
            return this;
        }

        public final void setNewAutoRegistrationStatus(String newAutoRegistrationStatus) {
            this.newAutoRegistrationStatus = newAutoRegistrationStatus;
        }

        public final RegistrationConfig.Builder getRegistrationConfig() {
            return this.registrationConfig != null ? this.registrationConfig.toBuilder() : null;
        }

        @Override
        public final Builder registrationConfig(RegistrationConfig registrationConfig) {
            this.registrationConfig = registrationConfig;
            return this;
        }

        public final void setRegistrationConfig(RegistrationConfig.BuilderImpl registrationConfig) {
            this.registrationConfig = registrationConfig != null ? registrationConfig.build() : null;
        }

        public final Boolean getRemoveAutoRegistration() {
            return this.removeAutoRegistration;
        }

        @Override
        public final Builder removeAutoRegistration(Boolean removeAutoRegistration) {
            this.removeAutoRegistration = removeAutoRegistration;
            return this;
        }

        public final void setRemoveAutoRegistration(Boolean removeAutoRegistration) {
            this.removeAutoRegistration = removeAutoRegistration;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCaCertificateRequest build() {
            return new UpdateCaCertificateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateCaCertificateRequest> {
        public Builder certificateId(String var1);

        public Builder newStatus(String var1);

        public Builder newStatus(CACertificateStatus var1);

        public Builder newAutoRegistrationStatus(String var1);

        public Builder newAutoRegistrationStatus(AutoRegistrationStatus var1);

        public Builder registrationConfig(RegistrationConfig var1);

        default public Builder registrationConfig(Consumer<RegistrationConfig.Builder> registrationConfig) {
            return this.registrationConfig((RegistrationConfig)((RegistrationConfig.Builder)RegistrationConfig.builder().applyMutation(registrationConfig)).build());
        }

        public Builder removeAutoRegistration(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

