/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAuditTaskResponse extends IotResponse implements
        ToCopyableBuilder<DescribeAuditTaskResponse.Builder, DescribeAuditTaskResponse> {
    private static final SdkField<String> TASK_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeAuditTaskResponse::taskStatusAsString)).setter(setter(Builder::taskStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskStatus").build()).build();

    private static final SdkField<String> TASK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeAuditTaskResponse::taskTypeAsString)).setter(setter(Builder::taskType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskType").build()).build();

    private static final SdkField<Instant> TASK_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeAuditTaskResponse::taskStartTime)).setter(setter(Builder::taskStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskStartTime").build()).build();

    private static final SdkField<TaskStatistics> TASK_STATISTICS_FIELD = SdkField
            .<TaskStatistics> builder(MarshallingType.SDK_POJO).getter(getter(DescribeAuditTaskResponse::taskStatistics))
            .setter(setter(Builder::taskStatistics)).constructor(TaskStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskStatistics").build()).build();

    private static final SdkField<String> SCHEDULED_AUDIT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeAuditTaskResponse::scheduledAuditName)).setter(setter(Builder::scheduledAuditName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledAuditName").build())
            .build();

    private static final SdkField<Map<String, AuditCheckDetails>> AUDIT_DETAILS_FIELD = SdkField
            .<Map<String, AuditCheckDetails>> builder(MarshallingType.MAP)
            .getter(getter(DescribeAuditTaskResponse::auditDetails))
            .setter(setter(Builder::auditDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("auditDetails").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AuditCheckDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AuditCheckDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_STATUS_FIELD,
            TASK_TYPE_FIELD, TASK_START_TIME_FIELD, TASK_STATISTICS_FIELD, SCHEDULED_AUDIT_NAME_FIELD, AUDIT_DETAILS_FIELD));

    private final String taskStatus;

    private final String taskType;

    private final Instant taskStartTime;

    private final TaskStatistics taskStatistics;

    private final String scheduledAuditName;

    private final Map<String, AuditCheckDetails> auditDetails;

    private DescribeAuditTaskResponse(BuilderImpl builder) {
        super(builder);
        this.taskStatus = builder.taskStatus;
        this.taskType = builder.taskType;
        this.taskStartTime = builder.taskStartTime;
        this.taskStatistics = builder.taskStatistics;
        this.scheduledAuditName = builder.scheduledAuditName;
        this.auditDetails = builder.auditDetails;
    }

    /**
     * <p>
     * The status of the audit: one of "IN_PROGRESS", "COMPLETED", "FAILED", or "CANCELED".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskStatus} will
     * return {@link AuditTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskStatusAsString}.
     * </p>
     * 
     * @return The status of the audit: one of "IN_PROGRESS", "COMPLETED", "FAILED", or "CANCELED".
     * @see AuditTaskStatus
     */
    public AuditTaskStatus taskStatus() {
        return AuditTaskStatus.fromValue(taskStatus);
    }

    /**
     * <p>
     * The status of the audit: one of "IN_PROGRESS", "COMPLETED", "FAILED", or "CANCELED".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskStatus} will
     * return {@link AuditTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskStatusAsString}.
     * </p>
     * 
     * @return The status of the audit: one of "IN_PROGRESS", "COMPLETED", "FAILED", or "CANCELED".
     * @see AuditTaskStatus
     */
    public String taskStatusAsString() {
        return taskStatus;
    }

    /**
     * <p>
     * The type of audit: "ON_DEMAND_AUDIT_TASK" or "SCHEDULED_AUDIT_TASK".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskType} will
     * return {@link AuditTaskType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskTypeAsString}.
     * </p>
     * 
     * @return The type of audit: "ON_DEMAND_AUDIT_TASK" or "SCHEDULED_AUDIT_TASK".
     * @see AuditTaskType
     */
    public AuditTaskType taskType() {
        return AuditTaskType.fromValue(taskType);
    }

    /**
     * <p>
     * The type of audit: "ON_DEMAND_AUDIT_TASK" or "SCHEDULED_AUDIT_TASK".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskType} will
     * return {@link AuditTaskType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskTypeAsString}.
     * </p>
     * 
     * @return The type of audit: "ON_DEMAND_AUDIT_TASK" or "SCHEDULED_AUDIT_TASK".
     * @see AuditTaskType
     */
    public String taskTypeAsString() {
        return taskType;
    }

    /**
     * <p>
     * The time the audit started.
     * </p>
     * 
     * @return The time the audit started.
     */
    public Instant taskStartTime() {
        return taskStartTime;
    }

    /**
     * <p>
     * Statistical information about the audit.
     * </p>
     * 
     * @return Statistical information about the audit.
     */
    public TaskStatistics taskStatistics() {
        return taskStatistics;
    }

    /**
     * <p>
     * The name of the scheduled audit (only if the audit was a scheduled audit).
     * </p>
     * 
     * @return The name of the scheduled audit (only if the audit was a scheduled audit).
     */
    public String scheduledAuditName() {
        return scheduledAuditName;
    }

    /**
     * <p>
     * Detailed information about each check performed during this audit.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Detailed information about each check performed during this audit.
     */
    public Map<String, AuditCheckDetails> auditDetails() {
        return auditDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taskStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(taskTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(taskStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(taskStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledAuditName());
        hashCode = 31 * hashCode + Objects.hashCode(auditDetails());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAuditTaskResponse)) {
            return false;
        }
        DescribeAuditTaskResponse other = (DescribeAuditTaskResponse) obj;
        return Objects.equals(taskStatusAsString(), other.taskStatusAsString())
                && Objects.equals(taskTypeAsString(), other.taskTypeAsString())
                && Objects.equals(taskStartTime(), other.taskStartTime())
                && Objects.equals(taskStatistics(), other.taskStatistics())
                && Objects.equals(scheduledAuditName(), other.scheduledAuditName())
                && Objects.equals(auditDetails(), other.auditDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeAuditTaskResponse").add("TaskStatus", taskStatusAsString())
                .add("TaskType", taskTypeAsString()).add("TaskStartTime", taskStartTime())
                .add("TaskStatistics", taskStatistics()).add("ScheduledAuditName", scheduledAuditName())
                .add("AuditDetails", auditDetails()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskStatus":
            return Optional.ofNullable(clazz.cast(taskStatusAsString()));
        case "taskType":
            return Optional.ofNullable(clazz.cast(taskTypeAsString()));
        case "taskStartTime":
            return Optional.ofNullable(clazz.cast(taskStartTime()));
        case "taskStatistics":
            return Optional.ofNullable(clazz.cast(taskStatistics()));
        case "scheduledAuditName":
            return Optional.ofNullable(clazz.cast(scheduledAuditName()));
        case "auditDetails":
            return Optional.ofNullable(clazz.cast(auditDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAuditTaskResponse, T> g) {
        return obj -> g.apply((DescribeAuditTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAuditTaskResponse> {
        /**
         * <p>
         * The status of the audit: one of "IN_PROGRESS", "COMPLETED", "FAILED", or "CANCELED".
         * </p>
         * 
         * @param taskStatus
         *        The status of the audit: one of "IN_PROGRESS", "COMPLETED", "FAILED", or "CANCELED".
         * @see AuditTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuditTaskStatus
         */
        Builder taskStatus(String taskStatus);

        /**
         * <p>
         * The status of the audit: one of "IN_PROGRESS", "COMPLETED", "FAILED", or "CANCELED".
         * </p>
         * 
         * @param taskStatus
         *        The status of the audit: one of "IN_PROGRESS", "COMPLETED", "FAILED", or "CANCELED".
         * @see AuditTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuditTaskStatus
         */
        Builder taskStatus(AuditTaskStatus taskStatus);

        /**
         * <p>
         * The type of audit: "ON_DEMAND_AUDIT_TASK" or "SCHEDULED_AUDIT_TASK".
         * </p>
         * 
         * @param taskType
         *        The type of audit: "ON_DEMAND_AUDIT_TASK" or "SCHEDULED_AUDIT_TASK".
         * @see AuditTaskType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuditTaskType
         */
        Builder taskType(String taskType);

        /**
         * <p>
         * The type of audit: "ON_DEMAND_AUDIT_TASK" or "SCHEDULED_AUDIT_TASK".
         * </p>
         * 
         * @param taskType
         *        The type of audit: "ON_DEMAND_AUDIT_TASK" or "SCHEDULED_AUDIT_TASK".
         * @see AuditTaskType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuditTaskType
         */
        Builder taskType(AuditTaskType taskType);

        /**
         * <p>
         * The time the audit started.
         * </p>
         * 
         * @param taskStartTime
         *        The time the audit started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskStartTime(Instant taskStartTime);

        /**
         * <p>
         * Statistical information about the audit.
         * </p>
         * 
         * @param taskStatistics
         *        Statistical information about the audit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskStatistics(TaskStatistics taskStatistics);

        /**
         * <p>
         * Statistical information about the audit.
         * </p>
         * This is a convenience that creates an instance of the {@link TaskStatistics.Builder} avoiding the need to
         * create one manually via {@link TaskStatistics#builder()}.
         *
         * When the {@link Consumer} completes, {@link TaskStatistics.Builder#build()} is called immediately and its
         * result is passed to {@link #taskStatistics(TaskStatistics)}.
         * 
         * @param taskStatistics
         *        a consumer that will call methods on {@link TaskStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskStatistics(TaskStatistics)
         */
        default Builder taskStatistics(Consumer<TaskStatistics.Builder> taskStatistics) {
            return taskStatistics(TaskStatistics.builder().applyMutation(taskStatistics).build());
        }

        /**
         * <p>
         * The name of the scheduled audit (only if the audit was a scheduled audit).
         * </p>
         * 
         * @param scheduledAuditName
         *        The name of the scheduled audit (only if the audit was a scheduled audit).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledAuditName(String scheduledAuditName);

        /**
         * <p>
         * Detailed information about each check performed during this audit.
         * </p>
         * 
         * @param auditDetails
         *        Detailed information about each check performed during this audit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditDetails(Map<String, AuditCheckDetails> auditDetails);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String taskStatus;

        private String taskType;

        private Instant taskStartTime;

        private TaskStatistics taskStatistics;

        private String scheduledAuditName;

        private Map<String, AuditCheckDetails> auditDetails = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAuditTaskResponse model) {
            super(model);
            taskStatus(model.taskStatus);
            taskType(model.taskType);
            taskStartTime(model.taskStartTime);
            taskStatistics(model.taskStatistics);
            scheduledAuditName(model.scheduledAuditName);
            auditDetails(model.auditDetails);
        }

        public final String getTaskStatusAsString() {
            return taskStatus;
        }

        @Override
        public final Builder taskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
            return this;
        }

        @Override
        public final Builder taskStatus(AuditTaskStatus taskStatus) {
            this.taskStatus(taskStatus.toString());
            return this;
        }

        public final void setTaskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
        }

        public final String getTaskTypeAsString() {
            return taskType;
        }

        @Override
        public final Builder taskType(String taskType) {
            this.taskType = taskType;
            return this;
        }

        @Override
        public final Builder taskType(AuditTaskType taskType) {
            this.taskType(taskType.toString());
            return this;
        }

        public final void setTaskType(String taskType) {
            this.taskType = taskType;
        }

        public final Instant getTaskStartTime() {
            return taskStartTime;
        }

        @Override
        public final Builder taskStartTime(Instant taskStartTime) {
            this.taskStartTime = taskStartTime;
            return this;
        }

        public final void setTaskStartTime(Instant taskStartTime) {
            this.taskStartTime = taskStartTime;
        }

        public final TaskStatistics.Builder getTaskStatistics() {
            return taskStatistics != null ? taskStatistics.toBuilder() : null;
        }

        @Override
        public final Builder taskStatistics(TaskStatistics taskStatistics) {
            this.taskStatistics = taskStatistics;
            return this;
        }

        public final void setTaskStatistics(TaskStatistics.BuilderImpl taskStatistics) {
            this.taskStatistics = taskStatistics != null ? taskStatistics.build() : null;
        }

        public final String getScheduledAuditName() {
            return scheduledAuditName;
        }

        @Override
        public final Builder scheduledAuditName(String scheduledAuditName) {
            this.scheduledAuditName = scheduledAuditName;
            return this;
        }

        public final void setScheduledAuditName(String scheduledAuditName) {
            this.scheduledAuditName = scheduledAuditName;
        }

        public final Map<String, AuditCheckDetails.Builder> getAuditDetails() {
            return auditDetails != null ? CollectionUtils.mapValues(auditDetails, AuditCheckDetails::toBuilder) : null;
        }

        @Override
        public final Builder auditDetails(Map<String, AuditCheckDetails> auditDetails) {
            this.auditDetails = AuditDetailsCopier.copy(auditDetails);
            return this;
        }

        public final void setAuditDetails(Map<String, AuditCheckDetails.BuilderImpl> auditDetails) {
            this.auditDetails = AuditDetailsCopier.copyFromBuilder(auditDetails);
        }

        @Override
        public DescribeAuditTaskResponse build() {
            return new DescribeAuditTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
