/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSecurityProfileRequest extends IotRequest implements
        ToCopyableBuilder<CreateSecurityProfileRequest.Builder, CreateSecurityProfileRequest> {
    private static final SdkField<String> SECURITY_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSecurityProfileRequest::securityProfileName)).setter(setter(Builder::securityProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("securityProfileName").build()).build();

    private static final SdkField<String> SECURITY_PROFILE_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSecurityProfileRequest::securityProfileDescription))
            .setter(setter(Builder::securityProfileDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityProfileDescription").build())
            .build();

    private static final SdkField<List<Behavior>> BEHAVIORS_FIELD = SdkField
            .<List<Behavior>> builder(MarshallingType.LIST)
            .getter(getter(CreateSecurityProfileRequest::behaviors))
            .setter(setter(Builder::behaviors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("behaviors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Behavior> builder(MarshallingType.SDK_POJO)
                                            .constructor(Behavior::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, AlertTarget>> ALERT_TARGETS_FIELD = SdkField
            .<Map<String, AlertTarget>> builder(MarshallingType.MAP)
            .getter(getter(CreateSecurityProfileRequest::alertTargetsAsStrings))
            .setter(setter(Builder::alertTargetsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alertTargets").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AlertTarget> builder(MarshallingType.SDK_POJO)
                                            .constructor(AlertTarget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> ADDITIONAL_METRICS_TO_RETAIN_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateSecurityProfileRequest::additionalMetricsToRetain))
            .setter(setter(Builder::additionalMetricsToRetain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalMetricsToRetain").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateSecurityProfileRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_PROFILE_NAME_FIELD,
            SECURITY_PROFILE_DESCRIPTION_FIELD, BEHAVIORS_FIELD, ALERT_TARGETS_FIELD, ADDITIONAL_METRICS_TO_RETAIN_FIELD,
            TAGS_FIELD));

    private final String securityProfileName;

    private final String securityProfileDescription;

    private final List<Behavior> behaviors;

    private final Map<String, AlertTarget> alertTargets;

    private final List<String> additionalMetricsToRetain;

    private final List<Tag> tags;

    private CreateSecurityProfileRequest(BuilderImpl builder) {
        super(builder);
        this.securityProfileName = builder.securityProfileName;
        this.securityProfileDescription = builder.securityProfileDescription;
        this.behaviors = builder.behaviors;
        this.alertTargets = builder.alertTargets;
        this.additionalMetricsToRetain = builder.additionalMetricsToRetain;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name you are giving to the security profile.
     * </p>
     * 
     * @return The name you are giving to the security profile.
     */
    public String securityProfileName() {
        return securityProfileName;
    }

    /**
     * <p>
     * A description of the security profile.
     * </p>
     * 
     * @return A description of the security profile.
     */
    public String securityProfileDescription() {
        return securityProfileDescription;
    }

    /**
     * <p>
     * Specifies the behaviors that, when violated by a device (thing), cause an alert.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Specifies the behaviors that, when violated by a device (thing), cause an alert.
     */
    public List<Behavior> behaviors() {
        return behaviors;
    }

    /**
     * <p>
     * Specifies the destinations to which alerts are sent. (Alerts are always sent to the console.) Alerts are
     * generated when a device (thing) violates a behavior.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Specifies the destinations to which alerts are sent. (Alerts are always sent to the console.) Alerts are
     *         generated when a device (thing) violates a behavior.
     */
    public Map<AlertTargetType, AlertTarget> alertTargets() {
        return AlertTargetsCopier.copyStringToEnum(alertTargets);
    }

    /**
     * <p>
     * Specifies the destinations to which alerts are sent. (Alerts are always sent to the console.) Alerts are
     * generated when a device (thing) violates a behavior.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Specifies the destinations to which alerts are sent. (Alerts are always sent to the console.) Alerts are
     *         generated when a device (thing) violates a behavior.
     */
    public Map<String, AlertTarget> alertTargetsAsStrings() {
        return alertTargets;
    }

    /**
     * <p>
     * A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the
     * profile's <code>behaviors</code> but it is also retained for any metric specified here.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of metrics whose data is retained (stored). By default, data is retained for any metric used in
     *         the profile's <code>behaviors</code> but it is also retained for any metric specified here.
     */
    public List<String> additionalMetricsToRetain() {
        return additionalMetricsToRetain;
    }

    /**
     * <p>
     * Metadata which can be used to manage the security profile.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Metadata which can be used to manage the security profile.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(securityProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(securityProfileDescription());
        hashCode = 31 * hashCode + Objects.hashCode(behaviors());
        hashCode = 31 * hashCode + Objects.hashCode(alertTargetsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(additionalMetricsToRetain());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSecurityProfileRequest)) {
            return false;
        }
        CreateSecurityProfileRequest other = (CreateSecurityProfileRequest) obj;
        return Objects.equals(securityProfileName(), other.securityProfileName())
                && Objects.equals(securityProfileDescription(), other.securityProfileDescription())
                && Objects.equals(behaviors(), other.behaviors())
                && Objects.equals(alertTargetsAsStrings(), other.alertTargetsAsStrings())
                && Objects.equals(additionalMetricsToRetain(), other.additionalMetricsToRetain())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateSecurityProfileRequest").add("SecurityProfileName", securityProfileName())
                .add("SecurityProfileDescription", securityProfileDescription()).add("Behaviors", behaviors())
                .add("AlertTargets", alertTargetsAsStrings()).add("AdditionalMetricsToRetain", additionalMetricsToRetain())
                .add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "securityProfileName":
            return Optional.ofNullable(clazz.cast(securityProfileName()));
        case "securityProfileDescription":
            return Optional.ofNullable(clazz.cast(securityProfileDescription()));
        case "behaviors":
            return Optional.ofNullable(clazz.cast(behaviors()));
        case "alertTargets":
            return Optional.ofNullable(clazz.cast(alertTargetsAsStrings()));
        case "additionalMetricsToRetain":
            return Optional.ofNullable(clazz.cast(additionalMetricsToRetain()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSecurityProfileRequest, T> g) {
        return obj -> g.apply((CreateSecurityProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateSecurityProfileRequest> {
        /**
         * <p>
         * The name you are giving to the security profile.
         * </p>
         * 
         * @param securityProfileName
         *        The name you are giving to the security profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileName(String securityProfileName);

        /**
         * <p>
         * A description of the security profile.
         * </p>
         * 
         * @param securityProfileDescription
         *        A description of the security profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileDescription(String securityProfileDescription);

        /**
         * <p>
         * Specifies the behaviors that, when violated by a device (thing), cause an alert.
         * </p>
         * 
         * @param behaviors
         *        Specifies the behaviors that, when violated by a device (thing), cause an alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder behaviors(Collection<Behavior> behaviors);

        /**
         * <p>
         * Specifies the behaviors that, when violated by a device (thing), cause an alert.
         * </p>
         * 
         * @param behaviors
         *        Specifies the behaviors that, when violated by a device (thing), cause an alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder behaviors(Behavior... behaviors);

        /**
         * <p>
         * Specifies the behaviors that, when violated by a device (thing), cause an alert.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Behavior>.Builder} avoiding the need to
         * create one manually via {@link List<Behavior>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Behavior>.Builder#build()} is called immediately and its
         * result is passed to {@link #behaviors(List<Behavior>)}.
         * 
         * @param behaviors
         *        a consumer that will call methods on {@link List<Behavior>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #behaviors(List<Behavior>)
         */
        Builder behaviors(Consumer<Behavior.Builder>... behaviors);

        /**
         * <p>
         * Specifies the destinations to which alerts are sent. (Alerts are always sent to the console.) Alerts are
         * generated when a device (thing) violates a behavior.
         * </p>
         * 
         * @param alertTargets
         *        Specifies the destinations to which alerts are sent. (Alerts are always sent to the console.) Alerts
         *        are generated when a device (thing) violates a behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alertTargetsWithStrings(Map<String, AlertTarget> alertTargets);

        /**
         * <p>
         * Specifies the destinations to which alerts are sent. (Alerts are always sent to the console.) Alerts are
         * generated when a device (thing) violates a behavior.
         * </p>
         * 
         * @param alertTargets
         *        Specifies the destinations to which alerts are sent. (Alerts are always sent to the console.) Alerts
         *        are generated when a device (thing) violates a behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alertTargets(Map<AlertTargetType, AlertTarget> alertTargets);

        /**
         * <p>
         * A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the
         * profile's <code>behaviors</code> but it is also retained for any metric specified here.
         * </p>
         * 
         * @param additionalMetricsToRetain
         *        A list of metrics whose data is retained (stored). By default, data is retained for any metric used in
         *        the profile's <code>behaviors</code> but it is also retained for any metric specified here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalMetricsToRetain(Collection<String> additionalMetricsToRetain);

        /**
         * <p>
         * A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the
         * profile's <code>behaviors</code> but it is also retained for any metric specified here.
         * </p>
         * 
         * @param additionalMetricsToRetain
         *        A list of metrics whose data is retained (stored). By default, data is retained for any metric used in
         *        the profile's <code>behaviors</code> but it is also retained for any metric specified here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalMetricsToRetain(String... additionalMetricsToRetain);

        /**
         * <p>
         * Metadata which can be used to manage the security profile.
         * </p>
         * 
         * @param tags
         *        Metadata which can be used to manage the security profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Metadata which can be used to manage the security profile.
         * </p>
         * 
         * @param tags
         *        Metadata which can be used to manage the security profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Metadata which can be used to manage the security profile.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String securityProfileName;

        private String securityProfileDescription;

        private List<Behavior> behaviors = DefaultSdkAutoConstructList.getInstance();

        private Map<String, AlertTarget> alertTargets = DefaultSdkAutoConstructMap.getInstance();

        private List<String> additionalMetricsToRetain = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSecurityProfileRequest model) {
            super(model);
            securityProfileName(model.securityProfileName);
            securityProfileDescription(model.securityProfileDescription);
            behaviors(model.behaviors);
            alertTargetsWithStrings(model.alertTargets);
            additionalMetricsToRetain(model.additionalMetricsToRetain);
            tags(model.tags);
        }

        public final String getSecurityProfileName() {
            return securityProfileName;
        }

        @Override
        public final Builder securityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
            return this;
        }

        public final void setSecurityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
        }

        public final String getSecurityProfileDescription() {
            return securityProfileDescription;
        }

        @Override
        public final Builder securityProfileDescription(String securityProfileDescription) {
            this.securityProfileDescription = securityProfileDescription;
            return this;
        }

        public final void setSecurityProfileDescription(String securityProfileDescription) {
            this.securityProfileDescription = securityProfileDescription;
        }

        public final Collection<Behavior.Builder> getBehaviors() {
            return behaviors != null ? behaviors.stream().map(Behavior::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder behaviors(Collection<Behavior> behaviors) {
            this.behaviors = BehaviorsCopier.copy(behaviors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder behaviors(Behavior... behaviors) {
            behaviors(Arrays.asList(behaviors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder behaviors(Consumer<Behavior.Builder>... behaviors) {
            behaviors(Stream.of(behaviors).map(c -> Behavior.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBehaviors(Collection<Behavior.BuilderImpl> behaviors) {
            this.behaviors = BehaviorsCopier.copyFromBuilder(behaviors);
        }

        public final Map<String, AlertTarget.Builder> getAlertTargetsAsStrings() {
            return alertTargets != null ? CollectionUtils.mapValues(alertTargets, AlertTarget::toBuilder) : null;
        }

        @Override
        public final Builder alertTargetsWithStrings(Map<String, AlertTarget> alertTargets) {
            this.alertTargets = AlertTargetsCopier.copy(alertTargets);
            return this;
        }

        @Override
        public final Builder alertTargets(Map<AlertTargetType, AlertTarget> alertTargets) {
            this.alertTargets = AlertTargetsCopier.copyEnumToString(alertTargets);
            return this;
        }

        public final void setAlertTargetsWithStrings(Map<String, AlertTarget.BuilderImpl> alertTargets) {
            this.alertTargets = AlertTargetsCopier.copyFromBuilder(alertTargets);
        }

        public final Collection<String> getAdditionalMetricsToRetain() {
            return additionalMetricsToRetain;
        }

        @Override
        public final Builder additionalMetricsToRetain(Collection<String> additionalMetricsToRetain) {
            this.additionalMetricsToRetain = AdditionalMetricsToRetainListCopier.copy(additionalMetricsToRetain);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalMetricsToRetain(String... additionalMetricsToRetain) {
            additionalMetricsToRetain(Arrays.asList(additionalMetricsToRetain));
            return this;
        }

        public final void setAdditionalMetricsToRetain(Collection<String> additionalMetricsToRetain) {
            this.additionalMetricsToRetain = AdditionalMetricsToRetainListCopier.copy(additionalMetricsToRetain);
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSecurityProfileRequest build() {
            return new CreateSecurityProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
