/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Sends messge data to an AWS IoT Analytics channel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IotAnalyticsAction implements SdkPojo, Serializable,
        ToCopyableBuilder<IotAnalyticsAction.Builder, IotAnalyticsAction> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(IotAnalyticsAction::channelArn)).setter(setter(Builder::channelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelArn").build()).build();

    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(IotAnalyticsAction::channelName)).setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelName").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(IotAnalyticsAction::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD,
            CHANNEL_NAME_FIELD, ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String channelArn;

    private final String channelName;

    private final String roleArn;

    private IotAnalyticsAction(BuilderImpl builder) {
        this.channelArn = builder.channelArn;
        this.channelName = builder.channelName;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * (deprecated) The ARN of the IoT Analytics channel to which message data will be sent.
     * </p>
     * 
     * @return (deprecated) The ARN of the IoT Analytics channel to which message data will be sent.
     */
    public String channelArn() {
        return channelArn;
    }

    /**
     * <p>
     * The name of the IoT Analytics channel to which message data will be sent.
     * </p>
     * 
     * @return The name of the IoT Analytics channel to which message data will be sent.
     */
    public String channelName() {
        return channelName;
    }

    /**
     * <p>
     * The ARN of the role which has a policy that grants IoT Analytics permission to send message data via IoT
     * Analytics (iotanalytics:BatchPutMessage).
     * </p>
     * 
     * @return The ARN of the role which has a policy that grants IoT Analytics permission to send message data via IoT
     *         Analytics (iotanalytics:BatchPutMessage).
     */
    public String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IotAnalyticsAction)) {
            return false;
        }
        IotAnalyticsAction other = (IotAnalyticsAction) obj;
        return Objects.equals(channelArn(), other.channelArn()) && Objects.equals(channelName(), other.channelName())
                && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("IotAnalyticsAction").add("ChannelArn", channelArn()).add("ChannelName", channelName())
                .add("RoleArn", roleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "channelArn":
            return Optional.ofNullable(clazz.cast(channelArn()));
        case "channelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IotAnalyticsAction, T> g) {
        return obj -> g.apply((IotAnalyticsAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IotAnalyticsAction> {
        /**
         * <p>
         * (deprecated) The ARN of the IoT Analytics channel to which message data will be sent.
         * </p>
         * 
         * @param channelArn
         *        (deprecated) The ARN of the IoT Analytics channel to which message data will be sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelArn(String channelArn);

        /**
         * <p>
         * The name of the IoT Analytics channel to which message data will be sent.
         * </p>
         * 
         * @param channelName
         *        The name of the IoT Analytics channel to which message data will be sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * <p>
         * The ARN of the role which has a policy that grants IoT Analytics permission to send message data via IoT
         * Analytics (iotanalytics:BatchPutMessage).
         * </p>
         * 
         * @param roleArn
         *        The ARN of the role which has a policy that grants IoT Analytics permission to send message data via
         *        IoT Analytics (iotanalytics:BatchPutMessage).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private String channelArn;

        private String channelName;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(IotAnalyticsAction model) {
            channelArn(model.channelArn);
            channelName(model.channelName);
            roleArn(model.roleArn);
        }

        public final String getChannelArn() {
            return channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        public final String getChannelName() {
            return channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public IotAnalyticsAction build() {
            return new IotAnalyticsAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
