/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The findings (results) of the audit.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuditFinding implements SdkPojo, Serializable, ToCopyableBuilder<AuditFinding.Builder, AuditFinding> {
    private static final SdkField<String> FINDING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AuditFinding::findingId)).setter(setter(Builder::findingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingId").build()).build();

    private static final SdkField<String> TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AuditFinding::taskId)).setter(setter(Builder::taskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()).build();

    private static final SdkField<String> CHECK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AuditFinding::checkName)).setter(setter(Builder::checkName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkName").build()).build();

    private static final SdkField<Instant> TASK_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(AuditFinding::taskStartTime)).setter(setter(Builder::taskStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskStartTime").build()).build();

    private static final SdkField<Instant> FINDING_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(AuditFinding::findingTime)).setter(setter(Builder::findingTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingTime").build()).build();

    private static final SdkField<String> SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AuditFinding::severityAsString)).setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severity").build()).build();

    private static final SdkField<NonCompliantResource> NON_COMPLIANT_RESOURCE_FIELD = SdkField
            .<NonCompliantResource> builder(MarshallingType.SDK_POJO).getter(getter(AuditFinding::nonCompliantResource))
            .setter(setter(Builder::nonCompliantResource)).constructor(NonCompliantResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nonCompliantResource").build())
            .build();

    private static final SdkField<List<RelatedResource>> RELATED_RESOURCES_FIELD = SdkField
            .<List<RelatedResource>> builder(MarshallingType.LIST)
            .getter(getter(AuditFinding::relatedResources))
            .setter(setter(Builder::relatedResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RelatedResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(RelatedResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REASON_FOR_NON_COMPLIANCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AuditFinding::reasonForNonCompliance)).setter(setter(Builder::reasonForNonCompliance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reasonForNonCompliance").build())
            .build();

    private static final SdkField<String> REASON_FOR_NON_COMPLIANCE_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(AuditFinding::reasonForNonComplianceCode))
            .setter(setter(Builder::reasonForNonComplianceCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reasonForNonComplianceCode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_ID_FIELD,
            TASK_ID_FIELD, CHECK_NAME_FIELD, TASK_START_TIME_FIELD, FINDING_TIME_FIELD, SEVERITY_FIELD,
            NON_COMPLIANT_RESOURCE_FIELD, RELATED_RESOURCES_FIELD, REASON_FOR_NON_COMPLIANCE_FIELD,
            REASON_FOR_NON_COMPLIANCE_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String findingId;

    private final String taskId;

    private final String checkName;

    private final Instant taskStartTime;

    private final Instant findingTime;

    private final String severity;

    private final NonCompliantResource nonCompliantResource;

    private final List<RelatedResource> relatedResources;

    private final String reasonForNonCompliance;

    private final String reasonForNonComplianceCode;

    private AuditFinding(BuilderImpl builder) {
        this.findingId = builder.findingId;
        this.taskId = builder.taskId;
        this.checkName = builder.checkName;
        this.taskStartTime = builder.taskStartTime;
        this.findingTime = builder.findingTime;
        this.severity = builder.severity;
        this.nonCompliantResource = builder.nonCompliantResource;
        this.relatedResources = builder.relatedResources;
        this.reasonForNonCompliance = builder.reasonForNonCompliance;
        this.reasonForNonComplianceCode = builder.reasonForNonComplianceCode;
    }

    /**
     * <p>
     * A unique identifier for this set of audit findings. This identifier is used to apply mitigation tasks to one or
     * more sets of findings.
     * </p>
     * 
     * @return A unique identifier for this set of audit findings. This identifier is used to apply mitigation tasks to
     *         one or more sets of findings.
     */
    public String findingId() {
        return findingId;
    }

    /**
     * <p>
     * The ID of the audit that generated this result (finding).
     * </p>
     * 
     * @return The ID of the audit that generated this result (finding).
     */
    public String taskId() {
        return taskId;
    }

    /**
     * <p>
     * The audit check that generated this result.
     * </p>
     * 
     * @return The audit check that generated this result.
     */
    public String checkName() {
        return checkName;
    }

    /**
     * <p>
     * The time the audit started.
     * </p>
     * 
     * @return The time the audit started.
     */
    public Instant taskStartTime() {
        return taskStartTime;
    }

    /**
     * <p>
     * The time the result (finding) was discovered.
     * </p>
     * 
     * @return The time the result (finding) was discovered.
     */
    public Instant findingTime() {
        return findingTime;
    }

    /**
     * <p>
     * The severity of the result (finding).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link AuditFindingSeverity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #severityAsString}.
     * </p>
     * 
     * @return The severity of the result (finding).
     * @see AuditFindingSeverity
     */
    public AuditFindingSeverity severity() {
        return AuditFindingSeverity.fromValue(severity);
    }

    /**
     * <p>
     * The severity of the result (finding).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link AuditFindingSeverity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #severityAsString}.
     * </p>
     * 
     * @return The severity of the result (finding).
     * @see AuditFindingSeverity
     */
    public String severityAsString() {
        return severity;
    }

    /**
     * <p>
     * The resource that was found to be noncompliant with the audit check.
     * </p>
     * 
     * @return The resource that was found to be noncompliant with the audit check.
     */
    public NonCompliantResource nonCompliantResource() {
        return nonCompliantResource;
    }

    /**
     * <p>
     * The list of related resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of related resources.
     */
    public List<RelatedResource> relatedResources() {
        return relatedResources;
    }

    /**
     * <p>
     * The reason the resource was noncompliant.
     * </p>
     * 
     * @return The reason the resource was noncompliant.
     */
    public String reasonForNonCompliance() {
        return reasonForNonCompliance;
    }

    /**
     * <p>
     * A code that indicates the reason that the resource was noncompliant.
     * </p>
     * 
     * @return A code that indicates the reason that the resource was noncompliant.
     */
    public String reasonForNonComplianceCode() {
        return reasonForNonComplianceCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(findingId());
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        hashCode = 31 * hashCode + Objects.hashCode(checkName());
        hashCode = 31 * hashCode + Objects.hashCode(taskStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(findingTime());
        hashCode = 31 * hashCode + Objects.hashCode(severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nonCompliantResource());
        hashCode = 31 * hashCode + Objects.hashCode(relatedResources());
        hashCode = 31 * hashCode + Objects.hashCode(reasonForNonCompliance());
        hashCode = 31 * hashCode + Objects.hashCode(reasonForNonComplianceCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditFinding)) {
            return false;
        }
        AuditFinding other = (AuditFinding) obj;
        return Objects.equals(findingId(), other.findingId()) && Objects.equals(taskId(), other.taskId())
                && Objects.equals(checkName(), other.checkName()) && Objects.equals(taskStartTime(), other.taskStartTime())
                && Objects.equals(findingTime(), other.findingTime())
                && Objects.equals(severityAsString(), other.severityAsString())
                && Objects.equals(nonCompliantResource(), other.nonCompliantResource())
                && Objects.equals(relatedResources(), other.relatedResources())
                && Objects.equals(reasonForNonCompliance(), other.reasonForNonCompliance())
                && Objects.equals(reasonForNonComplianceCode(), other.reasonForNonComplianceCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AuditFinding").add("FindingId", findingId()).add("TaskId", taskId())
                .add("CheckName", checkName()).add("TaskStartTime", taskStartTime()).add("FindingTime", findingTime())
                .add("Severity", severityAsString()).add("NonCompliantResource", nonCompliantResource())
                .add("RelatedResources", relatedResources()).add("ReasonForNonCompliance", reasonForNonCompliance())
                .add("ReasonForNonComplianceCode", reasonForNonComplianceCode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "findingId":
            return Optional.ofNullable(clazz.cast(findingId()));
        case "taskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        case "checkName":
            return Optional.ofNullable(clazz.cast(checkName()));
        case "taskStartTime":
            return Optional.ofNullable(clazz.cast(taskStartTime()));
        case "findingTime":
            return Optional.ofNullable(clazz.cast(findingTime()));
        case "severity":
            return Optional.ofNullable(clazz.cast(severityAsString()));
        case "nonCompliantResource":
            return Optional.ofNullable(clazz.cast(nonCompliantResource()));
        case "relatedResources":
            return Optional.ofNullable(clazz.cast(relatedResources()));
        case "reasonForNonCompliance":
            return Optional.ofNullable(clazz.cast(reasonForNonCompliance()));
        case "reasonForNonComplianceCode":
            return Optional.ofNullable(clazz.cast(reasonForNonComplianceCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuditFinding, T> g) {
        return obj -> g.apply((AuditFinding) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuditFinding> {
        /**
         * <p>
         * A unique identifier for this set of audit findings. This identifier is used to apply mitigation tasks to one
         * or more sets of findings.
         * </p>
         * 
         * @param findingId
         *        A unique identifier for this set of audit findings. This identifier is used to apply mitigation tasks
         *        to one or more sets of findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingId(String findingId);

        /**
         * <p>
         * The ID of the audit that generated this result (finding).
         * </p>
         * 
         * @param taskId
         *        The ID of the audit that generated this result (finding).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);

        /**
         * <p>
         * The audit check that generated this result.
         * </p>
         * 
         * @param checkName
         *        The audit check that generated this result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkName(String checkName);

        /**
         * <p>
         * The time the audit started.
         * </p>
         * 
         * @param taskStartTime
         *        The time the audit started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskStartTime(Instant taskStartTime);

        /**
         * <p>
         * The time the result (finding) was discovered.
         * </p>
         * 
         * @param findingTime
         *        The time the result (finding) was discovered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingTime(Instant findingTime);

        /**
         * <p>
         * The severity of the result (finding).
         * </p>
         * 
         * @param severity
         *        The severity of the result (finding).
         * @see AuditFindingSeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuditFindingSeverity
         */
        Builder severity(String severity);

        /**
         * <p>
         * The severity of the result (finding).
         * </p>
         * 
         * @param severity
         *        The severity of the result (finding).
         * @see AuditFindingSeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuditFindingSeverity
         */
        Builder severity(AuditFindingSeverity severity);

        /**
         * <p>
         * The resource that was found to be noncompliant with the audit check.
         * </p>
         * 
         * @param nonCompliantResource
         *        The resource that was found to be noncompliant with the audit check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonCompliantResource(NonCompliantResource nonCompliantResource);

        /**
         * <p>
         * The resource that was found to be noncompliant with the audit check.
         * </p>
         * This is a convenience that creates an instance of the {@link NonCompliantResource.Builder} avoiding the need
         * to create one manually via {@link NonCompliantResource#builder()}.
         *
         * When the {@link Consumer} completes, {@link NonCompliantResource.Builder#build()} is called immediately and
         * its result is passed to {@link #nonCompliantResource(NonCompliantResource)}.
         * 
         * @param nonCompliantResource
         *        a consumer that will call methods on {@link NonCompliantResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nonCompliantResource(NonCompliantResource)
         */
        default Builder nonCompliantResource(Consumer<NonCompliantResource.Builder> nonCompliantResource) {
            return nonCompliantResource(NonCompliantResource.builder().applyMutation(nonCompliantResource).build());
        }

        /**
         * <p>
         * The list of related resources.
         * </p>
         * 
         * @param relatedResources
         *        The list of related resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedResources(Collection<RelatedResource> relatedResources);

        /**
         * <p>
         * The list of related resources.
         * </p>
         * 
         * @param relatedResources
         *        The list of related resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedResources(RelatedResource... relatedResources);

        /**
         * <p>
         * The list of related resources.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RelatedResource>.Builder} avoiding the need
         * to create one manually via {@link List<RelatedResource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RelatedResource>.Builder#build()} is called immediately and
         * its result is passed to {@link #relatedResources(List<RelatedResource>)}.
         * 
         * @param relatedResources
         *        a consumer that will call methods on {@link List<RelatedResource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relatedResources(List<RelatedResource>)
         */
        Builder relatedResources(Consumer<RelatedResource.Builder>... relatedResources);

        /**
         * <p>
         * The reason the resource was noncompliant.
         * </p>
         * 
         * @param reasonForNonCompliance
         *        The reason the resource was noncompliant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasonForNonCompliance(String reasonForNonCompliance);

        /**
         * <p>
         * A code that indicates the reason that the resource was noncompliant.
         * </p>
         * 
         * @param reasonForNonComplianceCode
         *        A code that indicates the reason that the resource was noncompliant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasonForNonComplianceCode(String reasonForNonComplianceCode);
    }

    static final class BuilderImpl implements Builder {
        private String findingId;

        private String taskId;

        private String checkName;

        private Instant taskStartTime;

        private Instant findingTime;

        private String severity;

        private NonCompliantResource nonCompliantResource;

        private List<RelatedResource> relatedResources = DefaultSdkAutoConstructList.getInstance();

        private String reasonForNonCompliance;

        private String reasonForNonComplianceCode;

        private BuilderImpl() {
        }

        private BuilderImpl(AuditFinding model) {
            findingId(model.findingId);
            taskId(model.taskId);
            checkName(model.checkName);
            taskStartTime(model.taskStartTime);
            findingTime(model.findingTime);
            severity(model.severity);
            nonCompliantResource(model.nonCompliantResource);
            relatedResources(model.relatedResources);
            reasonForNonCompliance(model.reasonForNonCompliance);
            reasonForNonComplianceCode(model.reasonForNonComplianceCode);
        }

        public final String getFindingId() {
            return findingId;
        }

        @Override
        public final Builder findingId(String findingId) {
            this.findingId = findingId;
            return this;
        }

        public final void setFindingId(String findingId) {
            this.findingId = findingId;
        }

        public final String getTaskId() {
            return taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public final String getCheckName() {
            return checkName;
        }

        @Override
        public final Builder checkName(String checkName) {
            this.checkName = checkName;
            return this;
        }

        public final void setCheckName(String checkName) {
            this.checkName = checkName;
        }

        public final Instant getTaskStartTime() {
            return taskStartTime;
        }

        @Override
        public final Builder taskStartTime(Instant taskStartTime) {
            this.taskStartTime = taskStartTime;
            return this;
        }

        public final void setTaskStartTime(Instant taskStartTime) {
            this.taskStartTime = taskStartTime;
        }

        public final Instant getFindingTime() {
            return findingTime;
        }

        @Override
        public final Builder findingTime(Instant findingTime) {
            this.findingTime = findingTime;
            return this;
        }

        public final void setFindingTime(Instant findingTime) {
            this.findingTime = findingTime;
        }

        public final String getSeverityAsString() {
            return severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(AuditFindingSeverity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        public final NonCompliantResource.Builder getNonCompliantResource() {
            return nonCompliantResource != null ? nonCompliantResource.toBuilder() : null;
        }

        @Override
        public final Builder nonCompliantResource(NonCompliantResource nonCompliantResource) {
            this.nonCompliantResource = nonCompliantResource;
            return this;
        }

        public final void setNonCompliantResource(NonCompliantResource.BuilderImpl nonCompliantResource) {
            this.nonCompliantResource = nonCompliantResource != null ? nonCompliantResource.build() : null;
        }

        public final Collection<RelatedResource.Builder> getRelatedResources() {
            return relatedResources != null ? relatedResources.stream().map(RelatedResource::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder relatedResources(Collection<RelatedResource> relatedResources) {
            this.relatedResources = RelatedResourcesCopier.copy(relatedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedResources(RelatedResource... relatedResources) {
            relatedResources(Arrays.asList(relatedResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedResources(Consumer<RelatedResource.Builder>... relatedResources) {
            relatedResources(Stream.of(relatedResources).map(c -> RelatedResource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRelatedResources(Collection<RelatedResource.BuilderImpl> relatedResources) {
            this.relatedResources = RelatedResourcesCopier.copyFromBuilder(relatedResources);
        }

        public final String getReasonForNonCompliance() {
            return reasonForNonCompliance;
        }

        @Override
        public final Builder reasonForNonCompliance(String reasonForNonCompliance) {
            this.reasonForNonCompliance = reasonForNonCompliance;
            return this;
        }

        public final void setReasonForNonCompliance(String reasonForNonCompliance) {
            this.reasonForNonCompliance = reasonForNonCompliance;
        }

        public final String getReasonForNonComplianceCode() {
            return reasonForNonComplianceCode;
        }

        @Override
        public final Builder reasonForNonComplianceCode(String reasonForNonComplianceCode) {
            this.reasonForNonComplianceCode = reasonForNonComplianceCode;
            return this;
        }

        public final void setReasonForNonComplianceCode(String reasonForNonComplianceCode) {
            this.reasonForNonComplianceCode = reasonForNonComplianceCode;
        }

        @Override
        public AuditFinding build() {
            return new AuditFinding(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
