/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAuditMitigationActionsExecutionsRequest extends IotRequest implements
        ToCopyableBuilder<ListAuditMitigationActionsExecutionsRequest.Builder, ListAuditMitigationActionsExecutionsRequest> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListAuditMitigationActionsExecutionsRequest::taskId)).setter(setter(Builder::taskId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("taskId").build()).build();

    private static final SdkField<String> ACTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListAuditMitigationActionsExecutionsRequest::actionStatusAsString))
            .setter(setter(Builder::actionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("actionStatus").build()).build();

    private static final SdkField<String> FINDING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListAuditMitigationActionsExecutionsRequest::findingId)).setter(setter(Builder::findingId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("findingId").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListAuditMitigationActionsExecutionsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListAuditMitigationActionsExecutionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD,
            ACTION_STATUS_FIELD, FINDING_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String taskId;

    private final String actionStatus;

    private final String findingId;

    private final Integer maxResults;

    private final String nextToken;

    private ListAuditMitigationActionsExecutionsRequest(BuilderImpl builder) {
        super(builder);
        this.taskId = builder.taskId;
        this.actionStatus = builder.actionStatus;
        this.findingId = builder.findingId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Specify this filter to limit results to actions for a specific audit mitigation actions task.
     * </p>
     * 
     * @return Specify this filter to limit results to actions for a specific audit mitigation actions task.
     */
    public String taskId() {
        return taskId;
    }

    /**
     * <p>
     * Specify this filter to limit results to those with a specific status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionStatus} will
     * return {@link AuditMitigationActionsExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #actionStatusAsString}.
     * </p>
     * 
     * @return Specify this filter to limit results to those with a specific status.
     * @see AuditMitigationActionsExecutionStatus
     */
    public AuditMitigationActionsExecutionStatus actionStatus() {
        return AuditMitigationActionsExecutionStatus.fromValue(actionStatus);
    }

    /**
     * <p>
     * Specify this filter to limit results to those with a specific status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionStatus} will
     * return {@link AuditMitigationActionsExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #actionStatusAsString}.
     * </p>
     * 
     * @return Specify this filter to limit results to those with a specific status.
     * @see AuditMitigationActionsExecutionStatus
     */
    public String actionStatusAsString() {
        return actionStatus;
    }

    /**
     * <p>
     * Specify this filter to limit results to those that were applied to a specific audit finding.
     * </p>
     * 
     * @return Specify this filter to limit results to those that were applied to a specific audit finding.
     */
    public String findingId() {
        return findingId;
    }

    /**
     * <p>
     * The maximum number of results to return at one time. The default is 25.
     * </p>
     * 
     * @return The maximum number of results to return at one time. The default is 25.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of results.
     * </p>
     * 
     * @return The token for the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        hashCode = 31 * hashCode + Objects.hashCode(actionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(findingId());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAuditMitigationActionsExecutionsRequest)) {
            return false;
        }
        ListAuditMitigationActionsExecutionsRequest other = (ListAuditMitigationActionsExecutionsRequest) obj;
        return Objects.equals(taskId(), other.taskId()) && Objects.equals(actionStatusAsString(), other.actionStatusAsString())
                && Objects.equals(findingId(), other.findingId()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListAuditMitigationActionsExecutionsRequest").add("TaskId", taskId())
                .add("ActionStatus", actionStatusAsString()).add("FindingId", findingId()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        case "actionStatus":
            return Optional.ofNullable(clazz.cast(actionStatusAsString()));
        case "findingId":
            return Optional.ofNullable(clazz.cast(findingId()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAuditMitigationActionsExecutionsRequest, T> g) {
        return obj -> g.apply((ListAuditMitigationActionsExecutionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAuditMitigationActionsExecutionsRequest> {
        /**
         * <p>
         * Specify this filter to limit results to actions for a specific audit mitigation actions task.
         * </p>
         * 
         * @param taskId
         *        Specify this filter to limit results to actions for a specific audit mitigation actions task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);

        /**
         * <p>
         * Specify this filter to limit results to those with a specific status.
         * </p>
         * 
         * @param actionStatus
         *        Specify this filter to limit results to those with a specific status.
         * @see AuditMitigationActionsExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuditMitigationActionsExecutionStatus
         */
        Builder actionStatus(String actionStatus);

        /**
         * <p>
         * Specify this filter to limit results to those with a specific status.
         * </p>
         * 
         * @param actionStatus
         *        Specify this filter to limit results to those with a specific status.
         * @see AuditMitigationActionsExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuditMitigationActionsExecutionStatus
         */
        Builder actionStatus(AuditMitigationActionsExecutionStatus actionStatus);

        /**
         * <p>
         * Specify this filter to limit results to those that were applied to a specific audit finding.
         * </p>
         * 
         * @param findingId
         *        Specify this filter to limit results to those that were applied to a specific audit finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingId(String findingId);

        /**
         * <p>
         * The maximum number of results to return at one time. The default is 25.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return at one time. The default is 25.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String taskId;

        private String actionStatus;

        private String findingId;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAuditMitigationActionsExecutionsRequest model) {
            super(model);
            taskId(model.taskId);
            actionStatus(model.actionStatus);
            findingId(model.findingId);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getTaskId() {
            return taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public final String getActionStatusAsString() {
            return actionStatus;
        }

        @Override
        public final Builder actionStatus(String actionStatus) {
            this.actionStatus = actionStatus;
            return this;
        }

        @Override
        public final Builder actionStatus(AuditMitigationActionsExecutionStatus actionStatus) {
            this.actionStatus(actionStatus == null ? null : actionStatus.toString());
            return this;
        }

        public final void setActionStatus(String actionStatus) {
            this.actionStatus = actionStatus;
        }

        public final String getFindingId() {
            return findingId;
        }

        @Override
        public final Builder findingId(String findingId) {
            this.findingId = findingId;
            return this;
        }

        public final void setFindingId(String findingId) {
            this.findingId = findingId;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAuditMitigationActionsExecutionsRequest build() {
            return new ListAuditMitigationActionsExecutionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
