/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSecurityProfilesResponse extends IotResponse implements
        ToCopyableBuilder<ListSecurityProfilesResponse.Builder, ListSecurityProfilesResponse> {
    private static final SdkField<List<SecurityProfileIdentifier>> SECURITY_PROFILE_IDENTIFIERS_FIELD = SdkField
            .<List<SecurityProfileIdentifier>> builder(MarshallingType.LIST)
            .getter(getter(ListSecurityProfilesResponse::securityProfileIdentifiers))
            .setter(setter(Builder::securityProfileIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityProfileIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SecurityProfileIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(SecurityProfileIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListSecurityProfilesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SECURITY_PROFILE_IDENTIFIERS_FIELD, NEXT_TOKEN_FIELD));

    private final List<SecurityProfileIdentifier> securityProfileIdentifiers;

    private final String nextToken;

    private ListSecurityProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.securityProfileIdentifiers = builder.securityProfileIdentifiers;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of security profile identifiers (names and ARNs).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of security profile identifiers (names and ARNs).
     */
    public List<SecurityProfileIdentifier> securityProfileIdentifiers() {
        return securityProfileIdentifiers;
    }

    /**
     * <p>
     * A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional
     * results.
     * </p>
     * 
     * @return A token that can be used to retrieve the next set of results, or <code>null</code> if there are no
     *         additional results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(securityProfileIdentifiers());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSecurityProfilesResponse)) {
            return false;
        }
        ListSecurityProfilesResponse other = (ListSecurityProfilesResponse) obj;
        return Objects.equals(securityProfileIdentifiers(), other.securityProfileIdentifiers())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListSecurityProfilesResponse").add("SecurityProfileIdentifiers", securityProfileIdentifiers())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "securityProfileIdentifiers":
            return Optional.ofNullable(clazz.cast(securityProfileIdentifiers()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSecurityProfilesResponse, T> g) {
        return obj -> g.apply((ListSecurityProfilesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSecurityProfilesResponse> {
        /**
         * <p>
         * A list of security profile identifiers (names and ARNs).
         * </p>
         * 
         * @param securityProfileIdentifiers
         *        A list of security profile identifiers (names and ARNs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileIdentifiers(Collection<SecurityProfileIdentifier> securityProfileIdentifiers);

        /**
         * <p>
         * A list of security profile identifiers (names and ARNs).
         * </p>
         * 
         * @param securityProfileIdentifiers
         *        A list of security profile identifiers (names and ARNs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileIdentifiers(SecurityProfileIdentifier... securityProfileIdentifiers);

        /**
         * <p>
         * A list of security profile identifiers (names and ARNs).
         * </p>
         * This is a convenience that creates an instance of the {@link List<SecurityProfileIdentifier>.Builder}
         * avoiding the need to create one manually via {@link List<SecurityProfileIdentifier>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SecurityProfileIdentifier>.Builder#build()} is called
         * immediately and its result is passed to {@link #securityProfileIdentifiers(List<SecurityProfileIdentifier>)}.
         * 
         * @param securityProfileIdentifiers
         *        a consumer that will call methods on {@link List<SecurityProfileIdentifier>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityProfileIdentifiers(List<SecurityProfileIdentifier>)
         */
        Builder securityProfileIdentifiers(Consumer<SecurityProfileIdentifier.Builder>... securityProfileIdentifiers);

        /**
         * <p>
         * A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional
         * results.
         * </p>
         * 
         * @param nextToken
         *        A token that can be used to retrieve the next set of results, or <code>null</code> if there are no
         *        additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<SecurityProfileIdentifier> securityProfileIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSecurityProfilesResponse model) {
            super(model);
            securityProfileIdentifiers(model.securityProfileIdentifiers);
            nextToken(model.nextToken);
        }

        public final Collection<SecurityProfileIdentifier.Builder> getSecurityProfileIdentifiers() {
            return securityProfileIdentifiers != null ? securityProfileIdentifiers.stream()
                    .map(SecurityProfileIdentifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder securityProfileIdentifiers(Collection<SecurityProfileIdentifier> securityProfileIdentifiers) {
            this.securityProfileIdentifiers = SecurityProfileIdentifiersCopier.copy(securityProfileIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityProfileIdentifiers(SecurityProfileIdentifier... securityProfileIdentifiers) {
            securityProfileIdentifiers(Arrays.asList(securityProfileIdentifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityProfileIdentifiers(Consumer<SecurityProfileIdentifier.Builder>... securityProfileIdentifiers) {
            securityProfileIdentifiers(Stream.of(securityProfileIdentifiers)
                    .map(c -> SecurityProfileIdentifier.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSecurityProfileIdentifiers(
                Collection<SecurityProfileIdentifier.BuilderImpl> securityProfileIdentifiers) {
            this.securityProfileIdentifiers = SecurityProfileIdentifiersCopier.copyFromBuilder(securityProfileIdentifiers);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSecurityProfilesResponse build() {
            return new ListSecurityProfilesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
