/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCertificateFromCsrResponse
extends IotResponse
implements ToCopyableBuilder<Builder, CreateCertificateFromCsrResponse> {
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCertificateFromCsrResponse.getter(CreateCertificateFromCsrResponse::certificateArn)).setter(CreateCertificateFromCsrResponse.setter(Builder::certificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateArn").build()}).build();
    private static final SdkField<String> CERTIFICATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCertificateFromCsrResponse.getter(CreateCertificateFromCsrResponse::certificateId)).setter(CreateCertificateFromCsrResponse.setter(Builder::certificateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateId").build()}).build();
    private static final SdkField<String> CERTIFICATE_PEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCertificateFromCsrResponse.getter(CreateCertificateFromCsrResponse::certificatePem)).setter(CreateCertificateFromCsrResponse.setter(Builder::certificatePem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificatePem").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ARN_FIELD, CERTIFICATE_ID_FIELD, CERTIFICATE_PEM_FIELD));
    private final String certificateArn;
    private final String certificateId;
    private final String certificatePem;

    private CreateCertificateFromCsrResponse(BuilderImpl builder) {
        super(builder);
        this.certificateArn = builder.certificateArn;
        this.certificateId = builder.certificateId;
        this.certificatePem = builder.certificatePem;
    }

    public String certificateArn() {
        return this.certificateArn;
    }

    public String certificateId() {
        return this.certificateId;
    }

    public String certificatePem() {
        return this.certificatePem;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificatePem());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCertificateFromCsrResponse)) {
            return false;
        }
        CreateCertificateFromCsrResponse other = (CreateCertificateFromCsrResponse)((Object)obj);
        return Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.certificateId(), other.certificateId()) && Objects.equals(this.certificatePem(), other.certificatePem());
    }

    public String toString() {
        return ToString.builder((String)"CreateCertificateFromCsrResponse").add("CertificateArn", (Object)this.certificateArn()).add("CertificateId", (Object)this.certificateId()).add("CertificatePem", (Object)this.certificatePem()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
            case "certificateId": {
                return Optional.ofNullable(clazz.cast(this.certificateId()));
            }
            case "certificatePem": {
                return Optional.ofNullable(clazz.cast(this.certificatePem()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCertificateFromCsrResponse, T> g) {
        return obj -> g.apply((CreateCertificateFromCsrResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String certificateArn;
        private String certificateId;
        private String certificatePem;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCertificateFromCsrResponse model) {
            super(model);
            this.certificateArn(model.certificateArn);
            this.certificateId(model.certificateId);
            this.certificatePem(model.certificatePem);
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getCertificateId() {
            return this.certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final String getCertificatePem() {
            return this.certificatePem;
        }

        @Override
        public final Builder certificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
            return this;
        }

        public final void setCertificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
        }

        @Override
        public CreateCertificateFromCsrResponse build() {
            return new CreateCertificateFromCsrResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCertificateFromCsrResponse> {
        public Builder certificateArn(String var1);

        public Builder certificateId(String var1);

        public Builder certificatePem(String var1);
    }
}

