/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters to define a mitigation action that adds a blank policy to restrict permissions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplaceDefaultPolicyVersionParams implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplaceDefaultPolicyVersionParams.Builder, ReplaceDefaultPolicyVersionParams> {
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReplaceDefaultPolicyVersionParams::templateNameAsString)).setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String templateName;

    private ReplaceDefaultPolicyVersionParams(BuilderImpl builder) {
        this.templateName = builder.templateName;
    }

    /**
     * <p>
     * The name of the template to be applied. The only supported value is <code>BLANK_POLICY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #templateName} will
     * return {@link PolicyTemplateName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #templateNameAsString}.
     * </p>
     * 
     * @return The name of the template to be applied. The only supported value is <code>BLANK_POLICY</code>.
     * @see PolicyTemplateName
     */
    public PolicyTemplateName templateName() {
        return PolicyTemplateName.fromValue(templateName);
    }

    /**
     * <p>
     * The name of the template to be applied. The only supported value is <code>BLANK_POLICY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #templateName} will
     * return {@link PolicyTemplateName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #templateNameAsString}.
     * </p>
     * 
     * @return The name of the template to be applied. The only supported value is <code>BLANK_POLICY</code>.
     * @see PolicyTemplateName
     */
    public String templateNameAsString() {
        return templateName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(templateNameAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplaceDefaultPolicyVersionParams)) {
            return false;
        }
        ReplaceDefaultPolicyVersionParams other = (ReplaceDefaultPolicyVersionParams) obj;
        return Objects.equals(templateNameAsString(), other.templateNameAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ReplaceDefaultPolicyVersionParams").add("TemplateName", templateNameAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "templateName":
            return Optional.ofNullable(clazz.cast(templateNameAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplaceDefaultPolicyVersionParams, T> g) {
        return obj -> g.apply((ReplaceDefaultPolicyVersionParams) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplaceDefaultPolicyVersionParams> {
        /**
         * <p>
         * The name of the template to be applied. The only supported value is <code>BLANK_POLICY</code>.
         * </p>
         * 
         * @param templateName
         *        The name of the template to be applied. The only supported value is <code>BLANK_POLICY</code>.
         * @see PolicyTemplateName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyTemplateName
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * The name of the template to be applied. The only supported value is <code>BLANK_POLICY</code>.
         * </p>
         * 
         * @param templateName
         *        The name of the template to be applied. The only supported value is <code>BLANK_POLICY</code>.
         * @see PolicyTemplateName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyTemplateName
         */
        Builder templateName(PolicyTemplateName templateName);
    }

    static final class BuilderImpl implements Builder {
        private String templateName;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplaceDefaultPolicyVersionParams model) {
            templateName(model.templateName);
        }

        public final String getTemplateNameAsString() {
            return templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        @Override
        public final Builder templateName(PolicyTemplateName templateName) {
            this.templateName(templateName == null ? null : templateName.toString());
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public ReplaceDefaultPolicyVersionParams build() {
            return new ReplaceDefaultPolicyVersionParams(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
