/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot1clickdevices;

import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.iot1clickdevices.Iot1ClickDevicesAsyncClient;
import software.amazon.awssdk.services.iot1clickdevices.model.ClaimDevicesByClaimCodeRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.ClaimDevicesByClaimCodeResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.DescribeDeviceRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.DescribeDeviceResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.FinalizeDeviceClaimRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.FinalizeDeviceClaimResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.ForbiddenException;
import software.amazon.awssdk.services.iot1clickdevices.model.GetDeviceMethodsRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.GetDeviceMethodsResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.InitiateDeviceClaimRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.InitiateDeviceClaimResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.InternalFailureException;
import software.amazon.awssdk.services.iot1clickdevices.model.InvalidRequestException;
import software.amazon.awssdk.services.iot1clickdevices.model.InvokeDeviceMethodRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.InvokeDeviceMethodResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.Iot1ClickDevicesException;
import software.amazon.awssdk.services.iot1clickdevices.model.ListDeviceEventsRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.ListDeviceEventsResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.ListDevicesRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.ListDevicesResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.PreconditionFailedException;
import software.amazon.awssdk.services.iot1clickdevices.model.RangeNotSatisfiableException;
import software.amazon.awssdk.services.iot1clickdevices.model.ResourceConflictException;
import software.amazon.awssdk.services.iot1clickdevices.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iot1clickdevices.model.TagResourceRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.TagResourceResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.UnclaimDeviceRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.UnclaimDeviceResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.UntagResourceRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.UntagResourceResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.UpdateDeviceStateRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.UpdateDeviceStateResponse;
import software.amazon.awssdk.services.iot1clickdevices.transform.ClaimDevicesByClaimCodeRequestMarshaller;
import software.amazon.awssdk.services.iot1clickdevices.transform.DescribeDeviceRequestMarshaller;
import software.amazon.awssdk.services.iot1clickdevices.transform.FinalizeDeviceClaimRequestMarshaller;
import software.amazon.awssdk.services.iot1clickdevices.transform.GetDeviceMethodsRequestMarshaller;
import software.amazon.awssdk.services.iot1clickdevices.transform.InitiateDeviceClaimRequestMarshaller;
import software.amazon.awssdk.services.iot1clickdevices.transform.InvokeDeviceMethodRequestMarshaller;
import software.amazon.awssdk.services.iot1clickdevices.transform.ListDeviceEventsRequestMarshaller;
import software.amazon.awssdk.services.iot1clickdevices.transform.ListDevicesRequestMarshaller;
import software.amazon.awssdk.services.iot1clickdevices.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.iot1clickdevices.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.iot1clickdevices.transform.UnclaimDeviceRequestMarshaller;
import software.amazon.awssdk.services.iot1clickdevices.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.iot1clickdevices.transform.UpdateDeviceStateRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultIot1ClickDevicesAsyncClient
implements Iot1ClickDevicesAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultIot1ClickDevicesAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultIot1ClickDevicesAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "iot1click";
    }

    @Override
    public CompletableFuture<ClaimDevicesByClaimCodeResponse> claimDevicesByClaimCode(ClaimDevicesByClaimCodeRequest claimDevicesByClaimCodeRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ClaimDevicesByClaimCodeResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ClaimDevicesByClaimCode").withMarshaller((Marshaller)new ClaimDevicesByClaimCodeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)claimDevicesByClaimCodeRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDeviceResponse> describeDevice(DescribeDeviceRequest describeDeviceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDeviceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDevice").withMarshaller((Marshaller)new DescribeDeviceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDeviceRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<FinalizeDeviceClaimResponse> finalizeDeviceClaim(FinalizeDeviceClaimRequest finalizeDeviceClaimRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, FinalizeDeviceClaimResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("FinalizeDeviceClaim").withMarshaller((Marshaller)new FinalizeDeviceClaimRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)finalizeDeviceClaimRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDeviceMethodsResponse> getDeviceMethods(GetDeviceMethodsRequest getDeviceMethodsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDeviceMethodsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDeviceMethods").withMarshaller((Marshaller)new GetDeviceMethodsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDeviceMethodsRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<InitiateDeviceClaimResponse> initiateDeviceClaim(InitiateDeviceClaimRequest initiateDeviceClaimRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, InitiateDeviceClaimResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("InitiateDeviceClaim").withMarshaller((Marshaller)new InitiateDeviceClaimRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)initiateDeviceClaimRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<InvokeDeviceMethodResponse> invokeDeviceMethod(InvokeDeviceMethodRequest invokeDeviceMethodRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, InvokeDeviceMethodResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("InvokeDeviceMethod").withMarshaller((Marshaller)new InvokeDeviceMethodRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)invokeDeviceMethodRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListDeviceEventsResponse> listDeviceEvents(ListDeviceEventsRequest listDeviceEventsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDeviceEventsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDeviceEvents").withMarshaller((Marshaller)new ListDeviceEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDeviceEventsRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListDevicesResponse> listDevices(ListDevicesRequest listDevicesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDevicesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDevices").withMarshaller((Marshaller)new ListDevicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDevicesRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UnclaimDeviceResponse> unclaimDevice(UnclaimDeviceRequest unclaimDeviceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UnclaimDeviceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UnclaimDevice").withMarshaller((Marshaller)new UnclaimDeviceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)unclaimDeviceRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateDeviceStateResponse> updateDeviceState(UpdateDeviceStateRequest updateDeviceStateRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDeviceStateResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDeviceState").withMarshaller((Marshaller)new UpdateDeviceStateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDeviceStateRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(Iot1ClickDevicesException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("InternalFailureException").exceptionBuilderSupplier(InternalFailureException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PreconditionFailedException").exceptionBuilderSupplier(PreconditionFailedException::builder).httpStatusCode(Integer.valueOf(412)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").exceptionBuilderSupplier(RangeNotSatisfiableException::builder).httpStatusCode(Integer.valueOf(416)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ForbiddenException").exceptionBuilderSupplier(ForbiddenException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceConflictException").exceptionBuilderSupplier(ResourceConflictException::builder).httpStatusCode(Integer.valueOf(409)).build());
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }
}

