/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot1clickdevices;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.iot1clickdevices.Iot1ClickDevicesClient;
import software.amazon.awssdk.services.iot1clickdevices.model.ClaimDevicesByClaimCodeRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.ClaimDevicesByClaimCodeResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.DescribeDeviceRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.DescribeDeviceResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.FinalizeDeviceClaimRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.FinalizeDeviceClaimResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.ForbiddenException;
import software.amazon.awssdk.services.iot1clickdevices.model.GetDeviceMethodsRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.GetDeviceMethodsResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.InitiateDeviceClaimRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.InitiateDeviceClaimResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.InternalFailureException;
import software.amazon.awssdk.services.iot1clickdevices.model.InvalidRequestException;
import software.amazon.awssdk.services.iot1clickdevices.model.InvokeDeviceMethodRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.InvokeDeviceMethodResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.Iot1ClickDevicesException;
import software.amazon.awssdk.services.iot1clickdevices.model.ListDeviceEventsRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.ListDeviceEventsResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.ListDevicesRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.ListDevicesResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.PreconditionFailedException;
import software.amazon.awssdk.services.iot1clickdevices.model.RangeNotSatisfiableException;
import software.amazon.awssdk.services.iot1clickdevices.model.ResourceConflictException;
import software.amazon.awssdk.services.iot1clickdevices.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iot1clickdevices.model.TagResourceRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.TagResourceResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.UnclaimDeviceRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.UnclaimDeviceResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.UntagResourceRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.UntagResourceResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.UpdateDeviceStateRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.UpdateDeviceStateResponse;
import software.amazon.awssdk.services.iot1clickdevices.transform.ClaimDevicesByClaimCodeRequestMarshaller;
import software.amazon.awssdk.services.iot1clickdevices.transform.DescribeDeviceRequestMarshaller;
import software.amazon.awssdk.services.iot1clickdevices.transform.FinalizeDeviceClaimRequestMarshaller;
import software.amazon.awssdk.services.iot1clickdevices.transform.GetDeviceMethodsRequestMarshaller;
import software.amazon.awssdk.services.iot1clickdevices.transform.InitiateDeviceClaimRequestMarshaller;
import software.amazon.awssdk.services.iot1clickdevices.transform.InvokeDeviceMethodRequestMarshaller;
import software.amazon.awssdk.services.iot1clickdevices.transform.ListDeviceEventsRequestMarshaller;
import software.amazon.awssdk.services.iot1clickdevices.transform.ListDevicesRequestMarshaller;
import software.amazon.awssdk.services.iot1clickdevices.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.iot1clickdevices.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.iot1clickdevices.transform.UnclaimDeviceRequestMarshaller;
import software.amazon.awssdk.services.iot1clickdevices.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.iot1clickdevices.transform.UpdateDeviceStateRequestMarshaller;

@SdkInternalApi
final class DefaultIot1ClickDevicesClient
implements Iot1ClickDevicesClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultIot1ClickDevicesClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "iot1click";
    }

    @Override
    public ClaimDevicesByClaimCodeResponse claimDevicesByClaimCode(ClaimDevicesByClaimCodeRequest claimDevicesByClaimCodeRequest) throws InvalidRequestException, InternalFailureException, ForbiddenException, AwsServiceException, SdkClientException, Iot1ClickDevicesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ClaimDevicesByClaimCodeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ClaimDevicesByClaimCodeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ClaimDevicesByClaimCode").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)claimDevicesByClaimCodeRequest).withMarshaller((Marshaller)new ClaimDevicesByClaimCodeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeDeviceResponse describeDevice(DescribeDeviceRequest describeDeviceRequest) throws ResourceNotFoundException, InvalidRequestException, InternalFailureException, AwsServiceException, SdkClientException, Iot1ClickDevicesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDeviceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeDeviceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDevice").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDeviceRequest).withMarshaller((Marshaller)new DescribeDeviceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public FinalizeDeviceClaimResponse finalizeDeviceClaim(FinalizeDeviceClaimRequest finalizeDeviceClaimRequest) throws ResourceNotFoundException, InvalidRequestException, InternalFailureException, PreconditionFailedException, ResourceConflictException, AwsServiceException, SdkClientException, Iot1ClickDevicesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, FinalizeDeviceClaimResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (FinalizeDeviceClaimResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("FinalizeDeviceClaim").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)finalizeDeviceClaimRequest).withMarshaller((Marshaller)new FinalizeDeviceClaimRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetDeviceMethodsResponse getDeviceMethods(GetDeviceMethodsRequest getDeviceMethodsRequest) throws ResourceNotFoundException, InvalidRequestException, InternalFailureException, AwsServiceException, SdkClientException, Iot1ClickDevicesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDeviceMethodsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetDeviceMethodsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDeviceMethods").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDeviceMethodsRequest).withMarshaller((Marshaller)new GetDeviceMethodsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public InitiateDeviceClaimResponse initiateDeviceClaim(InitiateDeviceClaimRequest initiateDeviceClaimRequest) throws ResourceNotFoundException, InvalidRequestException, InternalFailureException, ResourceConflictException, AwsServiceException, SdkClientException, Iot1ClickDevicesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, InitiateDeviceClaimResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (InitiateDeviceClaimResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("InitiateDeviceClaim").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)initiateDeviceClaimRequest).withMarshaller((Marshaller)new InitiateDeviceClaimRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public InvokeDeviceMethodResponse invokeDeviceMethod(InvokeDeviceMethodRequest invokeDeviceMethodRequest) throws InvalidRequestException, PreconditionFailedException, InternalFailureException, ResourceNotFoundException, RangeNotSatisfiableException, ResourceConflictException, AwsServiceException, SdkClientException, Iot1ClickDevicesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, InvokeDeviceMethodResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (InvokeDeviceMethodResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("InvokeDeviceMethod").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)invokeDeviceMethodRequest).withMarshaller((Marshaller)new InvokeDeviceMethodRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListDeviceEventsResponse listDeviceEvents(ListDeviceEventsRequest listDeviceEventsRequest) throws ResourceNotFoundException, RangeNotSatisfiableException, InvalidRequestException, InternalFailureException, AwsServiceException, SdkClientException, Iot1ClickDevicesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDeviceEventsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListDeviceEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDeviceEvents").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDeviceEventsRequest).withMarshaller((Marshaller)new ListDeviceEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListDevicesResponse listDevices(ListDevicesRequest listDevicesRequest) throws RangeNotSatisfiableException, InvalidRequestException, InternalFailureException, AwsServiceException, SdkClientException, Iot1ClickDevicesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDevicesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListDevicesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDevices").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDevicesRequest).withMarshaller((Marshaller)new ListDevicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, InternalFailureException, AwsServiceException, SdkClientException, Iot1ClickDevicesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException, InvalidRequestException, InternalFailureException, AwsServiceException, SdkClientException, Iot1ClickDevicesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UnclaimDeviceResponse unclaimDevice(UnclaimDeviceRequest unclaimDeviceRequest) throws ResourceNotFoundException, InvalidRequestException, InternalFailureException, AwsServiceException, SdkClientException, Iot1ClickDevicesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UnclaimDeviceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UnclaimDeviceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UnclaimDevice").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)unclaimDeviceRequest).withMarshaller((Marshaller)new UnclaimDeviceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException, InvalidRequestException, InternalFailureException, AwsServiceException, SdkClientException, Iot1ClickDevicesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateDeviceStateResponse updateDeviceState(UpdateDeviceStateRequest updateDeviceStateRequest) throws ResourceNotFoundException, InvalidRequestException, InternalFailureException, AwsServiceException, SdkClientException, Iot1ClickDevicesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDeviceStateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateDeviceStateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDeviceState").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDeviceStateRequest).withMarshaller((Marshaller)new UpdateDeviceStateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(Iot1ClickDevicesException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("InternalFailureException").exceptionBuilderSupplier(InternalFailureException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PreconditionFailedException").exceptionBuilderSupplier(PreconditionFailedException::builder).httpStatusCode(Integer.valueOf(412)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").exceptionBuilderSupplier(RangeNotSatisfiableException::builder).httpStatusCode(Integer.valueOf(416)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ForbiddenException").exceptionBuilderSupplier(ForbiddenException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceConflictException").exceptionBuilderSupplier(ResourceConflictException::builder).httpStatusCode(Integer.valueOf(409)).build());
    }

    public void close() {
        this.clientHandler.close();
    }
}

