/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot1clickdevices.model;

import static java.util.stream.Collectors.toList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ___listOfDeviceEventCopier {
    static List<DeviceEvent> copy(Collection<DeviceEvent> __listOfDeviceEventParam) {
        if (__listOfDeviceEventParam == null || __listOfDeviceEventParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<DeviceEvent> __listOfDeviceEventParamCopy = new ArrayList<>(__listOfDeviceEventParam);
        return Collections.unmodifiableList(__listOfDeviceEventParamCopy);
    }

    static List<DeviceEvent> copyFromBuilder(Collection<? extends DeviceEvent.Builder> __listOfDeviceEventParam) {
        if (__listOfDeviceEventParam == null) {
            return null;
        }
        return copy(__listOfDeviceEventParam.stream().map(DeviceEvent.Builder::build).collect(toList()));
    }
}
