/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot1clickdevices.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iot1clickdevices.model.DeviceAttributesCopier;
import software.amazon.awssdk.services.iot1clickdevices.model.___mapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeviceDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeviceDescription> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DeviceDescription.getter(DeviceDescription::arn)).setter(DeviceDescription.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Attributes").getter(DeviceDescription.getter(DeviceDescription::attributes)).setter(DeviceDescription.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceId").getter(DeviceDescription.getter(DeviceDescription::deviceId)).setter(DeviceDescription.setter(Builder::deviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceId").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(DeviceDescription.getter(DeviceDescription::enabled)).setter(DeviceDescription.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final SdkField<Double> REMAINING_LIFE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("RemainingLife").getter(DeviceDescription.getter(DeviceDescription::remainingLife)).setter(DeviceDescription.setter(Builder::remainingLife)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remainingLife").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(DeviceDescription.getter(DeviceDescription::type)).setter(DeviceDescription.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(DeviceDescription.getter(DeviceDescription::tags)).setter(DeviceDescription.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ATTRIBUTES_FIELD, DEVICE_ID_FIELD, ENABLED_FIELD, REMAINING_LIFE_FIELD, TYPE_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final Map<String, String> attributes;
    private final String deviceId;
    private final Boolean enabled;
    private final Double remainingLife;
    private final String type;
    private final Map<String, String> tags;

    private DeviceDescription(BuilderImpl builder) {
        this.arn = builder.arn;
        this.attributes = builder.attributes;
        this.deviceId = builder.deviceId;
        this.enabled = builder.enabled;
        this.remainingLife = builder.remainingLife;
        this.type = builder.type;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public final String deviceId() {
        return this.deviceId;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final Double remainingLife() {
        return this.remainingLife;
    }

    public final String type() {
        return this.type;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.remainingLife());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceDescription)) {
            return false;
        }
        DeviceDescription other = (DeviceDescription)obj;
        return Objects.equals(this.arn(), other.arn()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.deviceId(), other.deviceId()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.remainingLife(), other.remainingLife()) && Objects.equals(this.type(), other.type()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"DeviceDescription").add("Arn", (Object)this.arn()).add("Attributes", this.hasAttributes() ? this.attributes() : null).add("DeviceId", (Object)this.deviceId()).add("Enabled", (Object)this.enabled()).add("RemainingLife", (Object)this.remainingLife()).add("Type", (Object)this.type()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "DeviceId": {
                return Optional.ofNullable(clazz.cast(this.deviceId()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "RemainingLife": {
                return Optional.ofNullable(clazz.cast(this.remainingLife()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeviceDescription, T> g) {
        return obj -> g.apply((DeviceDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private String deviceId;
        private Boolean enabled;
        private Double remainingLife;
        private String type;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceDescription model) {
            this.arn(model.arn);
            this.attributes(model.attributes);
            this.deviceId(model.deviceId);
            this.enabled(model.enabled);
            this.remainingLife(model.remainingLife);
            this.type(model.type);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = DeviceAttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = DeviceAttributesCopier.copy(attributes);
        }

        public final String getDeviceId() {
            return this.deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Double getRemainingLife() {
            return this.remainingLife;
        }

        @Override
        public final Builder remainingLife(Double remainingLife) {
            this.remainingLife = remainingLife;
            return this;
        }

        public final void setRemainingLife(Double remainingLife) {
            this.remainingLife = remainingLife;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        public DeviceDescription build() {
            return new DeviceDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeviceDescription> {
        public Builder arn(String var1);

        public Builder attributes(Map<String, String> var1);

        public Builder deviceId(String var1);

        public Builder enabled(Boolean var1);

        public Builder remainingLife(Double var1);

        public Builder type(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

