/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot1clickdevices.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDeviceEventsResponse extends Iot1ClickDevicesResponse implements
        ToCopyableBuilder<ListDeviceEventsResponse.Builder, ListDeviceEventsResponse> {
    private static final SdkField<List<DeviceEvent>> EVENTS_FIELD = SdkField
            .<List<DeviceEvent>> builder(MarshallingType.LIST)
            .memberName("Events")
            .getter(getter(ListDeviceEventsResponse::events))
            .setter(setter(Builder::events))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("events").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeviceEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeviceEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListDeviceEventsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(EVENTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<DeviceEvent> events;

    private final String nextToken;

    private ListDeviceEventsResponse(BuilderImpl builder) {
        super(builder);
        this.events = builder.events;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Events property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasEvents() {
        return events != null && !(events instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of zero or more elements describing the event(s) associated with the device.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEvents()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of zero or more elements describing the event(s) associated with the device.
     */
    public final List<DeviceEvent> events() {
        return events;
    }

    /**
     * <p>
     * The token to retrieve the next set of results.
     * </p>
     * 
     * @return The token to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEvents() ? events() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeviceEventsResponse)) {
            return false;
        }
        ListDeviceEventsResponse other = (ListDeviceEventsResponse) obj;
        return hasEvents() == other.hasEvents() && Objects.equals(events(), other.events())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDeviceEventsResponse").add("Events", hasEvents() ? events() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Events":
            return Optional.ofNullable(clazz.cast(events()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDeviceEventsResponse, T> g) {
        return obj -> g.apply((ListDeviceEventsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Iot1ClickDevicesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDeviceEventsResponse> {
        /**
         * <p>
         * An array of zero or more elements describing the event(s) associated with the device.
         * </p>
         * 
         * @param events
         *        An array of zero or more elements describing the event(s) associated with the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Collection<DeviceEvent> events);

        /**
         * <p>
         * An array of zero or more elements describing the event(s) associated with the device.
         * </p>
         * 
         * @param events
         *        An array of zero or more elements describing the event(s) associated with the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(DeviceEvent... events);

        /**
         * <p>
         * An array of zero or more elements describing the event(s) associated with the device.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DeviceEvent>.Builder} avoiding the need to
         * create one manually via {@link List<DeviceEvent>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DeviceEvent>.Builder#build()} is called immediately and its
         * result is passed to {@link #events(List<DeviceEvent>)}.
         * 
         * @param events
         *        a consumer that will call methods on {@link List<DeviceEvent>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #events(List<DeviceEvent>)
         */
        Builder events(Consumer<DeviceEvent.Builder>... events);

        /**
         * <p>
         * The token to retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Iot1ClickDevicesResponse.BuilderImpl implements Builder {
        private List<DeviceEvent> events = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeviceEventsResponse model) {
            super(model);
            events(model.events);
            nextToken(model.nextToken);
        }

        public final List<DeviceEvent.Builder> getEvents() {
            List<DeviceEvent.Builder> result = ___listOfDeviceEventCopier.copyToBuilder(this.events);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder events(Collection<DeviceEvent> events) {
            this.events = ___listOfDeviceEventCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(DeviceEvent... events) {
            events(Arrays.asList(events));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Consumer<DeviceEvent.Builder>... events) {
            events(Stream.of(events).map(c -> DeviceEvent.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEvents(Collection<DeviceEvent.BuilderImpl> events) {
            this.events = ___listOfDeviceEventCopier.copyFromBuilder(events);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDeviceEventsResponse build() {
            return new ListDeviceEventsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
