/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot1clickdevices.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class Device implements SdkPojo, Serializable, ToCopyableBuilder<Device.Builder, Device> {
    private static final SdkField<Attributes> ATTRIBUTES_FIELD = SdkField.<Attributes> builder(MarshallingType.SDK_POJO)
            .memberName("Attributes").getter(getter(Device::attributes)).setter(setter(Builder::attributes))
            .constructor(Attributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build()).build();

    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceId").getter(getter(Device::deviceId)).setter(setter(Builder::deviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Device::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD,
            DEVICE_ID_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Attributes attributes;

    private final String deviceId;

    private final String type;

    private Device(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.deviceId = builder.deviceId;
        this.type = builder.type;
    }

    /**
     * <p>
     * The user specified attributes associated with the device for an event.
     * </p>
     * 
     * @return The user specified attributes associated with the device for an event.
     */
    public final Attributes attributes() {
        return attributes;
    }

    /**
     * <p>
     * The unique identifier of the device.
     * </p>
     * 
     * @return The unique identifier of the device.
     */
    public final String deviceId() {
        return deviceId;
    }

    /**
     * <p>
     * The device type, such as "button".
     * </p>
     * 
     * @return The device type, such as "button".
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        hashCode = 31 * hashCode + Objects.hashCode(deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Device)) {
            return false;
        }
        Device other = (Device) obj;
        return Objects.equals(attributes(), other.attributes()) && Objects.equals(deviceId(), other.deviceId())
                && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Device").add("Attributes", attributes()).add("DeviceId", deviceId()).add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "DeviceId":
            return Optional.ofNullable(clazz.cast(deviceId()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Device, T> g) {
        return obj -> g.apply((Device) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Device> {
        /**
         * <p>
         * The user specified attributes associated with the device for an event.
         * </p>
         * 
         * @param attributes
         *        The user specified attributes associated with the device for an event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Attributes attributes);

        /**
         * <p>
         * The user specified attributes associated with the device for an event.
         * </p>
         * This is a convenience method that creates an instance of the {@link Attributes.Builder} avoiding the need to
         * create one manually via {@link Attributes#builder()}.
         *
         * When the {@link Consumer} completes, {@link Attributes.Builder#build()} is called immediately and its result
         * is passed to {@link #attributes(Attributes)}.
         * 
         * @param attributes
         *        a consumer that will call methods on {@link Attributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(Attributes)
         */
        default Builder attributes(Consumer<Attributes.Builder> attributes) {
            return attributes(Attributes.builder().applyMutation(attributes).build());
        }

        /**
         * <p>
         * The unique identifier of the device.
         * </p>
         * 
         * @param deviceId
         *        The unique identifier of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceId(String deviceId);

        /**
         * <p>
         * The device type, such as "button".
         * </p>
         * 
         * @param type
         *        The device type, such as "button".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private Attributes attributes;

        private String deviceId;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Device model) {
            attributes(model.attributes);
            deviceId(model.deviceId);
            type(model.type);
        }

        public final Attributes.Builder getAttributes() {
            return attributes != null ? attributes.toBuilder() : null;
        }

        public final void setAttributes(Attributes.BuilderImpl attributes) {
            this.attributes = attributes != null ? attributes.build() : null;
        }

        @Override
        public final Builder attributes(Attributes attributes) {
            this.attributes = attributes;
            return this;
        }

        public final String getDeviceId() {
            return deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public Device build() {
            return new Device(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
